/*
 * Module:       com.unisys.bis.BISException.java
 *
 * Description:  BISException class
 *
 * Product:      Resource Adapter for BIS
 *
 * Date:         December, 2004
 *
 * Copyright (c) 2005 Unisys Corporation.
 *
 * All rights reserved.
 *
 * UNISYS CONFIDENTIAL
 */

package com.unisys.bis;
/**
 * The BISException class is the base class for all exceptions generated by the resource adapter.  
 * Currently, this class has no implementation that is different from the Exception class.  The 
 * main purpose for defining this class is to provide a way for application components to catch 
 * exceptions generated by this resource adapter.
 * 
 * @author lamberna
 *
 */
/*
 * Note:  The interfaces defined in the JCA 1.5 specification documents exceptions based 
 * on the ResourceException class.  In general, the ResourceException class will be used 
 * to wrap a BISException, taking advantage of the chained exception facility defined in 
 * the Throwable class. 
 */
public class BISException extends Exception {

    /**
     * Class constructor with no message argument.
     * 
     */
    public BISException() {
        super();
     }

    /**
     * Class constuctor with a message argument.
     * 
     * @param message a message with pertinent information.
     * 
     */
    public BISException( String message ) {
        super( message );
    }

    /**
     * Class constructor with a throwable cause argument.
     * 
     * @param cause another throwable that caused this throwable.
     * 
     */
    public BISException( Throwable cause ) {
        super( cause );
    }

    /**
     * Class constuctor with a message argument and a throwable cause argument.
     * 
     * @param message a message with pertinent information.
     * @param cause another throwable that caused this throwable.
     * 
     */
    public BISException(String message, Throwable cause) {
        super(message, cause);
    }

}
