/*
 * Module:       com.unisys.bis.BISDatasetMetaData.java
 *
 * Description:  BISDatasetMetaData interface
 *
 * Product:      Resource Adapter for BIS
 *
 * Date:         February, 2005
 *
 * Copyright (c) 2005 Unisys Corporation.
 *
 * All rights reserved.
 *
 * UNISYS CONFIDENTIAL
 */

package com.unisys.bis;

/**
 * The BISDataset interface defines the methods used to access the metadata 
 * associated with a BIS dataset.
 * 
 * @author lamberna
 * 
 */
public interface BISDatasetMetaData {
    
    /**
     * Called to get the number of column in each dataset record.
     * 
     * @return the number of columns
     */
    public int getColumnCount();
    
    /**
     * Called to get the name of the designated column.
     * 
     * @param columnIndex an integer value that identifies a column.  The first column is 1.
     * 
     * @return column name.
     * 
     * @throws BISException  thrown if the columnIndex is not valid.
     * 
     */
    public String getColumnName(int columnIndex) throws BISException;

    /**
     * Called to get the maximum size of the designated column.
     * 
     * @param columnIndex an integer value that identifies a column.  The first column is 1.
     * 
     * @return maximum column size.
     * 
     * @throws BISException -  thrown if the columnIndex is not valid.
     * 
     */
    public int getColumnSize(int columnIndex) throws BISException;
}
