/*
 * Module:       com.unisys.bis.BISConnectionFactory.java
 *
 * Description:  BISConnectionFactory interface
 *
 * Product:      Resource Adapter for BIS
 *
 * Date:         December, 2004
 *
 * Copyright (c) 2005 Unisys Corporation.
 *
 * All rights reserved.
 *
 * UNISYS CONFIDENTIAL
 */

package com.unisys.bis;

/**
 * The BISConnectionFactory interface defines the methods used to acquire a BISConnection instance.
 * 
 * @author lamberna
 * 
 */
public interface BISConnectionFactory {
    
    /**
     * Called to get a connection to a BIS system.  This getConnection variant should be called when an 
     * application component is configured to use container-managed sign-on, or if a sign-on mechanism 
     * has not been specified, in which case the sign-on credentials specified in the resource adapter 
     * deployment descriptor will be used.
     * 
     * @return a BISConnection instance.
     * 
     * @throws BISException - thrown if a connection to BIS could not be established.
     * 
     */
    public BISConnection getConnection() throws BISException;
    
    /**
     * Called to get a connection to a BIS system.  This getConnection variant should be called when an 
     * application component is configured to use component-managed sign-on.
     * 
     * @param userName user name used for BIS authentication.
     * @param department department used for BIS authentication.
     * @param password password used for BIS authentication. Note: Passwords sent from the 
     * Business Information Server Resource Adapter to the JBIS Server are encrypted to help 
     * prevent unauthorized access to a server.
     * 
     * @return a BISConnection instance
     * 
     * @throws BISException - thrown if a connection to BIS could not be established.
     * 
     */
    public BISConnection getConnection(String userName, String department,
            String password) throws BISException;
}