/*
 * Module:       com.unisys.bis.BISClob.java
 *
 * Description:  BISClob interface
 *
 * Product:      Resource Adapter for BIS
 *
 * Date:         May, 2005
 *
 * Copyright (c) 2005 Unisys Corporation.
 *
 * All rights reserved.
 *
 * UNISYS CONFIDENTIAL
 */

package com.unisys.bis;

import java.io.InputStream;

/**
 * The BISClob interface defines the methods used to access a character dataset as a stream of bytes.
 * 
 * @author lamberna
 *
 */
public interface BISClob {
    /**
     * Called to close a CLOB.  This will cause all locks and other resource associated with the 
     * CLOB to be released.
     * 
     * @throws BISException - thrown if a CLOB can not be closed.
     */
    public void close() throws BISException;
    
    /**
     * Called to get an InputStream instance that is used to read a character dataset as a 
     * stream of bytes.
     * 
     * @return an InputStream instance.
     * 
     * @throws BISException  thrown if an error occurs while getting an InputStream.
     */
    public InputStream getInputStream() throws BISException;
    
    /**
     * Called to get the MIME type associated with the character dataset.
     * 
     * @return a MIME type string value (See http://www.iana.org/assignments/media-types/ 
     * for more information on commonly used MIME type values).
     * 
     * @throws BISException  thrown if an error occurs while getting a MIME type value.
     */
    public String getMIMEType() throws BISException;
}
