/*
 * Module:       com.unisys.bis.BISBlob.java
 *
 * Description:  BISBlob interface
 *
 * Product:      Resource Adapter for BIS
 *
 * Date:         May, 2005
 *
 * Copyright (c) 2005 Unisys Corporation.
 *
 * All rights reserved.
 *
 * UNISYS CONFIDENTIAL
 */

package com.unisys.bis;

import java.io.InputStream;

/**
 * The BISBlob interface defines the methods used to access a binary dataset as a stream of bytes.
 * 
 * @author lamberna
 *
 */
public interface BISBlob {
    /**
     * Called to close a BLOB.  This will cause all locks and other resource associated with the 
     * BLOB to be released.
     * 
     * @throws BISException - thrown if a BLOB can not be closed.
     */
    public void close() throws BISException;
    
    /**
     * Called to get an InputStream instance that is used to read a binary dataset as a stream 
     * of bytes.
     * 
     * @return an InputStream instance.
     * 
     * @throws BISException - thrown if an error occurs while getting an InputStream.
     */
    public InputStream getInputStream() throws BISException;
    
    /**
     * Called to get the MIME type associated with the binary dataset.
     * 
     * @return a MIME type string value (See http://www.iana.org/assignments/media-types/ 
     * for more information on commonly used MIME type values).
     * 
     * @throws BISException  thrown if an error occurs while getting a MIME type value.
     */
    public String getMIMEType() throws BISException;
}
