/*
 * Module:       com.unisys.os2200.dms.DMSXAConnectionFactory.java
 *
 * Description:  Interface which defines the methods used to acquire a DMSXAConnection instance.  
 *               This interface should be used when participating in a global transaction.
 *               
 * Product:      Resource Adapter for DMS
 *
 * Date:         May, 2007
 *
 * Copyright (c) 2008 Unisys Corporation.
 *
 * All rights reserved.
 *
 * UNISYS CONFIDENTIAL
 */

package com.unisys.os2200.dms;

/**
 * The DMSXAConnectionFactory interface defines the methods used to acquire a DMSXAConnection instance.  
 * This interface should be used when participating in a global transaction.
 */
public interface DMSXAConnectionFactory {
    
    /**
     * Called to get a connection to a DMS system.  This getConnection variant should be called when an 
     * application component is configured to use container-managed sign-on, or if a sign-on mechanism 
     * has not been specified, in which case the sign-on credentials specified in the resource adapter 
     * deployment descriptor will be used.
     * 
     * @return a DMSXAConnection instance
     * @throws DMSException  thrown if a connection to DMS could not be established
     */
    public DMSXAConnection getConnection() throws DMSException;

    /**
     * Called to get a connection to a DMS system.  This getConnection variant should be called when an 
     * application component is configured to use component-managed sign-on.
     * 
     * @param userName userName used to access the DMS server
     * @param password password used to access the DMS server
     * @return a DMSXAConnection instance
     * @throws DMSException  thrown if a connection to DMS could not be established
     */
    public DMSXAConnection getConnection(String userName,
                                         String password)
                                  throws DMSException;
    
}
