/*
* Module:       com.unisys.os2200.DMSRecordNotFoundException.java
*
* Description:  The DMSRecordNotFoundException class extends the DMSException class.  
*               This exception is thrown when the requested record is not found in the database.
* 
* Product:      Resource Adapter for DMS
*
* Date:         April, 2006
*
* Copyright (c) 2006 Unisys Corporation.
*
* All rights reserved.
*
* UNISYS CONFIDENTIAL
*/
package com.unisys.os2200.dms;

/**
 * The DMSRecordNotFoundException class extends the DMSException class.
 * This exception is thrown when the requested record is not found in the database.
 */
public final class DMSRecordNotFoundException extends DMSException {

    // Universal version identifier for a Serializable class
    static final long serialVersionUID = -7155610647084281555L;

    /**
     * Class constructor with no arguments.
     */
    public DMSRecordNotFoundException() {
        super();
    }

    /**
     * Class constructor with a message parameter.
     * @param message error message text
     */
    public DMSRecordNotFoundException(String message) {
        super(message);
    }

    /**
     * Class constructor with a Throwable parameter.
     * @param cause a Throwable instance that describes the original cause of the exception.
     */
    public DMSRecordNotFoundException(Throwable cause) {
        super(cause);
    }

    /**
     * Class constructor with message and Throwable parameters.
     * @param message error message text
     * @param cause a Throwable instance that describes the original cause of the exception.
     */
    public DMSRecordNotFoundException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Class constructor with property parameters.
     * @param errorStatus the JDMS server error status
     * @param errorCode the DMR error code
     * @param rollbackErrorCode the DMS rollback error code
     * @param errorCommand the identifier of the command that caused an error
     */
    public DMSRecordNotFoundException(int errorStatus, 
                                      int errorCode,
                                      int rollbackErrorCode, 
                                      int errorCommand) {
        super(errorStatus, errorCode, rollbackErrorCode, errorCommand);
    }

    /**
     * Class constructor with a message parameter and property parameters.
     * @param message error message text
     * @param errorStatus the JDMS server error status
     * @param errorCode the DMR error code
     * @param rollbackErrorCode the DMS rollback error code
     * @param errorCommand the identifier of the command that caused an error
     */
    public DMSRecordNotFoundException(String message, 
                                      int errorStatus,
                                      int errorCode, 
                                      int rollbackErrorCode, 
                                      int errorCommand) {
        super(message, errorStatus, errorCode, rollbackErrorCode, errorCommand);
    }

    /**
     * Class constructor with a message parameter, a Throwable parameter and property parameters.
     * @param message error message text
     * @param cause a Throwable instance that describes the original cause of the exception.
     * @param errorStatus the JDMS server error status
     * @param errorCode the DMR error code
     * @param rollbackErrorCode the DMS rollback error code
     * @param errorCommand the identifier of the command that caused an error
     */
    public DMSRecordNotFoundException(String message, 
                                      Throwable cause,
                                      int errorStatus, 
                                      int errorCode, 
                                      int rollbackErrorCode,
                                      int errorCommand) {
        super(message, cause, errorStatus, errorCode, rollbackErrorCode, errorCommand);
    }
}
