/*
* Module:       com.unisys.os2200.dms.DMSIndexSequentialRecordList.java
*
* Description:  The DMSIndexSequentialRecordList interface is used to access records 
*               of a specific type, those which have a location mode of Index Sequential. 
*               
* Product:      Resource Adapter for DMS
*
* Date:         April, 2006
*
* Copyright (c) 2006 Unisys Corporation.
*
* All rights reserved.
*
* UNISYS CONFIDENTIAL
*/

package com.unisys.os2200.dms;

/**
 * The DMSIndexSequentialRecordList interface is used to access records of a specific type,
 * those which have a location mode of Index Sequential. 
 */
public interface DMSIndexSequentialRecordList {

    /**
     * Makes the record with the smallest key (for ascending keys) or the largest key 
     * (for descending keys) the selected record of the index-sequential record list.
     * @return true if the record exists; otherwise returns false
     * @throws DMSException thrown if an error occurs while selecting a record
     */
    public boolean firstRecord()
                        throws DMSException;
	
    /**
     * Gets the selected record of the index-sequential record list.
     * @return a DMSRecord instance
     * @throws DMSException thrown if a record in the index-sequential record list has not been selected
     */
    public DMSRecord getSelectedRecord()
                                throws DMSException;
	
    /**
     * Makes the record with the largest key (for ascending keys) or the smallest key
     * (for descending keys) the selected record of the index-sequential record list.
     * @return true if the record exists; otherwise returns false
     * @throws DMSException thrown if an error occurs while selecting a record
     */
    public boolean lastRecord()
                       throws DMSException;
	
    /**
     * Makes the next logical record the selected record, which has key(s) that equals the key(s)
     * of the currently selected record of the index-sequential record list.
     * @return true if the record exists; otherwise returns false
     * @throws DMSException thrown if an error occurs while selecting a record
     */
    public boolean nextDuplicateRecord()
                                throws DMSException;
	
    /**
     * Makes the record with the next higher key (for ascending keys) or the next smaller key 
     * (for descending keys) the selected record of the index-sequential record list.
     * @return true if the record exists; otherwise returns false
     * @throws DMSException thrown if an error occurs while selecting a record
     */
    public boolean nextRecord()
                       throws DMSException;
	
    /**
     * Makes the record with the next smaller key (for ascending keys) or the next larger key 
     * (for descending keys) the selected record of the index-sequential record list.
     * @return true if the record exists; otherwise returns false
     * @throws DMSException thrown if an error occurs while selecting a record
     */
    public boolean previousRecord()
                           throws DMSException;
    
    /**
     * Makes the record associated with the specified databaseKey the selected record 
     * of the index-sequential record list.
     * @param databaseKey a DMSDatabaseKey instance
     * @throws DMSException thrown if an error occurs while selecting a record
     * @throws IllegalArgumentException  thrown if the databaseKey argument is null
     */
    public void setSelectedRecord(DMSDatabaseKey databaseKey)
                           throws DMSException;
    
    /**
     * Makes the specified record the selected record of the index-sequential record list.
     * @param record a DMSRecord instance
     * @throws DMSException thrown if an error occurs while selecting a record
     * @throws IllegalArgumentException  thrown if the record argument is null
     */
    public void setSelectedRecord(DMSRecord record)
                           throws DMSException;
		
}
