/*
* Module:       com.unisys.os2200.dms.DMSDatabaseKey.java
*
* Description:  The DMSDatabaseKey interface defines the methods used to retrieve records from an area.
*               
* Product:      Resource Adapter for DMS
*
* Date:         April, 2006
*
* Copyright (c) 2009 Unisys Corporation.
*
* All rights reserved.
*
* UNISYS CONFIDENTIAL
*/

package com.unisys.os2200.dms;

/**
 * The DMSDatabaseKey interface provides methods used to acess information associated 
 * with a DMS database key.
 */
public interface DMSDatabaseKey {

    /**
     * Compares this DMSDatabaseKey instance with the specified DMSDatabaseKey instance.
     * @param databaseKey a DMSDatabaseKey instance
     * @return zero if the database keys are equal, a value less than zero if this database key
     * is numerically less than the specified database key, or a value greater than zero if this
     * database key is numerically greater than the specified database key
     * @throws DMSException thrown if an error occurs while comparing the object instances
     * @throws IllegalArgumentException thrown if the databaseKey argument is null
     */
    public int compareTo(DMSDatabaseKey databaseKey)
                  throws DMSException;
	
    /**
     * Compares this DMSDatabaseKey instance with the specified DMSDatabaseKey instance.
     * @param databaseKey a DMSDatabaseKey instance
     * @return true if the DMSDatabaseKey instances are equal; otherwise returns false
     * @throws IllegalArgumentException thrown if the databaseKey argument is null
     */
    public boolean equals(DMSDatabaseKey databaseKey);
	
    /**
     * Gets the subschema area identifier associated with the database key.
     * @return an area identifier
     * @throws DMSException thrown if an error occurs while getting the area identifier
     */
    public int getAreaID()
                  throws DMSException;
	
    /* Gets the name of the area associated with the database key.
     * @return the name of an area
     * @throws DMSException thrown if an error occurs while getting the area name
     */
    public String getAreaName()
                       throws DMSException;
    
    /**
     * Gets the database key as a long value.
     * @return the database key as a long value.
     * @throws DMSException thrown if an error occurs while getting the database key
     */
    public long getDatabaseKey()
                        throws DMSException;
    	
    /**
     * Gets the page number associated with the database key.
     * @return a page number
     * @throws DMSException thrown if an error occurs while getting the page number
     */
    public int getPageNumber()
                      throws DMSException;
	
    /**
     * Gets the record number associated with the database key.
     * @return a record number
     * @throws DMSException thrown if an error occurs while getting the record number
     */
    public int getRecordNumber()
                        throws DMSException;
	
}
