/* 
* Module:       com.unisys.os2200.dms.DMSDMCA.java
*
* Description:  The DMSDMCA interface defines the methods used to retrieve information from the 
*               Data Management Communications Area (DMCA).
*               
* Product:      Resource Adapter for DMS
*
* Date:         April, 2006
*
* Copyright (c) 2006 Unisys Corporation.
*
* All rights reserved.
*
* UNISYS CONFIDENTIAL
*/

package com.unisys.os2200.dms;

/**
 * The DMSDMCA interface defines the methods used to retrieve information from the Data Management 
 * Communications Area (DMCA).  The DMR places information in the DMCA that may be of interest to 
 * an application, such as error information when a command fails.
 */
public interface DMSDMCA {
    
    /**
     * Called to get the name of the area that contains the object record, after successfully 
     * retrieving a record.
     * @return an area name
     */
    public String getAreaName();
    
    /**
     * Called to get the chain number returned by the CALC procedure to the DMR when a CALC 
     * record is stored in the database.
     * @return a CALC chain number
     */
    public int getCalcBucket();
    
    /**
     * Called to get the page number returned by the CALC procedure to the DMR when a CALC record 
     * is stored in the database.  This page number and the actual page that contains the CALC record 
     * can differ if space is not available on the prime page.
     * @return a page number
     */
    public int getCalcPrimePage();
    
    /**
     * Called to get the number of DMR tasks that have been performed.
     * @return the number of DMR task performed
     */
    public int getCommandSequenceNumber();
    
    /**
     * Called to get an 8-character identifier of the DMR level.
     * @return the DMR level
     */
    public String getDMRLevel ();
    
    /**
     * Called to get the area name associated with a DMR task error, provided that the 
     * error is area related and the error area is known. 
     * @return an area name
     */
    public String getErrorAreaName();
    
    /**
     * Called to get the identifier of the DMR task that caused an error.
     * @return a function identifier
     */
    public int getErrorFunction();
    
    /**
     * Called to get the item name that did not pass the CHECK procedure, which ensures 
     * that data values stored or modified are in a particular range.
     * @param index error item index.  The first error item is 0.
     * @return an item name
     * @throws DMSException - thrown if no error items exist.
     */
    public String getErrorItem(int index) throws DMSException;
    
    /**
     * Called to get the error number.  If a DMR task completes successfully, the error number 
     * is 0; otherwise, the error number identifies the type of error that has occurred.
     * @return an error number
     */
    public int getErrorNumber();
    
    /**
     * Called to get the record name associated with a DMR task error, provided that the error 
     * is record related and the error record is known. 
     * @return a record name
     */
    public String getErrorRecordName();
    
    /**
     * Called to get the recordSet name associated with a DMR task error, provided that the error 
     * is recordSet related and the error recordSet is known.
     * @return a recordSet name
     */
    public String getErrorRecordSetName();
    
    /**
     * Called to get the facility reject error statuses for the files ILPAWS, PABSF$ and SYS$*DATA$.
     * @return a facility reject status
     */
    public long getFacilityRejectErrorStatus();
    
    /**
     * Called to get the number of items that failed the CHECK procedure, which ensures that data 
     * values stored or modified are in a particular range.  To get the names of the items, call the 
     * getErrorItem() method.
     * @return the number of items that failed the CHECK procedure
     */
    public int getNumberOfErrorItems();
    
    /**
     * Called to get the page number of the object record after successfully retrieving or 
     * storing a record.
     * @return a page number
     */
    public int getPageNumber();
    
    /**
     * Called to get the priority associated with an application.  When a deadlock occurs, the 
     * application having the lowest priority is selected for rollback processing.
     * @return a priority
     */
    public int getPriority();
    
    /**
     * Called to get the name of the object record, after successfully retrieving or 
     * storing a record. 
     * @return a record name
     */
    public String getRecordName();
    
    /**
     * Called to get the record number of the object record after successfully retrieving or 
     * storing a record.
     * @return a record number
     */
    public int getRecordNumber();
    
    /**
     * Called to get the rollback error code.  If a DMR task causes a rollback to occur, the 
     * rollback error code identifies the cause of the rollback.
     * @return a rollback error code
     */
    public int getRollbackErrorCode();
}

