/*
* Module:       com.unisys.os2200.dms.DMSConnectionFactory.java
*
* Description:  Interface which defines the methods used to acquire a DMSConnection instance.
*               
* Product:      Resource Adapter for DMS
*
* Date:         April, 2006
*
* Copyright (c) 2006 Unisys Corporation.
*
* All rights reserved.
*
* UNISYS CONFIDENTIAL
*/

package com.unisys.os2200.dms;

/** 
 * The DMSConnectionFactory interface defines the methods used to acquire a DMSConnection instance.
 */
public interface DMSConnectionFactory {

    /**
     * Gets a connection to a DMS system.  This variation of this method should be called
     * when an application component is configured to use container-managed sign-on, or if
     * a sign-on mechanism has not been specified, in which case the sign-on credentials
     * specified in the resource adapter deployment descriptor will be used.
     * @return a DMSConnection instance.
     * @throws DMSException - thrown if a connection to DMS could not be established.
     */
    public DMSConnection getConnection()
                                throws DMSException;

    /**
     * Gets a connection to a DMS system.  This variation of this method should be called
     * when an application component is configured to use component-managed sign-on.
     * @param userName user name used for DMS authentication.
     * @param password password used for DMS authentication.
     * @return a DMSConnection instance.
     * @throws DMSException - thrown if a connection to DMS could not be established.
     */
    public DMSConnection getConnection(String userName,
                                       String password)
                                throws DMSException;
                           
}
