/*
* Module:       com.unisys.os2200.dms.DMSArea.java
*
* Description:  The DMSArea interface defines the methods used to retrieve records from an area.
*               
* Product:      Resource Adapter for DMS
*
* Date:         April, 2006
*
* Copyright (c) 2006 Unisys Corporation.
*
* All rights reserved.
*
* UNISYS CONFIDENTIAL
*/

package com.unisys.os2200.dms;

/**
 * The DMSArea interface defines the methods used to retrieve records from an area.
 */
public interface DMSArea {
	
    /**
     * Makes the first record in the area the selected record.
     * @return true if the record exists; otherwise returns false
     * @throws DMSException thrown if an error occurs while selecting a record
     */
    public boolean firstRecord()
                        throws DMSException;
	
    /**
     * Makes the first record of type recordType in the area the selected record.
     * @param recordType the type of record
     * @return true if the record exists; otherwise returns false
     * @throws DMSException thrown if an error occurs while selecting a record
     */
    public boolean firstRecord(int recordType)
                        throws DMSException;
	
    /**
     * Returns the name associated with the area.
     * @return the name associated with the area.
     * @throws DMSException thrown if an error occurs while getting the area name
     */
    public String getAreaName()
                       throws DMSException;
    
    /**
     * Gets the record associated with the specified pageNumber and recordNumber.
     * @param pageNumber identifies a page number in the area
     * @param recordNumber identifies the record number
     * @return a DMSRecord instance
     * @throws DMSException thrown if an error occurs while getting a record
     */
    public DMSRecord getRecord(int pageNumber, int recordNumber)
                        throws DMSException;
	
    /**
     * Get the selected record of an area.
     * @return a DMSRecord instance
     * @throws DMSException thrown if a record in the area has not been selected
     */
    public DMSRecord getSelectedRecord()
                                throws DMSException;
	
    /**
     * Makes the last record in the area the selected record.
     * @return true if the record exists; otherwise returns false
     * @throws DMSException thrown if an error occurs while selecting a record
     */
    public boolean lastRecord()
                       throws DMSException;
	
    /**
     * Makes the last record of type recordType in the area the selected record.
     * @param recordType the type of record
     * @return true if the record exists; otherwise returns false
     * @throws DMSException thrown if an error occurs while selecting a record
     */
    public boolean lastRecord(int recordType)
                       throws DMSException;
	
    /**
     * Makes the next record in the area the selected record.
     * @return true if the record exists; otherwise returns false
     * @throws DMSException thrown if an error occurs while selecting a record
     */
    public boolean nextRecord()
                       throws DMSException;
	
    /**
     * Makes the next record of type recordType in the area the selected record.
     * @param recordType the type of record
     * @return true if the record exists; otherwise return false
     * @throws DMSException thrown if an error occurs while selecting a record
     */
    public boolean nextRecord(int recordType)
                       throws DMSException;
	
    /**
     * Makes the previous record in the area the selected record.
     * @return true if the record exists; otherwise returns false
     * @throws DMSException thrown if an error occurs while selecting a record
     */
    public boolean previousRecord()
                           throws DMSException;
	
    /**
     * Makes the previous record of type recordType in the area the selected record.
     * @param recordType the type of record
     * @return true if the record exists; otherwise return false
     * @throws DMSException thrown if an error occurs while selecting a record
     */
    public boolean previousRecord(int recordType)
                           throws DMSException;
	
    /**
     * Makes the record associated with the specified databaseKey the selected record of the area.
     * @param databaseKey a DMSDatabaseKey instance
     * @throws DMSException thrown if an error occurs while selecting a record
     * @throws IllegalArgumentException  thrown if the databaseKey argument is null
     */
    public void setSelectedRecord(DMSDatabaseKey databaseKey)
                           throws DMSException;	
	
    /**
     * Makes the specified record the selected record of the area.
     * @param record a DMSRecord instance
     * @throws DMSException thrown if an error occurs while selecting a record
     * @throws IllegalArgumentException  thrown if the record argument in null
     */
    public void setSelectedRecord(DMSRecord record)
                           throws DMSException;

}
