// version 14 February 2001 11:30
//
// Unisys JavaScript to give users a meaningful error message when
// HTML-based documentation is viewed in a location or form where 
// links will not or cannot work
//
// This JS will give the user a warning that a link will not work by
// showing the link as lined-through when the user hovers over it and by
// displaying an alert if the link is clicked.
//
// The link is assumed to not work if the current topic is 
// not accessed on the local file system OR not through an HTTP URL OR
// when the project path contains a subdirectory of "HTM" where it is
// assumed that the project is on a PI CD-ROM or the Unisys Support Server
//

var bCheckedLink = 0;

function CheckLink()
{
  var re;
  var s;

  s = location.protocol.substr(0,5).toLowerCase();
  if( s!="file:" && s!="http:" && s!="https" )
  {
    bCheckedLink = 1;
    return;
  }
 
  re = /[\\/]htm[\\/]/i;

  if( re.test( location.pathname ) )
  {
    bCheckedLink = 1;
    return;
  }

  bCheckedLink = 2;  

}

function IsLink()
{
 
  if( bCheckedLink==0 )CheckLink();

  if( bCheckedLink==1 )
  {
    alert( "This link functions only when this file is installed with the application." );
    return false;
  }

  return true;
}

function MsOver()
{
  if( bCheckedLink==0 )CheckLink();
  if( bCheckedLink==2 )return;

  window.event.srcElement.style.textDecoration = "line-through";
}

function MsOut()
{
  if( bCheckedLink==0 )CheckLink();
  if( bCheckedLink==2 )return;

  window.event.srcElement.style.textDecoration = "none";
}
