/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import practicallymacro.commands.EclipseCommand;
import practicallymacro.commands.FindCommand;
import practicallymacro.commands.IMacroCommand;
import practicallymacro.commands.KeystrokeCommand;
import practicallymacro.model.MacroManager;
import practicallymacro.model.MarkUpdater;
import practicallymacro.util.MacroConsole;
import practicallymacro.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroRecorder
implements Listener,
IExecutionListener,
IDocumentListener {
    private IEditorPart mEditor;
    private List<IMacroCommand> mCommands;
    private Set<String> mNonRecordableCommandIds;
    private boolean mCurrentlyExecutingCommand;
    private boolean mRecordCommands;
    private MarkUpdater mMarkUpdater = new MarkUpdater(true);
    private boolean mIncrementalFindMode = false;
    private boolean mIncrementalFindForward = true;
    private Listener[] mPreexecuteListeners = null;
    private Listener mIncrementalListener = null;

    public MacroRecorder(IEditorPart editor) {
        this.mEditor = editor;
        this.mNonRecordableCommandIds = new HashSet<String>();
        this.mNonRecordableCommandIds.add("practicallymacro.actions.recordMacro");
        this.mNonRecordableCommandIds.add("practicallymacro.actions.playCommand");
        this.mNonRecordableCommandIds.add("org.eclipse.ui.edit.findReplace");
        this.mNonRecordableCommandIds.add("practicallymacro.actions.playLastMacro");
    }

    public void start() {
        MacroConsole.getConsole().writeln("***Started macro recording", 3);
        this.mCommands = new ArrayList<IMacroCommand>();
        this.mCurrentlyExecutingCommand = false;
        this.mRecordCommands = true;
    }

    private boolean isBound(Event event) {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        KeyStroke k = KeyStroke.getInstance((int)event.stateMask, (int)event.keyCode);
        if (k == null) {
            return false;
        }
        Binding b = bindingService.getPerfectMatch((TriggerSequence)KeySequence.getInstance((KeyStroke)k));
        return b != null;
    }

    public void stop() {
        this.updateIncrementalFindMode();
        MacroConsole.getConsole().writeln("***Finished recording macro", 3);
    }

    public void handleEvent(Event event) {
        this.updateIncrementalFindMode();
        if (event.type == 1) {
            if (this.isBound(event)) {
                return;
            }
            IMacroCommand command = null;
            command = MacroManager.getManager().isRecordingRawKeystrokes() ? new KeystrokeCommand(event) : Utilities.getCommandForKeyEvent(event);
            if (!this.mIncrementalFindMode && command != null) {
                this.recordCommand(command);
            }
        } else if (event.type == 2 && MacroManager.getManager().isRecordingRawKeystrokes()) {
            if (this.isBound(event)) {
                return;
            }
            KeystrokeCommand command = new KeystrokeCommand(event);
            this.recordCommand(command);
        }
    }

    public void notHandled(String commandId, NotHandledException exception) {
        this.mCurrentlyExecutingCommand = false;
        this.endIncrementalFindMode();
        System.out.println("not handled: " + commandId);
    }

    public void postExecuteFailure(String commandId, ExecutionException exception) {
        this.mCurrentlyExecutingCommand = false;
        this.endIncrementalFindMode();
        System.out.println("command failed: " + commandId);
    }

    public void postExecuteSuccess(String commandId, Object returnValue) {
        this.mCurrentlyExecutingCommand = false;
        this.endIncrementalFindMode();
        if (this.mNonRecordableCommandIds.contains(commandId)) {
            if (!commandId.equals("practicallymacro.actions.recordMacro") && !commandId.equals("org.eclipse.ui.edit.findReplace")) {
                MacroConsole.getConsole().writeln("Not recording command (it's in the exclude list): " + commandId, 1);
            }
            return;
        }
        if (commandId.equals("org.eclipse.ui.edit.findIncremental") || commandId.equals("org.eclipse.ui.edit.findIncrementalReverse")) {
            this.mIncrementalFindForward = commandId.equals("org.eclipse.ui.edit.findIncremental");
            Listener[] currentListeners = Utilities.getStyledText(Utilities.getActiveEditor()).getListeners(4);
            this.mIncrementalListener = null;
            Listener[] listenerArray = currentListeners;
            int n = currentListeners.length;
            int n2 = 0;
            while (n2 < n) {
                Listener listenerBeforeFind;
                Listener listener = listenerArray[n2];
                boolean inCurrentList = false;
                Listener[] listenerArray2 = this.mPreexecuteListeners;
                if (this.mPreexecuteListeners.length != 0 && (listenerBeforeFind = listenerArray2[0]) == listener) {
                    inCurrentList = true;
                }
                if (!inCurrentList) {
                    this.mIncrementalListener = listener;
                }
                ++n2;
            }
        }
        this.updateIncrementalFindMode();
        if (!this.mIncrementalFindMode) {
            System.out.println("Command executed: " + commandId);
            this.recordCommand(new EclipseCommand(commandId));
        }
    }

    public void preExecute(String commandId, ExecutionEvent event) {
        this.mCurrentlyExecutingCommand = true;
        if (commandId.equals("org.eclipse.ui.edit.findIncremental") || commandId.equals("org.eclipse.ui.edit.findIncrementalReverse")) {
            this.mIncrementalFindMode = true;
            StyledText widget = Utilities.getStyledText(Utilities.getActiveEditor());
            if (widget != null) {
                this.mPreexecuteListeners = widget.getListeners(4);
            }
        }
        System.out.println("preexecute: " + commandId);
    }

    public List<IMacroCommand> getMacroCommands() {
        return this.mCommands;
    }

    public IEditorPart getEditor() {
        return this.mEditor;
    }

    private void updateIncrementalFindMode() {
        if (!this.mIncrementalFindMode) {
            return;
        }
        StyledText st = Utilities.getStyledText(Utilities.getActiveEditor());
        Listener[] currentListeners = st.getListeners(4);
        boolean stillInList = false;
        Listener[] listenerArray = currentListeners;
        int n = currentListeners.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            if (listener == this.mIncrementalListener) {
                stillInList = true;
                break;
            }
            ++n2;
        }
        if (!stillInList) {
            this.mIncrementalFindMode = false;
            String selectionText = st.getSelectionText();
            FindCommand findCommand = new FindCommand(selectionText);
            findCommand.setSearchForward(this.mIncrementalFindForward);
            this.recordCommand(findCommand);
            System.out.println("Incremental find string: " + selectionText);
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        if (!this.mCurrentlyExecutingCommand) {
            this.endIncrementalFindMode();
            System.out.println(event);
        }
    }

    private void endIncrementalFindMode() {
    }

    public void pauseRecording() {
        this.mRecordCommands = false;
    }

    public void resumeRecording() {
        this.mRecordCommands = true;
    }

    public void recordCommand(IMacroCommand newCommand) {
        if (this.mRecordCommands) {
            MacroConsole.getConsole().writeln("*Command added to macro: " + newCommand.getName(), 3);
            this.mCommands.add(newCommand);
        }
    }

    public IDocumentListener getMarkUpdater() {
        return this.mMarkUpdater;
    }
}

