/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import practicallymacro.commands.EclipseCommand;
import practicallymacro.commands.IMacroCommand;
import practicallymacro.commands.InsertStringCommand;
import practicallymacro.dialogs.MacroCommandDebugInfo;
import practicallymacro.dialogs.MacroDebugDialog;
import practicallymacro.editormacros.Activator;
import practicallymacro.model.MacroManager;
import practicallymacro.model.MarkUpdater;
import practicallymacro.util.MacroConsole;
import practicallymacro.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorMacro {
    private List<IMacroCommand> mCommands;
    private String mName;
    private String mDescription;
    private String mID;
    private long mLastUse;
    private int[] mMarks = new int[2];
    private boolean mIsContributed;
    private int mSessionID = 0;
    private boolean mRunAsCompoundEvent;
    private static int mMaxMacroSize = 1000;

    public EditorMacro(List<IMacroCommand> commands, String id, String name, String desc) {
        this.mCommands = new ArrayList<IMacroCommand>();
        this.mCommands.addAll(commands);
        this.mDescription = desc;
        this.mName = name;
        this.mID = id;
        this.mLastUse = System.currentTimeMillis();
        this.mIsContributed = false;
        this.mRunAsCompoundEvent = true;
    }

    public void setContributed(boolean contributed) {
        this.mIsContributed = contributed;
    }

    public boolean isContributed() {
        return this.mIsContributed;
    }

    public boolean isRunAsCompoundEvent() {
        return this.mRunAsCompoundEvent;
    }

    public void setRunAsCompoundEvent(boolean runAsCompoundEvent) {
        this.mRunAsCompoundEvent = runAsCompoundEvent;
    }

    public void run(final IEditorPart editor) {
        block32: {
            if (editor == null) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Execute macro", (String)"Cannot execute macro: the view with focus is not a text editor.");
                return;
            }
            this.clearMarks();
            boolean debugMode = MacroManager.getManager().isMacroDebugMode();
            boolean saveWriteMode = Activator.getDefault().getPreferenceStore().getBoolean("PracticallyMacro_WriteToMacroConsole");
            if (debugMode) {
                Activator.getDefault().getPreferenceStore().setValue("PracticallyMacro_WriteToMacroConsole", true);
            }
            boolean atomicExecution = !debugMode && this.isRunAsCompoundEvent();
            ITextViewer viewer = (ITextViewer)editor.getAdapter(ITextOperationTarget.class);
            ITextViewerExtension viewExtension = null;
            if (viewer instanceof ITextViewerExtension) {
                viewExtension = (ITextViewerExtension)viewer;
            }
            try {
                if (atomicExecution && viewExtension != null) {
                    viewExtension.getRewriteTarget().beginCompoundChange();
                }
                MacroManager.getManager().setLastMacro(this);
                this.mLastUse = System.currentTimeMillis();
                ArrayList<Object> flattenedList = new ArrayList<Object>();
                this.flattenMacro(flattenedList);
                MacroConsole.getConsole().writeln("Executing macro: " + this.getID(), 1);
                if (flattenedList.size() > mMaxMacroSize) {
                    return;
                }
                try {
                    final MarkUpdater markUpdater = new MarkUpdater(false);
                    final IDocument document = Utilities.getIDocumentForEditor(Utilities.getActiveEditor());
                    document.addDocumentListener((IDocumentListener)markUpdater);
                    final boolean[] canContinue = new boolean[]{true};
                    boolean mustPost = this.requiresPost(flattenedList);
                    ArrayList<MacroCommandDebugInfo> collectedDebugInfo = new ArrayList<MacroCommandDebugInfo>();
                    int i = 0;
                    while (i < flattenedList.size()) {
                        Object object = flattenedList.get(i);
                        if (object instanceof FlattenWrapper) {
                            final FlattenWrapper wrapper = (FlattenWrapper)object;
                            if (mustPost) {
                                Display.getCurrent().asyncExec(new Runnable(){

                                    public void run() {
                                        EditorMacro.this.updateMacroStack(wrapper);
                                    }
                                });
                            } else {
                                this.updateMacroStack(wrapper);
                            }
                        } else {
                            final IMacroCommand command = (IMacroCommand)object;
                            if (mustPost) {
                                Display.getCurrent().asyncExec(new Runnable(){

                                    public void run() {
                                        if (!canContinue[0]) {
                                            return;
                                        }
                                        MacroConsole.getConsole().writeln("--Executing command: " + command.getName(), 4);
                                        boolean succeeded = command.execute(editor);
                                        if (!succeeded) {
                                            canContinue[0] = false;
                                        }
                                    }
                                });
                            } else {
                                if (debugMode) {
                                    ArrayList<MacroCommandDebugInfo> combinedDebugInfo = new ArrayList<MacroCommandDebugInfo>();
                                    combinedDebugInfo.addAll(collectedDebugInfo);
                                    int k = i;
                                    while (k < flattenedList.size()) {
                                        Object obj = flattenedList.get(k);
                                        if (obj instanceof IMacroCommand) {
                                            combinedDebugInfo.add(new MacroCommandDebugInfo((IMacroCommand)obj));
                                        }
                                        ++k;
                                    }
                                    MacroDebugDialog dlg = new MacroDebugDialog(Display.getCurrent().getActiveShell(), combinedDebugInfo);
                                    dlg.open();
                                    int selectedAction = dlg.getSelectedAction();
                                    if (selectedAction == 6) break;
                                    if (selectedAction == 5) {
                                        debugMode = false;
                                    }
                                }
                                MacroConsole.getConsole().writeln("--Executing command: " + command.getName(), 4);
                                canContinue[0] = command.execute(editor);
                                if (!canContinue[0]) break;
                                if (debugMode) {
                                    ISourceViewer sourceViewer = Utilities.getSourceViewer(editor);
                                    Point selRange = Utilities.getUndirectedSelection(sourceViewer);
                                    int caretPos = Utilities.getCaretPos(editor);
                                    Point cursorPos = new Point(0, 0);
                                    Point selEndPos = new Point(0, 0);
                                    if (selRange.x < selRange.y) {
                                        if (caretPos == selRange.x) {
                                            this.translate(sourceViewer, selRange.y, selEndPos);
                                        } else {
                                            this.translate(sourceViewer, selRange.x, selEndPos);
                                        }
                                    } else {
                                        selEndPos = null;
                                    }
                                    this.translate(sourceViewer, caretPos, cursorPos);
                                    MacroCommandDebugInfo newInfo = new MacroCommandDebugInfo(command, cursorPos, selEndPos);
                                    collectedDebugInfo.add(newInfo);
                                    MacroConsole.getConsole().writeln("--After command, cursor at: Line " + cursorPos.x + ", Column " + cursorPos.y, 5);
                                    int k = 0;
                                    while (k < this.mMarks.length) {
                                        int markPos = this.mMarks[k];
                                        Point p = new Point(0, 0);
                                        this.translate(sourceViewer, markPos, p);
                                        MacroConsole.getConsole().writeln("--After command, mark#" + Integer.toString(k) + " at: Line " + p.x + ", Column " + p.y, 5);
                                        ++k;
                                    }
                                    if (selEndPos == null) {
                                        MacroConsole.getConsole().writeln("--After command, there is no selection", 5);
                                    } else {
                                        MacroConsole.getConsole().writeln("--After command, the selection pivot point is at: Line " + selEndPos.x + ", Column " + selEndPos.y, 5);
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                    if (mustPost) {
                        Display.getCurrent().asyncExec(new Runnable(){

                            public void run() {
                                MacroManager.getManager().clearMacroStack();
                                document.removeDocumentListener((IDocumentListener)markUpdater);
                                MacroConsole.getConsole().writeln("--Finished executing macro: " + EditorMacro.this.getID(), 4);
                            }
                        });
                        break block32;
                    }
                    MacroManager.getManager().clearMacroStack();
                    document.removeDocumentListener((IDocumentListener)markUpdater);
                    MacroConsole.getConsole().writeln("--Finished executing macro: " + this.getID(), 4);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MacroConsole.getConsole().write("Failed to run command with the following exception: ", 2);
                    MacroConsole.getConsole().write(e, 2);
                }
            }
            finally {
                Activator.getDefault().getPreferenceStore().setValue("PracticallyMacro_WriteToMacroConsole", saveWriteMode);
                if (atomicExecution && viewExtension != null) {
                    viewExtension.getRewriteTarget().endCompoundChange();
                }
            }
        }
    }

    private void clearMarks() {
        int i = 0;
        while (i < this.mMarks.length) {
            this.mMarks[i] = 0;
            ++i;
        }
    }

    private void translate(ISourceViewer viewer, int offset, Point textPos) {
        try {
            int lineAtOffset = viewer.getDocument().getLineOfOffset(offset);
            int column = offset - viewer.getDocument().getLineOffset(lineAtOffset);
            textPos.x = lineAtOffset + 1;
            textPos.y = column + 1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateMacroStack(FlattenWrapper wrapper) {
        if (wrapper.isPush()) {
            MacroManager.getManager().pushMacro(wrapper.getMacro());
        } else {
            MacroManager.getManager().popMacro();
        }
    }

    public void flattenMacro(List<Object> flattenedList) {
        if (flattenedList.size() > mMaxMacroSize) {
            return;
        }
        flattenedList.add(new FlattenWrapper(this, true));
        for (IMacroCommand command : this.mCommands) {
            if (command instanceof EclipseCommand) {
                EditorMacro macro = MacroManager.getManager().getMacro(((EclipseCommand)command).getCommandID());
                if (macro != null) {
                    macro.flattenMacro(flattenedList);
                    if (flattenedList.size() <= mMaxMacroSize) continue;
                    return;
                }
                flattenedList.add(command);
                continue;
            }
            flattenedList.add(command);
        }
        flattenedList.add(new FlattenWrapper(this, false));
    }

    public void addCommand(IMacroCommand command) {
        this.mCommands.add(command);
    }

    public boolean hasEvents() {
        return this.mCommands.size() > 0;
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void dump() {
        for (IMacroCommand command : this.mCommands) {
            command.dump();
        }
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getID() {
        return this.mID;
    }

    public void setID(String id) {
        this.mID = id;
    }

    public void persist(Document doc, Element macroElement) {
        for (IMacroCommand command : this.mCommands) {
            Element child = doc.createElement("Command");
            command.persist(doc, child);
            macroElement.appendChild(child);
        }
    }

    public long getLastUse() {
        return this.mLastUse;
    }

    public void setLastUse(long time) {
        this.mLastUse = time;
    }

    public List<IMacroCommand> getCommands() {
        return this.mCommands;
    }

    public void copyFrom(EditorMacro existingMacro) {
        this.mID = existingMacro.mID;
        this.mName = existingMacro.mName;
        this.mDescription = existingMacro.mDescription;
        this.mCommands.clear();
        this.mCommands.addAll(existingMacro.mCommands);
        this.mLastUse = existingMacro.mLastUse;
        this.mIsContributed = existingMacro.mIsContributed;
        this.mRunAsCompoundEvent = existingMacro.mRunAsCompoundEvent;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EditorMacro)) {
            return false;
        }
        if (this.getID() == null || ((EditorMacro)obj).getID() == null) {
            return false;
        }
        return ((EditorMacro)obj).getID().equals(this.getID());
    }

    public int hashCode() {
        if (this.getID() == null) {
            return this.getName().hashCode();
        }
        return this.getID().hashCode();
    }

    public void setMark(int caretOffset, int markIndex) {
        if (markIndex < this.mMarks.length) {
            this.mMarks[markIndex] = caretOffset;
        }
    }

    public void moveMarkOnInsert(int loc, int length) {
        int i = 0;
        while (i < this.mMarks.length) {
            this.mMarks[i] = EditorMacro.moveMarkOnInsert(this.mMarks[i], loc, length);
            ++i;
        }
    }

    public static int moveMarkOnInsert(int initialMark, int loc, int length) {
        if (loc < initialMark) {
            return initialMark + length;
        }
        return initialMark;
    }

    public void moveMarkOnDelete(int start, int length) {
        int i = 0;
        while (i < this.mMarks.length) {
            this.mMarks[i] = EditorMacro.moveMarkOnDelete(this.mMarks[i], start, length);
            ++i;
        }
    }

    public static int moveMarkOnDelete(int mark, int start, int length) {
        if (start + length <= mark) {
            return mark - length;
        }
        if (start <= mark && start + length > mark) {
            return start;
        }
        return mark;
    }

    public int getMark(int index) {
        if (index < this.mMarks.length) {
            return this.mMarks[index];
        }
        return 0;
    }

    public boolean requiresPost(List<Object> flattenedList) {
        for (Object object : flattenedList) {
            if (!(object instanceof IMacroCommand) || !((IMacroCommand)object).requiresPost()) continue;
            return true;
        }
        return false;
    }

    public int getSessionID() {
        return this.mSessionID;
    }

    public void setSessionID(int sessionID) {
        if (this.mSessionID != 0) {
            throw new RuntimeException("Session ID set twice. Macro: " + this.toString());
        }
        this.mSessionID = sessionID;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ID: ");
        if (this.getID() == null) {
            buffer.append("<none>");
        } else {
            buffer.append(this.getID());
        }
        return buffer.toString();
    }

    public static List<IMacroCommand> compressStringInsertions(List<IMacroCommand> commands) {
        ArrayList<IMacroCommand> newCommands = new ArrayList<IMacroCommand>();
        InsertStringCommand lastCommand = null;
        for (IMacroCommand macroCommand : commands) {
            if (macroCommand instanceof InsertStringCommand) {
                InsertStringCommand anotherCommand = (InsertStringCommand)macroCommand;
                if (lastCommand != null) {
                    boolean success = lastCommand.combineWith(anotherCommand);
                    if (success) continue;
                    lastCommand = anotherCommand;
                } else {
                    lastCommand = anotherCommand;
                }
            } else if (lastCommand != null) {
                lastCommand = null;
            }
            newCommands.add(macroCommand);
        }
        return newCommands;
    }

    static class FlattenWrapper {
        private EditorMacro mMacro;
        private boolean mPush;

        public FlattenWrapper(EditorMacro macro, boolean push) {
            this.mMacro = macro;
            this.mPush = push;
        }

        public EditorMacro getMacro() {
            return this.mMacro;
        }

        public boolean isPush() {
            return this.mPush;
        }
    }
}

