/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.dialogs;

import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.commands.ICommandService;
import practicallymacro.commands.IMacroCommand;
import practicallymacro.editormacros.Activator;
import practicallymacro.model.EditorMacro;
import practicallymacro.model.MacroManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveMacroDialog
extends TitleAreaDialog {
    private List<IMacroCommand> mCommands;
    private Text mName;
    private Text mID;
    private Text mDescription;
    private Button mSaveCheck;
    private EditorMacro mResultMacro;
    private Button mShowDialogCheck;

    public SaveMacroDialog(Shell shell, List<IMacroCommand> commands) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.mCommands = commands;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Save recorded macro");
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(1808));
        SelectionAdapter updateStatusListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SaveMacroDialog.this.updateStatus();
            }
        };
        ModifyListener updateModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SaveMacroDialog.this.updateStatus();
            }
        };
        Composite nameHalf = new Composite(comp, 0);
        nameHalf.setLayout((Layout)new GridLayout());
        nameHalf.setLayoutData((Object)new GridData(1808));
        Composite nameField = new Composite(nameHalf, 0);
        nameField.setLayout((Layout)new GridLayout(2, false));
        nameField.setLayoutData((Object)new GridData(768));
        Label l = new Label(nameField, 0);
        l.setText("Name for macro: ");
        this.mName = new Text(nameField, 2052);
        this.mName.setLayoutData((Object)new GridData(768));
        this.mName.addModifyListener(updateModifyListener);
        this.mName.setText(MacroManager.getManager().getUniqueMacroName());
        l = new Label(nameField, 0);
        l.setText("Description for macro: ");
        this.mDescription = new Text(nameField, 2052);
        this.mDescription.setLayoutData((Object)new GridData(768));
        this.mSaveCheck = new Button(nameHalf, 32);
        this.mSaveCheck.setText("Save macro (for permanent use)");
        this.mSaveCheck.setSelection(false);
        this.mSaveCheck.addSelectionListener((SelectionListener)updateStatusListener);
        Composite dataComp = new Composite(nameHalf, 0);
        dataComp.setLayout((Layout)new GridLayout(2, false));
        dataComp.setLayoutData((Object)new GridData(1808));
        l = new Label(dataComp, 0);
        l.setText("ID for macro: ");
        this.mID = new Text(dataComp, 2052);
        this.mID.setLayoutData((Object)new GridData(768));
        this.mID.addModifyListener(updateModifyListener);
        this.mShowDialogCheck = new Button(nameHalf, 32);
        this.mShowDialogCheck.setText("Show this dialog after recording each macro");
        this.mShowDialogCheck.setSelection(Activator.getDefault().getPreferenceStore().getBoolean("PracticallyMacro_ShowSaveDialog"));
        Composite commandHalf = new Composite(comp, 0);
        commandHalf.setLayout((Layout)new GridLayout());
        commandHalf.setLayoutData((Object)new GridData(1808));
        Table commandTable = new Table(commandHalf, 2564);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        gd.widthHint = 200;
        commandTable.setLayoutData((Object)gd);
        for (IMacroCommand command : this.mCommands) {
            TableItem ti = new TableItem(commandTable, 0);
            ti.setText(command.getName());
        }
        this.mName.setFocus();
        return comp;
    }

    private void updateStatus() {
        if (this.mID == null || this.mSaveCheck == null || this.mName == null) {
            return;
        }
        this.mID.setEnabled(this.mSaveCheck.getSelection());
        if (this.mSaveCheck.getSelection()) {
            if (this.mName.getText().length() == 0) {
                this.setMessage("Name must be provided", 3);
                this.getButton(0).setEnabled(false);
                return;
            }
            ICommandService cs = MacroManager.getOldCommandService();
            if (this.mID.getText().length() == 0) {
                this.setMessage("You must specify an ID for the command", 3);
                this.getButton(0).setEnabled(false);
                return;
            }
            Command command = cs.getCommand(this.mID.getText());
            if (command.isDefined()) {
                this.setMessage("A command with that id is already defined", 3);
                this.getButton(0).setEnabled(false);
                return;
            }
        }
        this.getButton(0).setEnabled(this.mName.getText().length() > 0);
        if (this.mName.getText().length() == 0) {
            this.setMessage("Name must be provided to keep macro", 3);
            return;
        }
        this.setMessage(null);
    }

    protected void okPressed() {
        if (this.mSaveCheck.getSelection()) {
            this.mResultMacro = new EditorMacro(this.mCommands, this.mID.getText(), this.mName.getText(), this.mDescription.getText());
            System.out.println("Save macro as :" + this.mName.getText());
        } else {
            this.mResultMacro = new EditorMacro(this.mCommands, "", this.mName.getText(), "");
            System.out.println("Save temp macro as :" + this.mName.getText());
        }
        this.mResultMacro.setRunAsCompoundEvent(Activator.getDefault().getPreferenceStore().getBoolean("PracticallyMacro_ExecuteMacrosAtomically"));
        Activator.getDefault().getPreferenceStore().setValue("PracticallyMacro_ShowSaveDialog", this.mShowDialogCheck.getSelection());
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    public EditorMacro getMacro() {
        return this.mResultMacro;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateStatus();
    }
}

