/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.commands.ICommandService;
import practicallymacro.dialogs.ChooseCommandsDlg;
import practicallymacro.editormacros.Activator;
import practicallymacro.model.MacroManager;

public class QuickExecuteDialog
extends Dialog {
    private String mCommandID;
    private Table mCommandTable;
    private Button mAddButton;
    private Button mRemoveButton;
    private Button mMoveUpButton;
    private Button mMoveDownButton;
    private List<Command> mQuickCommands;
    private Text mDescriptionText;

    public QuickExecuteDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Quick Execute Command");
        Label l = new Label(parent, 0);
        l.setText("Choose the command to execute");
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(1808));
        Composite tableComp = new Composite(comp, 0);
        tableComp.setLayout((Layout)new GridLayout());
        tableComp.setLayoutData((Object)new GridData(1808));
        this.mCommandTable = new Table(tableComp, 2052);
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        gd.heightHint = 200;
        this.mCommandTable.setLayoutData((Object)gd);
        this.mCommandTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selItems = QuickExecuteDialog.this.mCommandTable.getSelection();
                QuickExecuteDialog.this.mDescriptionText.setText("");
                if (selItems != null && selItems.length > 0) {
                    TableItem selItem = selItems[0];
                    QuickExecuteDialog.this.mCommandID = ((Command)selItem.getData()).getId();
                } else {
                    QuickExecuteDialog.this.mCommandID = null;
                }
                QuickExecuteDialog.this.enableWidgets();
            }
        });
        this.mQuickCommands = new ArrayList<Command>();
        String commandIDString = Activator.getDefault().getPreferenceStore().getString("PracticallyMacro_QuickPlayCommands");
        String[] commandIDs = commandIDString.split("\n");
        final ICommandService cs = MacroManager.getOldCommandService();
        String[] stringArray = commandIDs;
        int n = commandIDs.length;
        int n2 = 0;
        while (n2 < n) {
            Command command;
            String id = stringArray[n2];
            if (id != null && id.length() != 0 && (command = cs.getCommand(id)) != null && command.isDefined()) {
                this.mQuickCommands.add(command);
            }
            ++n2;
        }
        Composite actionComp = new Composite(comp, 0);
        actionComp.setLayout((Layout)new GridLayout());
        actionComp.setLayoutData((Object)new GridData(1040));
        this.mAddButton = new Button(actionComp, 8);
        this.mAddButton.setText("Add command...");
        this.mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseCommandsDlg dlg = new ChooseCommandsDlg(QuickExecuteDialog.this.getShell(), QuickExecuteDialog.this.mQuickCommands);
                if (dlg.open() == 0) {
                    List<String> ids = dlg.getCommands();
                    for (String id : ids) {
                        Command c = cs.getCommand(id);
                        if (!c.isDefined()) continue;
                        QuickExecuteDialog.this.mQuickCommands.add(c);
                    }
                    QuickExecuteDialog.this.populateCommandList();
                }
            }
        });
        this.mRemoveButton = new Button(actionComp, 8);
        this.mRemoveButton.setText("Remove command");
        this.mRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = QuickExecuteDialog.this.mCommandTable.getSelectionIndex();
                if (selIndex >= 0) {
                    QuickExecuteDialog.this.mQuickCommands.remove(selIndex);
                    QuickExecuteDialog.this.populateCommandList();
                    if (selIndex >= QuickExecuteDialog.this.mQuickCommands.size()) {
                        selIndex = QuickExecuteDialog.this.mQuickCommands.size() - 1;
                    }
                    if (selIndex >= 0) {
                        QuickExecuteDialog.this.mCommandTable.setSelection(selIndex);
                    }
                    QuickExecuteDialog.this.enableWidgets();
                }
            }
        });
        this.mMoveUpButton = new Button(actionComp, 8);
        this.mMoveUpButton.setText("Move up");
        this.mMoveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = QuickExecuteDialog.this.mCommandTable.getSelectionIndex();
                if (selIndex >= 0) {
                    Command c = (Command)QuickExecuteDialog.this.mQuickCommands.get(selIndex);
                    QuickExecuteDialog.this.mQuickCommands.set(selIndex, (Command)QuickExecuteDialog.this.mQuickCommands.get(selIndex - 1));
                    QuickExecuteDialog.this.mQuickCommands.set(selIndex - 1, c);
                    QuickExecuteDialog.this.populateCommandList();
                    QuickExecuteDialog.this.mCommandTable.setSelection(selIndex - 1);
                    QuickExecuteDialog.this.enableWidgets();
                }
            }
        });
        this.mMoveDownButton = new Button(actionComp, 8);
        this.mMoveDownButton.setText("Move down");
        this.mMoveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = QuickExecuteDialog.this.mCommandTable.getSelectionIndex();
                if (selIndex >= 0) {
                    Command c = (Command)QuickExecuteDialog.this.mQuickCommands.get(selIndex);
                    QuickExecuteDialog.this.mQuickCommands.set(selIndex, (Command)QuickExecuteDialog.this.mQuickCommands.get(selIndex + 1));
                    QuickExecuteDialog.this.mQuickCommands.set(selIndex + 1, c);
                    QuickExecuteDialog.this.populateCommandList();
                    QuickExecuteDialog.this.mCommandTable.setSelection(selIndex + 1);
                    QuickExecuteDialog.this.enableWidgets();
                }
            }
        });
        Composite descComp = new Composite(parent, 0);
        descComp.setLayout((Layout)new GridLayout(1, false));
        descComp.setLayoutData((Object)new GridData(1808));
        l = new Label(descComp, 0);
        l.setText("Description:");
        this.mDescriptionText = new Text(descComp, 770);
        gd = new GridData(1808);
        gd.heightHint = 40;
        this.mDescriptionText.setLayoutData((Object)gd);
        this.populateCommandList();
        if (this.mCommandTable.getItemCount() > 0) {
            this.mCommandTable.select(0);
        }
        this.enableWidgets();
        return comp;
    }

    private void populateCommandList() {
        this.mCommandTable.removeAll();
        for (Command c : this.mQuickCommands) {
            TableItem t = new TableItem(this.mCommandTable, 0);
            try {
                t.setText(c.getName());
            }
            catch (NotDefinedException e) {
                e.printStackTrace();
            }
            t.setData((Object)c);
        }
        this.enableWidgets();
    }

    private void enableWidgets() {
        int selIndex = this.mCommandTable.getSelectionIndex();
        this.mRemoveButton.setEnabled(selIndex >= 0);
        this.mMoveDownButton.setEnabled(selIndex >= 0 && selIndex + 1 < this.mCommandTable.getItemCount());
        this.mMoveUpButton.setEnabled(selIndex >= 0 && selIndex > 0);
        this.mDescriptionText.setText("");
        if (selIndex >= 0) {
            Command selItem = this.mQuickCommands.get(selIndex);
            try {
                this.mDescriptionText.setText(selItem.getDescription());
            }
            catch (NotDefinedException e1) {
                e1.printStackTrace();
            }
        }
    }

    public String getCommandID() {
        return this.mCommandID;
    }

    protected void okPressed() {
        this.mCommandID = null;
        TableItem[] selItems = this.mCommandTable.getSelection();
        if (selItems.length > 0) {
            this.mCommandID = ((Command)selItems[0].getData()).getId();
        }
        StringBuffer buffer = new StringBuffer();
        for (Command c : this.mQuickCommands) {
            buffer.append(c.getId());
            buffer.append('\n');
        }
        Activator.getDefault().getPreferenceStore().setValue("PracticallyMacro_QuickPlayCommands", buffer.toString());
        super.okPressed();
    }
}

