/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.commands.ICommandService;
import practicallymacro.commands.EclipseCommand;
import practicallymacro.commands.IMacroCommand;
import practicallymacro.commands.TemporaryMacroCommand;
import practicallymacro.model.EditorMacro;
import practicallymacro.model.MacroManager;
import practicallymacro.util.MacroConsole;
import practicallymacro.util.Utilities;

public class PlayCommandDialog
extends Dialog {
    private Table mCommandTable;
    private Text mDescriptionText;
    private Button mFilterNonEditorCommands;
    private Button mFilterNonMacroCommands;
    private TableColumn mNameColumn;
    private Spinner mCountSpinner;

    public PlayCommandDialog(Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Play command");
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        this.mFilterNonEditorCommands = new Button(comp, 32);
        this.mFilterNonEditorCommands.setText("Filter out non-editor commands");
        this.mFilterNonEditorCommands.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlayCommandDialog.this.updateCommandTable();
            }
        });
        this.mFilterNonEditorCommands.setSelection(true);
        this.mFilterNonMacroCommands = new Button(comp, 32);
        GridData gd = new GridData();
        gd.horizontalIndent = 15;
        this.mFilterNonMacroCommands.setLayoutData((Object)gd);
        this.mFilterNonMacroCommands.setText("Show only user defined macros and macro support commands");
        this.mFilterNonMacroCommands.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlayCommandDialog.this.updateCommandTable();
            }
        });
        this.mCommandTable = new Table(comp, 67588);
        this.mCommandTable.setHeaderVisible(true);
        GridData tableData = new GridData(768);
        GC gc = new GC((Drawable)this.mCommandTable);
        tableData.heightHint = gc.getFontMetrics().getHeight() * 25;
        this.mCommandTable.setLayoutData((Object)tableData);
        this.mCommandTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlayCommandDialog.this.updateDescription();
                PlayCommandDialog.this.updateButtons();
            }
        });
        this.mNameColumn = new TableColumn(this.mCommandTable, 0);
        this.mNameColumn.setText("Command Name");
        this.mNameColumn.setWidth(200);
        final TableColumn categoryColumn = new TableColumn(this.mCommandTable, 0);
        categoryColumn.setText("Category");
        categoryColumn.setWidth(200);
        this.mCommandTable.setSortDirection(128);
        this.mCommandTable.setSortColumn(this.mNameColumn);
        this.mNameColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlayCommandDialog.this.mCommandTable.setSortColumn(PlayCommandDialog.this.mNameColumn);
                PlayCommandDialog.this.updateCommandTable();
            }
        });
        categoryColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlayCommandDialog.this.mCommandTable.setSortColumn(categoryColumn);
                PlayCommandDialog.this.updateCommandTable();
            }
        });
        this.mDescriptionText = new Text(comp, 2634);
        GridData descData = new GridData(768);
        gc = new GC((Drawable)this.mDescriptionText);
        descData.heightHint = gc.getFontMetrics().getHeight() * 5;
        this.mDescriptionText.setLayoutData((Object)descData);
        Composite spinComp = new Composite(comp, 0);
        spinComp.setLayout((Layout)new GridLayout(2, false));
        spinComp.setLayoutData((Object)new GridData(768));
        Label l = new Label(spinComp, 0);
        l.setText("Number of times to execute command");
        this.mCountSpinner = new Spinner(spinComp, 2048);
        this.mCountSpinner.setMinimum(1);
        this.mCountSpinner.setSelection(0);
        this.updateCommandTable();
        return comp;
    }

    protected void okPressed() {
        TableItem[] selItems = this.mCommandTable.getSelection();
        if (selItems.length > 0) {
            final IMacroCommand command = (IMacroCommand)selItems[0].getData();
            final int timesToExecute = this.mCountSpinner.getSelection();
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (MacroManager.getManager().getMacroState() == "MACROSTATE_RECORDING") {
                        MacroManager.getManager().getRecorder().pauseRecording();
                    }
                    int i = 0;
                    while (i < timesToExecute) {
                        boolean success = command.execute(Utilities.getActiveEditor());
                        if (!success) {
                            MacroConsole.getConsole().writeln("Stopped executing command after " + timesToExecute + " iterations because last execution failed.", 1);
                            break;
                        }
                        ++i;
                    }
                    if (MacroManager.getManager().getMacroState() == "MACROSTATE_RECORDING") {
                        MacroManager.getManager().getRecorder().resumeRecording();
                        MacroManager.getManager().getRecorder().recordCommand(command);
                    }
                }
            });
        }
        super.okPressed();
    }

    private void updateDescription() {
        String desc;
        this.mDescriptionText.setText("");
        TableItem[] selItems = this.mCommandTable.getSelection();
        if (selItems.length > 0 && (desc = ((IMacroCommand)selItems[0].getData()).getDescription()) != null) {
            this.mDescriptionText.setText(desc);
        }
    }

    private void updateButtons() {
        this.mFilterNonMacroCommands.setEnabled(this.mFilterNonEditorCommands.getSelection());
    }

    private void updateCommandTable() {
        Utilities.createStyledTextCommands();
        ICommandService cs = MacroManager.getOldCommandService();
        Command[] allCommands = cs.getDefinedCommands();
        ArrayList<IMacroCommand> allItems = new ArrayList<IMacroCommand>();
        int i = 0;
        while (i < allCommands.length) {
            Command command = allCommands[i];
            if (command.isDefined()) {
                allItems.add(new EclipseCommand(command.getId()));
            }
            ++i;
        }
        allItems.addAll(Utilities.getMacroSupportCommands());
        List<EditorMacro> tempMacros = MacroManager.getManager().getUsedTempMacros(-1);
        for (EditorMacro editorMacro : tempMacros) {
            allItems.add(new TemporaryMacroCommand(editorMacro));
        }
        ArrayList<IMacroCommand> filteredCommands = new ArrayList<IMacroCommand>();
        if (this.mFilterNonEditorCommands.getSelection()) {
            for (IMacroCommand macroCommand : allItems) {
                if (!Utilities.isEditCategory(macroCommand.getCategoryID())) continue;
                if (!this.mFilterNonMacroCommands.getSelection()) {
                    filteredCommands.add(macroCommand);
                    continue;
                }
                if (!Utilities.isUserMacro(macroCommand) && !Utilities.isSupportCategory(macroCommand.getCategoryID())) continue;
                filteredCommands.add(macroCommand);
            }
        } else {
            filteredCommands = allItems;
        }
        Collections.sort(filteredCommands, new Comparator<IMacroCommand>(){

            @Override
            public int compare(IMacroCommand o1, IMacroCommand o2) {
                TableColumn column = PlayCommandDialog.this.mCommandTable.getSortColumn();
                if (column == PlayCommandDialog.this.mNameColumn) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
                return o1.getCategory().compareToIgnoreCase(o2.getCategory());
            }
        });
        this.mCommandTable.removeAll();
        for (IMacroCommand command : filteredCommands) {
            TableItem item = new TableItem(this.mCommandTable, 0);
            item.setText(0, command.getName());
            item.setText(1, command.getCategory());
            item.setData((Object)command);
        }
        this.updateButtons();
    }
}

