/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.dialogs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import practicallymacro.model.EditorMacro;
import practicallymacro.model.MacroManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMacroDialog
extends Dialog {
    private Text mFileText;
    private Table mMacroTable;
    private Text mDescription;
    private Collection<EditorMacro> mMacros;

    public ImportMacroDialog(Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Import Macros");
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        Composite fileComp = new Composite(comp, 0);
        fileComp.setLayout((Layout)new GridLayout(3, false));
        fileComp.setLayoutData((Object)new GridData(768));
        Label l = new Label(fileComp, 0);
        l.setText("Import file name:");
        this.mFileText = new Text(fileComp, 2052);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.mFileText.setLayoutData((Object)gd);
        this.mFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportMacroDialog.this.rereadMacroFile();
                ImportMacroDialog.this.populateTable();
            }
        });
        Button browse = new Button(fileComp, 8);
        browse.setText("Browse...");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(ImportMacroDialog.this.getShell());
                String filePath = fd.open();
                if (filePath != null) {
                    ImportMacroDialog.this.mFileText.setText(filePath);
                }
            }
        });
        this.mMacroTable = new Table(comp, 67584);
        gd = new GridData(1808);
        gd.heightHint = 150;
        this.mMacroTable.setLayoutData((Object)gd);
        TableColumn nameCol = new TableColumn(this.mMacroTable, 0);
        nameCol.setText("Name");
        nameCol.setWidth(150);
        TableColumn idCol = new TableColumn(this.mMacroTable, 0);
        idCol.setText("Command id");
        idCol.setWidth(150);
        this.mMacroTable.setHeaderVisible(true);
        this.mDescription = new Text(comp, 2570);
        this.mDescription.setLayoutData((Object)new GridData(1808));
        return comp;
    }

    protected void rereadMacroFile() {
        this.mMacros = new ArrayList<EditorMacro>();
        String filePath = this.mFileText.getText();
        InputStreamReader r = null;
        try {
            File f = new File(filePath);
            if (!f.exists() || f.isDirectory()) {
                return;
            }
            try {
                r = new InputStreamReader(new FileInputStream(f));
                this.mMacros = MacroManager.getManager().readMacros(r);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void populateTable() {
        this.mMacroTable.removeAll();
        for (EditorMacro macro : this.mMacros) {
            TableItem item = new TableItem(this.mMacroTable, 0);
            item.setText(0, macro.getName());
            item.setText(1, macro.getID());
            item.setData((Object)macro);
        }
    }

    protected void okPressed() {
        super.okPressed();
    }

    public Collection<EditorMacro> getMacros() {
        return this.mMacros;
    }
}

