/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import practicallymacro.commands.EclipseCommand;
import practicallymacro.commands.IMacroCommand;
import practicallymacro.model.EditorMacro;
import practicallymacro.model.MacroManager;
import practicallymacro.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditMacroDialog
extends TitleAreaDialog {
    protected static final String Category_Undefined = "Undefined";
    private EditorMacro mExistingMacro;
    private EditorMacro mResultMacro;
    private Text mCommandDescriptionText;
    private Button mAddButton;
    private Button mDeleteButton;
    private Button mEditButton;
    private Button mCopyButton;
    private Button mMoveUpButton;
    private Button mMoveDownButton;
    private Table mCommandTable;
    private Button mCompressButton;
    private Text mMacroDescriptionText;
    private Text mIDText;
    private Text mNameText;
    private Button mRunAsCompoundButton;
    private Button mFilterNonEditorCommands;
    private Button mFilterNonMacroCommands;
    private boolean mCanChangeID;
    private boolean mReadOnly;
    List<IMacroCommand> mCommands;
    private TableColumn mAvailNameColumn;
    private TableColumn mAvailcategoryColumn;
    private Table mAvailableCommandTable;
    private Text mAvailableDescriptionText;
    private Set<String> mUsedIDs;

    public EditMacroDialog(Shell shell, EditorMacro existingMacro, Set<String> usedIDs, boolean canChangeID, boolean viewOnly) {
        super(shell);
        this.mExistingMacro = existingMacro;
        this.mUsedIDs = usedIDs;
        this.mCommands = new ArrayList<IMacroCommand>();
        this.mCanChangeID = canChangeID;
        this.mReadOnly = viewOnly;
        if (this.mExistingMacro != null) {
            this.mCommands.addAll(this.mExistingMacro.getCommands());
        }
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "PracticallyMacro.editDialogHelp");
        this.getShell().setText("Edit Macro");
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        Composite commandComp = new Composite(comp, 0);
        commandComp.setLayout((Layout)new GridLayout(4, false));
        commandComp.setLayoutData((Object)new GridData(1808));
        Composite availableComp = new Composite(commandComp, 0);
        availableComp.setLayout((Layout)new GridLayout());
        availableComp.setLayoutData((Object)new GridData(1808));
        this.mFilterNonEditorCommands = new Button(availableComp, 32);
        this.mFilterNonEditorCommands.setText("Filter out non-editor commands");
        this.mFilterNonEditorCommands.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditMacroDialog.this.updateAvailableCommandTable();
            }
        });
        this.mFilterNonEditorCommands.setSelection(true);
        this.mFilterNonMacroCommands = new Button(availableComp, 32);
        GridData gd = new GridData();
        gd.horizontalIndent = 15;
        this.mFilterNonMacroCommands.setLayoutData((Object)gd);
        this.mFilterNonMacroCommands.setText("Show only user defined macros and macro support commands");
        this.mFilterNonMacroCommands.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditMacroDialog.this.updateAvailableCommandTable();
            }
        });
        Label avail = new Label(availableComp, 0);
        avail.setText("Available Commands");
        this.mAvailableCommandTable = new Table(availableComp, 67584);
        GridData tableData = new GridData(768);
        GC gc = new GC((Drawable)this.mAvailableCommandTable);
        tableData.heightHint = gc.getFontMetrics().getHeight() * 25;
        tableData.widthHint = gc.getFontMetrics().getAverageCharWidth() * 50;
        this.mAvailableCommandTable.setLayoutData((Object)tableData);
        this.mAvailNameColumn = new TableColumn(this.mAvailableCommandTable, 0);
        this.mAvailNameColumn.setText("Name");
        this.mAvailNameColumn.setWidth(150);
        this.mAvailcategoryColumn = new TableColumn(this.mAvailableCommandTable, 0);
        this.mAvailcategoryColumn.setText("Category");
        this.mAvailcategoryColumn.setWidth(150);
        this.mAvailableCommandTable.setHeaderVisible(true);
        this.mAvailableCommandTable.setSortDirection(128);
        this.mAvailableCommandTable.setSortColumn(this.mAvailNameColumn);
        this.mAvailNameColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditMacroDialog.this.mAvailableCommandTable.setSortColumn(EditMacroDialog.this.mAvailNameColumn);
                EditMacroDialog.this.updateAvailableCommandTable();
            }
        });
        this.mAvailcategoryColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditMacroDialog.this.mAvailableCommandTable.setSortColumn(EditMacroDialog.this.mAvailcategoryColumn);
                EditMacroDialog.this.updateAvailableCommandTable();
            }
        });
        this.mAvailableCommandTable.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                TableItem[] selItems = EditMacroDialog.this.mAvailableCommandTable.getSelection();
                int i = 0;
                while (i < selItems.length) {
                    TableItem item = selItems[i];
                    IMacroCommand command = (IMacroCommand)item.getData();
                    EditMacroDialog.this.addCommandToMacroList(command);
                    ++i;
                }
                EditMacroDialog.this.updateCommandTable();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.mAvailableCommandTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditMacroDialog.this.updateAvailDescription();
            }
        });
        this.updateAvailableCommandTable();
        this.mAvailableDescriptionText = new Text(availableComp, 2634);
        gd = new GridData(1808);
        gc = new GC((Drawable)this.mAvailableDescriptionText);
        gd.heightHint = gc.getFontMetrics().getHeight() * 3;
        this.mAvailableDescriptionText.setLayoutData((Object)gd);
        this.mAddButton = new Button(commandComp, 8);
        this.mAddButton.setText("Add->");
        this.mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selItems = EditMacroDialog.this.mAvailableCommandTable.getSelection();
                int i = 0;
                while (i < selItems.length) {
                    TableItem item = selItems[i];
                    IMacroCommand command = (IMacroCommand)item.getData();
                    EditMacroDialog.this.addCommandToMacroList(command);
                    ++i;
                }
                EditMacroDialog.this.updateCommandTable();
            }
        });
        Composite tableComp = new Composite(commandComp, 0);
        tableComp.setLayout((Layout)new GridLayout());
        tableComp.setLayoutData((Object)new GridData(1808));
        Label current = new Label(tableComp, 0);
        current.setText("Current Commands");
        this.mCommandTable = new Table(tableComp, 67586);
        tableData = new GridData(768);
        gc = new GC((Drawable)this.mCommandTable);
        tableData.heightHint = gc.getFontMetrics().getHeight() * 25;
        tableData.widthHint = gc.getFontMetrics().getAverageCharWidth() * 50;
        this.mCommandTable.setLayoutData((Object)tableData);
        this.mCommandTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditMacroDialog.this.updateDescription();
                EditMacroDialog.this.updateButtons();
            }
        });
        TableColumn nameColumn = new TableColumn(this.mCommandTable, 0);
        nameColumn.setText("Name");
        nameColumn.setWidth(150);
        TableColumn categoryColumn = new TableColumn(this.mCommandTable, 0);
        categoryColumn.setText("Category");
        categoryColumn.setWidth(150);
        this.mCommandTable.setHeaderVisible(true);
        this.updateCommandTable();
        if (this.mCommandTable.getItemCount() > 0) {
            this.mCommandTable.setSelection(0);
        }
        this.mCommandDescriptionText = new Text(tableComp, 2826);
        GridData descData = new GridData(1808);
        gc = new GC((Drawable)this.mCommandDescriptionText);
        descData.heightHint = gc.getFontMetrics().getHeight() * 3;
        this.mCommandDescriptionText.setLayoutData((Object)descData);
        Composite buttonComp = new Composite(commandComp, 0);
        buttonComp.setLayout((Layout)new GridLayout());
        this.mDeleteButton = new Button(buttonComp, 8);
        this.mDeleteButton.setText("Delete");
        this.mDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] items = EditMacroDialog.this.mCommandTable.getSelectionIndices();
                Arrays.sort(items);
                int largestIndex = items[items.length - 1];
                int i = items.length - 1;
                while (i >= 0) {
                    EditMacroDialog.this.mCommands.remove(items[i]);
                    --i;
                }
                EditMacroDialog.this.updateCommandTable();
                int newSelIndex = Math.min(Math.max(0, largestIndex - items.length + 1), EditMacroDialog.this.mCommandTable.getItemCount() - 1);
                if (newSelIndex < EditMacroDialog.this.mCommandTable.getItemCount()) {
                    EditMacroDialog.this.mCommandTable.setSelection(newSelIndex);
                }
                EditMacroDialog.this.updateButtons();
            }
        });
        this.mEditButton = new Button(buttonComp, 8);
        this.mEditButton.setText("Edit...");
        this.mEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = EditMacroDialog.this.mCommandTable.getSelection();
                if (items.length == 1) {
                    IMacroCommand command = (IMacroCommand)items[0].getData();
                    command.configure(EditMacroDialog.this.getShell());
                }
            }
        });
        this.mCopyButton = new Button(buttonComp, 8);
        this.mCopyButton.setText("Copy");
        this.mCopyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                TableItem[] tableItemArray = items = EditMacroDialog.this.mCommandTable.getSelection();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    IMacroCommand command = (IMacroCommand)tableItem.getData();
                    EditMacroDialog.this.mCommands.add(command.copy());
                    ++n2;
                }
                EditMacroDialog.this.updateCommandTable();
                EditMacroDialog.this.updateButtons();
            }
        });
        this.mMoveUpButton = new Button(buttonComp, 8);
        this.mMoveUpButton.setText("Move Up");
        this.mMoveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = EditMacroDialog.this.mCommandTable.getSelectionIndex();
                Collections.swap(EditMacroDialog.this.mCommands, selIndex, selIndex - 1);
                EditMacroDialog.this.updateCommandTable();
                EditMacroDialog.this.mCommandTable.setSelection(selIndex - 1);
                EditMacroDialog.this.updateButtons();
            }
        });
        this.mMoveDownButton = new Button(buttonComp, 8);
        this.mMoveDownButton.setText("Move Down");
        this.mMoveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = EditMacroDialog.this.mCommandTable.getSelectionIndex();
                Collections.swap(EditMacroDialog.this.mCommands, selIndex, selIndex + 1);
                EditMacroDialog.this.updateCommandTable();
                EditMacroDialog.this.mCommandTable.setSelection(selIndex + 1);
                EditMacroDialog.this.updateButtons();
            }
        });
        this.mCompressButton = new Button(buttonComp, 8);
        this.mCompressButton.setText("Compress strings");
        this.mCompressButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditMacroDialog.this.mCommands = EditorMacro.compressStringInsertions(EditMacroDialog.this.mCommands);
                EditMacroDialog.this.updateCommandTable();
                EditMacroDialog.this.updateButtons();
            }
        });
        Group idComp = new Group(comp, 0);
        idComp.setLayout((Layout)new GridLayout(2, false));
        idComp.setLayoutData((Object)new GridData(1808));
        idComp.setText("Macro info");
        Label l = new Label((Composite)idComp, 0);
        l.setText("Name: ");
        this.mNameText = new Text((Composite)idComp, 2052);
        this.mNameText.setLayoutData((Object)new GridData(768));
        if (this.mExistingMacro != null) {
            this.mNameText.setText(this.mExistingMacro.getName());
        }
        this.mNameText.setEditable(!this.mReadOnly);
        this.mNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditMacroDialog.this.updateButtons();
            }
        });
        l = new Label((Composite)idComp, 0);
        l.setText("id: ");
        this.mIDText = new Text((Composite)idComp, 2052);
        this.mIDText.setLayoutData((Object)new GridData(768));
        if (this.mExistingMacro != null) {
            this.mIDText.setText(this.mExistingMacro.getID());
        }
        this.mIDText.setEditable(this.mCanChangeID && !this.mReadOnly);
        this.mIDText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditMacroDialog.this.validatePage();
            }
        });
        l = new Label((Composite)idComp, 0);
        l.setText("Description: ");
        this.mMacroDescriptionText = new Text((Composite)idComp, 2626);
        descData = new GridData(768);
        gc = new GC((Drawable)this.mMacroDescriptionText);
        descData.heightHint = gc.getFontMetrics().getHeight() * 5;
        this.mMacroDescriptionText.setLayoutData((Object)descData);
        if (this.mExistingMacro != null) {
            this.mMacroDescriptionText.setText(this.mExistingMacro.getDescription());
        }
        this.mMacroDescriptionText.setEditable(!this.mReadOnly);
        this.mRunAsCompoundButton = new Button(comp, 32);
        this.mRunAsCompoundButton.setText("Run macro as a compound edit");
        this.mRunAsCompoundButton.setToolTipText("If checked, run macro as a compound editor operation.  This means that a subsequent Undo will undo edits for the entire operation.  Normally, this should be checked unless it causes problems.");
        this.mRunAsCompoundButton.setSelection(this.mExistingMacro == null || this.mExistingMacro.isRunAsCompoundEvent());
        return comp;
    }

    protected void validatePage() {
        if (this.mReadOnly) {
            this.getButton(0).setEnabled(false);
            this.setMessage("This command is not editable", 2);
            return;
        }
        String currentText = this.mIDText.getText();
        boolean isError = false;
        if (currentText.length() > 0 && this.mUsedIDs.contains(currentText) && (this.mExistingMacro == null || !currentText.equals(this.mExistingMacro.getID()))) {
            isError = true;
        }
        if (isError) {
            this.setMessage("ID conflicts with another command", 3);
            this.getButton(0).setEnabled(false);
        } else {
            this.setMessage(null);
            this.getButton(0).setEnabled(true);
        }
    }

    private void updateAvailableCommandTable() {
        Utilities.createStyledTextCommands();
        ICommandService cs = MacroManager.getOldCommandService();
        Command[] allCommands = cs.getDefinedCommands();
        ArrayList<IMacroCommand> allItems = new ArrayList<IMacroCommand>();
        int i = 0;
        while (i < allCommands.length) {
            Command command = allCommands[i];
            if (command.isDefined()) {
                allItems.add(new EclipseCommand(command.getId()));
            }
            ++i;
        }
        allItems.addAll(Utilities.getMacroSupportCommands());
        ArrayList<IMacroCommand> filteredCommands = new ArrayList<IMacroCommand>();
        if (this.mFilterNonEditorCommands.getSelection()) {
            for (IMacroCommand iMacroCommand : allItems) {
                if (!Utilities.isEditCategory(iMacroCommand.getCategoryID())) continue;
                if (!this.mFilterNonMacroCommands.getSelection()) {
                    filteredCommands.add(iMacroCommand);
                    continue;
                }
                if (!Utilities.isUserMacro(iMacroCommand) && !Utilities.isSupportCategory(iMacroCommand.getCategoryID())) continue;
                filteredCommands.add(iMacroCommand);
            }
        } else {
            filteredCommands = allItems;
        }
        Collections.sort(filteredCommands, new Comparator<IMacroCommand>(){

            @Override
            public int compare(IMacroCommand o1, IMacroCommand o2) {
                TableColumn column = EditMacroDialog.this.mAvailableCommandTable.getSortColumn();
                if (column == EditMacroDialog.this.mAvailNameColumn) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
                return o1.getCategory().compareToIgnoreCase(o2.getCategory());
            }
        });
        this.mAvailableCommandTable.removeAll();
        for (IMacroCommand iMacroCommand : filteredCommands) {
            TableItem t = new TableItem(this.mAvailableCommandTable, 0);
            t.setText(0, iMacroCommand.getName());
            t.setText(1, iMacroCommand.getCategory());
            t.setData((Object)iMacroCommand);
        }
    }

    protected void addCommandToMacroList(IMacroCommand command) {
        IMacroCommand newCommand = command;
        if (newCommand.isConfigurable()) {
            newCommand = command.copy();
            newCommand.configure(this.getShell());
        }
        this.mCommands.add(newCommand);
    }

    private void updateCommandTable() {
        this.mCommandTable.removeAll();
        for (IMacroCommand command : this.mCommands) {
            TableItem item = new TableItem(this.mCommandTable, 0);
            item.setText(0, command.getName());
            item.setText(1, command.getCategory());
            item.setData((Object)command);
        }
    }

    private void updateDescription() {
        this.mCommandDescriptionText.setText("");
        TableItem[] selItems = this.mCommandTable.getSelection();
        if (selItems.length > 0) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < selItems.length) {
                TableItem tableItem = selItems[i];
                buffer.append(((IMacroCommand)tableItem.getData()).getDescription());
                if (i + 1 < selItems.length) {
                    buffer.append("\n");
                }
                ++i;
            }
            this.mCommandDescriptionText.setText(buffer.toString());
        }
    }

    private void updateAvailDescription() {
        this.mAvailableDescriptionText.setText("");
        TableItem[] selItems = this.mAvailableCommandTable.getSelection();
        if (selItems.length > 0) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < selItems.length) {
                TableItem tableItem = selItems[i];
                String desc = ((IMacroCommand)tableItem.getData()).getDescription();
                if (desc != null) {
                    buffer.append(desc);
                    if (i + 1 < selItems.length) {
                        buffer.append("\n");
                    }
                }
                ++i;
            }
            this.mAvailableDescriptionText.setText(buffer.toString());
        }
    }

    private void updateButtons() {
        int selCount = this.mCommandTable.getSelectionCount();
        int selIndex = this.mCommandTable.getSelectionIndex();
        TableItem[] selItems = this.mCommandTable.getSelection();
        boolean isConfigurable = false;
        if (selItems.length == 1 && ((IMacroCommand)selItems[0].getData()).isConfigurable()) {
            isConfigurable = true;
        }
        this.mEditButton.setEnabled(!this.mReadOnly && isConfigurable);
        this.mDeleteButton.setEnabled(!this.mReadOnly && selCount > 0);
        this.mMoveUpButton.setEnabled(!this.mReadOnly && selCount == 1 && selIndex > 0);
        this.mMoveDownButton.setEnabled(!this.mReadOnly && selCount == 1 && selIndex < this.mCommandTable.getItemCount() - 1);
        this.mCopyButton.setEnabled(!this.mReadOnly && selCount > 0);
        this.mFilterNonMacroCommands.setEnabled(this.mFilterNonEditorCommands.getSelection());
        this.getButton(0).setEnabled(!this.mReadOnly && this.mNameText.getText().length() > 0);
        this.validatePage();
    }

    protected void okPressed() {
        this.mResultMacro = new EditorMacro(this.mCommands, this.mIDText.getText(), this.mNameText.getText(), this.mMacroDescriptionText.getText());
        this.mResultMacro.setRunAsCompoundEvent(this.mRunAsCompoundButton.getSelection());
        if (this.mExistingMacro != null) {
            this.mResultMacro.setSessionID(this.mExistingMacro.getSessionID());
        }
        super.okPressed();
    }

    public EditorMacro getMacro() {
        return this.mResultMacro;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateButtons();
    }
}

