/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.commands;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import practicallymacro.commands.IMacroCommand;
import practicallymacro.util.Utilities;

public class KeystrokeCommand
implements IMacroCommand {
    private Event mKeyEvent;
    private static final String XML_ATTR_STATEMASK = "stateMask";
    private static final String XML_ATTR_KEYCODE = "keyCode";
    private static final String XML_ATTR_TYPE = "eventType";
    private static final String XML_ATTR_CHARACTER = "character";
    public static final String XML_Macro_Keystroke_Type = "MacroKeystrokeCommand";

    public KeystrokeCommand(Event event) {
        this.mKeyEvent = event;
    }

    public KeystrokeCommand() {
    }

    public void configure(Shell shell) {
    }

    public IMacroCommand copy() {
        return null;
    }

    public void dump() {
    }

    public boolean execute(IEditorPart target) {
        if (this.mKeyEvent != null) {
            Display.getCurrent().post(this.mKeyEvent);
            return true;
        }
        return false;
    }

    public String getCategory() {
        return "PracticallyMacro utility command";
    }

    public String getCategoryID() {
        return "practicallymacro.category.utility.command";
    }

    public String getDescription() {
        return "Insert a single character into the document, as though by typing\n" + this.getName();
    }

    public String getName() {
        return String.valueOf(this.mKeyEvent.type == 1 ? "Key down" : "Key up") + " (" + this.mKeyEvent.character + ")";
    }

    public boolean isConfigurable() {
        return false;
    }

    public IMacroCommand createFrom(Element commandElement) {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        HashSet<String> attrKeys = new HashSet<String>();
        attrKeys.add(XML_ATTR_KEYCODE);
        attrKeys.add(XML_ATTR_STATEMASK);
        attrKeys.add(XML_ATTR_TYPE);
        attrKeys.add(XML_ATTR_CHARACTER);
        Utilities.getCommandData(commandElement, attrKeys, null, attrMap, null);
        Event event = new Event();
        KeystrokeCommand newCommand = new KeystrokeCommand(event);
        String value = (String)attrMap.get(XML_ATTR_KEYCODE);
        if (value != null && value.length() > 0) {
            event.keyCode = Integer.parseInt(value);
        }
        if ((value = (String)attrMap.get(XML_ATTR_STATEMASK)) != null && value.length() > 0) {
            event.stateMask = Integer.parseInt(value);
        }
        if ((value = (String)attrMap.get(XML_ATTR_TYPE)) != null && value.length() > 0) {
            event.type = Integer.parseInt(value);
        }
        if ((value = (String)attrMap.get(XML_ATTR_CHARACTER)) != null && value.length() > 0) {
            event.character = (char)Integer.parseInt(value);
        }
        return newCommand;
    }

    public void persist(Document doc, Element commandElement) {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put(XML_ATTR_KEYCODE, Integer.toString(this.mKeyEvent.keyCode));
        attrMap.put(XML_ATTR_STATEMASK, Integer.toString(this.mKeyEvent.stateMask));
        attrMap.put(XML_ATTR_TYPE, Integer.toString(this.mKeyEvent.type));
        attrMap.put(XML_ATTR_CHARACTER, Integer.toString(this.mKeyEvent.character));
        Utilities.persistCommand(doc, commandElement, XML_Macro_Keystroke_Type, attrMap, null);
    }

    public boolean requiresPost() {
        return true;
    }
}

