/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.commands;

import java.util.HashMap;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import practicallymacro.commands.IMacroCommand;
import practicallymacro.dialogs.InsertStringConfigureDlg;
import practicallymacro.util.Utilities;

public class InsertStringCommand
implements IMacroCommand {
    public static final String XML_Data_Tag = "data";
    public static final String XML_InsertStringType = "InsertStringCommand";
    private String mData;
    private MyExtendedModifyListener mExtendedModifyListener = new MyExtendedModifyListener();

    public InsertStringCommand(String data) {
        this.mData = data;
    }

    public InsertStringCommand() {
    }

    public void dump() {
        System.out.println(this.getName());
    }

    public boolean execute(IEditorPart target) {
        if (this.mData == null) {
            this.configure(target.getSite().getShell());
        }
        if (this.mData != null) {
            IDocument doc = Utilities.getIDocumentForEditor(target);
            StyledText widget = Utilities.getStyledText(target);
            if (widget != null) {
                int startPos = Utilities.getUndirectedSelection((IEditorPart)target).x;
                int selSize = Utilities.getSelectedText(target).length();
                if (doc != null && this.mData.length() > 1) {
                    try {
                        doc.replace(startPos, selSize, this.mData);
                        Utilities.getSourceViewer(target).setSelectedRange(startPos + this.mData.length(), 0);
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        widget.addExtendedModifyListener((ExtendedModifyListener)this.mExtendedModifyListener);
                        this.mExtendedModifyListener.clearCaret();
                        String insertString = this.mData;
                        if (this.mData.equals("\r") || this.mData.equals("\n")) {
                            insertString = widget.getLineDelimiter();
                        }
                        widget.insert(insertString);
                        if (this.mExtendedModifyListener.getCaretOffset() >= 0) {
                            widget.setCaretOffset(this.mExtendedModifyListener.getCaretOffset());
                        }
                    }
                    finally {
                        widget.removeExtendedModifyListener((ExtendedModifyListener)this.mExtendedModifyListener);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public void persist(Document doc, Element commandElement) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (this.mData != null) {
            dataMap.put(XML_Data_Tag, this.mData);
        }
        Utilities.persistCommand(doc, commandElement, XML_InsertStringType, null, dataMap);
    }

    public IMacroCommand createFrom(Element commandElement) {
        NodeList children = commandElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i).getNodeName().equals(XML_Data_Tag)) {
                String data = children.item(i).getTextContent();
                InsertStringCommand newCommand = new InsertStringCommand(data);
                return newCommand;
            }
            ++i;
        }
        return new InsertStringCommand();
    }

    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Insert the string into the document at the current caret location");
        if (this.mData != null) {
            buffer.append("\n");
            buffer.append(this.getName());
        }
        return buffer.toString();
    }

    public String getName() {
        String printableData = this.mData;
        if (printableData != null) {
            printableData = printableData.replace("\r", "<CR>");
            printableData = printableData.replace("\n", "<LF>");
            printableData = printableData.replace("\t", "<tab>");
        }
        return "Insert string: " + printableData;
    }

    public String getCategory() {
        return "PracticallyMacro utility command";
    }

    public void configure(Shell shell) {
        InsertStringConfigureDlg dlg = new InsertStringConfigureDlg(shell, this.mData);
        if (dlg.open() == 0) {
            this.mData = dlg.getText();
        }
    }

    public boolean isConfigurable() {
        return true;
    }

    public IMacroCommand copy() {
        return new InsertStringCommand(this.mData);
    }

    public String getCategoryID() {
        return "practicallymacro.category.utility.command";
    }

    public boolean requiresPost() {
        return false;
    }

    public boolean combineWith(InsertStringCommand anotherCommand) {
        if (this.mData.indexOf(10) >= 0 || anotherCommand.mData.indexOf(10) >= 0 || this.mData.indexOf(13) >= 0 || anotherCommand.mData.indexOf(13) >= 0) {
            return false;
        }
        this.mData = String.valueOf(this.mData) + anotherCommand.mData;
        return true;
    }

    private static class MyExtendedModifyListener
    implements ExtendedModifyListener {
        private int mCaretPos;

        private MyExtendedModifyListener() {
        }

        public void modifyText(ExtendedModifyEvent event) {
            this.mCaretPos = event.start + event.length;
        }

        public void clearCaret() {
            this.mCaretPos = -1;
        }

        public int getCaretOffset() {
            return this.mCaretPos;
        }
    }
}

