/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.commands;

import java.util.HashMap;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import practicallymacro.commands.IMacroCommand;
import practicallymacro.model.MacroManager;
import practicallymacro.util.MacroConsole;
import practicallymacro.util.Utilities;

public class EclipseCommand
implements IMacroCommand {
    public static final String XML_ID_ATTR = "commandID";
    public static final String XML_EclipseCommandType = "EclipseCommand";
    private String mCommandId;

    public EclipseCommand(String commandId) {
        this.mCommandId = commandId;
    }

    public EclipseCommand() {
    }

    public boolean execute(IEditorPart target) {
        ICommandService cs = MacroManager.getOldCommandService();
        Command command = cs.getCommand(this.mCommandId);
        if (command != null) {
            try {
                EclipseCommand.processEvents();
                IHandlerService hs = MacroManager.getOldHandlerService();
                hs.executeCommand(this.mCommandId, null);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                MacroConsole.getConsole().write(e, 2);
            }
        }
        return false;
    }

    protected static void processEvents() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null) {
            while (display.readAndDispatch()) {
            }
        }
    }

    public void dump() {
        System.out.println("Eclipse Command: " + this.mCommandId);
    }

    public void persist(Document doc, Element commandElement) {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put(XML_ID_ATTR, this.mCommandId);
        Utilities.persistCommand(doc, commandElement, XML_EclipseCommandType, attrMap, null);
    }

    public IMacroCommand createFrom(Element commandElement) {
        String commandID = commandElement.getAttribute(XML_ID_ATTR);
        EclipseCommand newCommand = new EclipseCommand(commandID);
        return newCommand;
    }

    public String getDescription() {
        ICommandService cs = MacroManager.getOldCommandService();
        Command command = cs.getCommand(this.mCommandId);
        try {
            return command.getDescription();
        }
        catch (NotDefinedException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getName() {
        ICommandService cs = MacroManager.getOldCommandService();
        Command command = cs.getCommand(this.mCommandId);
        try {
            return command.getName();
        }
        catch (NotDefinedException notDefinedException) {
            return this.mCommandId;
        }
    }

    public String getCategory() {
        ICommandService cs = MacroManager.getOldCommandService();
        Command command = cs.getCommand(this.mCommandId);
        try {
            Category cat = command.getCategory();
            if (cat != null) {
                return cat.getName();
            }
        }
        catch (NotDefinedException notDefinedException) {}
        return "";
    }

    public String getCategoryID() {
        ICommandService cs = MacroManager.getOldCommandService();
        Command command = cs.getCommand(this.mCommandId);
        try {
            Category cat = command.getCategory();
            if (cat != null) {
                return cat.getId();
            }
        }
        catch (NotDefinedException notDefinedException) {}
        return "";
    }

    public void configure(Shell shell) {
    }

    public boolean isConfigurable() {
        return false;
    }

    public IMacroCommand copy() {
        return new EclipseCommand(this.mCommandId);
    }

    public String getCommandID() {
        return this.mCommandId;
    }

    public boolean requiresPost() {
        return false;
    }
}

