/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.commands.ICommandService;
import practicallymacro.actions.PlayCommandAction;
import practicallymacro.commands.EclipseCommand;
import practicallymacro.dialogs.EditMacroDialog;
import practicallymacro.dialogs.MacroDefinitionsPage;
import practicallymacro.model.EditorMacro;
import practicallymacro.model.MacroManager;
import practicallymacro.util.Utilities;

public class PlayDropdownAction
implements IWorkbenchWindowPulldownDelegate {
    private Menu fMenu;
    private IAction mPlayAnyCommandAction = new PlayCommandAction();

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        EditorMacro macro = MacroManager.getManager().getLastMacro();
        if (macro != null) {
            IEditorPart editor = Utilities.getActiveEditor();
            macro.run(editor);
        } else {
            MessageDialog.openInformation(null, (String)"Execute last macro", (String)"No recently recorded/used macro");
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public Menu getMenu(Control parent) {
        this.setMenu(new Menu(parent));
        this.fillMenu(this.fMenu);
        this.initMenu();
        return this.fMenu;
    }

    protected void fillMenu(Menu menu) {
        List<EditorMacro> macros;
        ActionContributionItem item = new ActionContributionItem(this.mPlayAnyCommandAction);
        item.fill(menu, -1);
        List<EditorMacro> tempMacros = MacroManager.getManager().getUsedTempMacros(15);
        if (tempMacros.size() > 0) {
            MenuItem cascadeMenu = new MenuItem(menu, 64);
            cascadeMenu.setText("Temporary macros");
            Menu tempMRUMenu = new Menu(cascadeMenu);
            cascadeMenu.setMenu(tempMRUMenu);
            for (EditorMacro macro : tempMacros) {
                Object action = new MacroAction(macro);
                item = new ActionContributionItem(action);
                item.fill(tempMRUMenu, -1);
            }
        }
        if ((macros = MacroManager.getManager().getUsedMacros(15)).size() > 0) {
            MenuItem cascadeMenu = new MenuItem(menu, 64);
            cascadeMenu.setText("Saved Macros");
            Menu mruMenu = new Menu(cascadeMenu);
            cascadeMenu.setMenu(mruMenu);
            for (EditorMacro editorMacro : macros) {
                MacroAction action = new MacroAction(editorMacro);
                item = new ActionContributionItem((IAction)action);
                item.fill(mruMenu, -1);
            }
        }
        new MenuItem(menu, 2);
        ArrayList<EditorMacro> allMacros = new ArrayList<EditorMacro>();
        allMacros.addAll(macros);
        allMacros.addAll(tempMacros);
        Collections.sort(allMacros, new Comparator<EditorMacro>(){

            @Override
            public int compare(EditorMacro o1, EditorMacro o2) {
                return o1.getLastUse() > o2.getLastUse() ? -1 : 1;
            }
        });
        if (allMacros.size() > 0) {
            MenuItem cascadeMenu = new MenuItem(menu, 64);
            cascadeMenu.setText("Edit macro...");
            Menu editMenu = new Menu(cascadeMenu);
            cascadeMenu.setMenu(editMenu);
            int i = 0;
            while (i < Math.min(10, allMacros.size())) {
                EditorMacro macro = (EditorMacro)allMacros.get(i);
                EditMacroAction action = new EditMacroAction(macro);
                item = new ActionContributionItem((IAction)action);
                item.fill(editMenu, -1);
                ++i;
            }
        }
        MenuItem debugItem = new MenuItem(menu, 32);
        debugItem.setText("Macro debug mode");
        debugItem.setSelection(MacroManager.getManager().isMacroDebugMode());
        debugItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MacroManager.getManager().setMacroDebugMode(!MacroManager.getManager().isMacroDebugMode());
            }
        });
    }

    private void initMenu() {
        this.fMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu m = (Menu)e.widget;
                MenuItem[] items = m.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                PlayDropdownAction.this.fillMenu(m);
            }
        });
    }

    private void setMenu(Menu menu) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = menu;
    }

    protected void addToMenu(Menu menu, IAction action, int accelerator) {
        StringBuffer label = new StringBuffer();
        if (accelerator >= 0 && accelerator < 10) {
            label.append('&');
            label.append(accelerator);
            label.append(' ');
        }
        label.append(action.getText());
        action.setText(label.toString());
        ActionContributionItem item = new ActionContributionItem(action);
        item.fill(menu, -1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EditMacroAction
    extends Action {
        private EditorMacro mMacro;

        public EditMacroAction(EditorMacro macro) {
            this.mMacro = macro;
        }

        public String getText() {
            return this.mMacro.getName();
        }

        protected Set<String> getIDSet() {
            Map<Integer, EditorMacro> allMacros = MacroManager.getManager().getUniqueMacroMap();
            HashSet<String> currentIDs = new HashSet<String>();
            for (EditorMacro macro : allMacros.values()) {
                if (macro.getID().length() <= 0) continue;
                currentIDs.add(macro.getID());
            }
            ICommandService cs = MacroManager.getOldCommandService();
            Collection allCommands = cs.getDefinedCommandIds();
            for (String commandID : allCommands) {
                if (commandID.length() <= 0) continue;
                currentIDs.add(commandID);
            }
            return currentIDs;
        }

        public void run() {
            Set<String> idSet = this.getIDSet();
            Map<Integer, EditorMacro> allMacros = MacroManager.getManager().getUniqueMacroMap();
            EditMacroDialog dlg = new EditMacroDialog(Display.getDefault().getActiveShell(), this.mMacro, idSet, MacroDefinitionsPage.getUsageOfMacro(allMacros, this.mMacro).size() == 0, this.mMacro.isContributed());
            if (dlg.open() == 0) {
                allMacros.put(this.mMacro.getSessionID(), dlg.getMacro());
                MacroManager.getManager().replaceDefinedMacros(allMacros);
            }
        }
    }

    private static class MacroAction
    extends Action {
        private EditorMacro mMacro;

        public MacroAction(EditorMacro macro) {
            this.mMacro = macro;
        }

        public String getText() {
            return this.mMacro.getName();
        }

        public void run() {
            ICommandService cs = MacroManager.getOldCommandService();
            Command systemCommand = null;
            if (this.mMacro.getID().length() > 0) {
                systemCommand = cs.getCommand(this.mMacro.getID());
            }
            if (systemCommand != null && MacroManager.getManager().getMacroState() == "MACROSTATE_RECORDING") {
                MacroManager.getManager().getRecorder().pauseRecording();
            }
            IEditorPart editor = Utilities.getActiveEditor();
            this.mMacro.run(editor);
            if (systemCommand != null && MacroManager.getManager().getMacroState() == "MACROSTATE_RECORDING") {
                MacroManager.getManager().getRecorder().resumeRecording();
                MacroManager.getManager().getRecorder().recordCommand(new EclipseCommand(this.mMacro.getID()));
            }
        }
    }
}

