/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.ceditor.texthover;

import com.unisys.tde.core.OS2200CorePlugin;
import org.eclipse.cdt.internal.ui.text.c.hover.CSourceHover;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.contentassist.COBOLCompletionProcessor;
import org.eclipse.cobol.ui.intfc.IDataDictonary;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class CExtendedTextHover
extends CSourceHover {
    IRegion hoverRegion1 = null;
    private static IDataDictonary dataDicParser = null;

    static {
        dataDicParser = COBOLCompletionProcessor.getDataDicParser();
    }

    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        String string = "";
        this.hoverRegion1 = null;
        if (iTextViewer == null || iRegion == null) {
            return "";
        }
        try {
            iTextViewer.getDocument().getLineOfOffset(iRegion.getOffset());
        }
        catch (BadLocationException badLocationException) {
            CBDTUiPlugin.logError((Exception)((Object)badLocationException));
        }
        if (iTextViewer.getDocument() != null) {
            try {
                this.checkForHypen(iTextViewer, iRegion);
                if (this.hoverRegion1 != null) {
                    iRegion = this.hoverRegion1;
                }
                string = iTextViewer.getDocument().get(iRegion.getOffset(), iRegion.getLength());
                System.out.println("Variable name is .................." + string);
                iTextViewer.getDocument().computeNumberOfLines(string);
            }
            catch (BadLocationException badLocationException) {
                CBDTUiPlugin.logError((Exception)((Object)badLocationException));
            }
        }
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        if (string.equalsIgnoreCase("FILLER")) {
            return "COBOL KEYWORD";
        }
        if (string != null && string.trim().length() > 0) {
            String string2 = "";
            if (dataDicParser != null && (string2 = dataDicParser.getVariableInformation(iTextViewer, string)) != null && !string2.isEmpty()) {
                string = string2;
                if (string.contains("<br>")) {
                    string = string.replaceAll("<br>", "\n");
                }
                if (string.contains("<BR>")) {
                    string = string.replaceAll("<BR>", "\n");
                }
            }
            if ((string2 == null || string2.trim().length() == 0) && (string = super.getHoverInfo(iTextViewer, iRegion)) == null) {
                string = "";
            }
        } else {
            string = super.getHoverInfo(iTextViewer, iRegion);
            if (string == null) {
                string = "";
            }
        }
        return string;
    }

    public void checkForHypen(final ITextViewer iTextViewer, final IRegion iRegion) {
        this.hoverRegion1 = null;
        int n = iRegion.getOffset();
        int n2 = iRegion.getLength();
        IDocument iDocument = iTextViewer.getDocument();
        try {
            if (n - 1 >= 0 && iDocument.getChar(n - 1) == '-' || n + n2 < iDocument.getLength() && iDocument.getChar(n + n2) == '-') {
                OS2200CorePlugin.logger.debug((Object)"C text hover encountered a hypen so again calculating the mouse hover ");
                System.out.println("C text hover encountered a hypen so again calculating the mouse hover ");
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CExtendedTextHover.this.hoverRegion1 = CExtendedTextHover.this.getHoverRegion(iTextViewer, iRegion.getOffset());
                            OS2200CorePlugin.logger.debug((Object)"C text hover encountered a hypen so calculated teh mouse hover length ");
                            System.out.println("C text hover encountered a hypen so calculated teh mouse hover length ");
                        }
                        catch (Exception exception) {
                            OS2200CorePlugin.logger.error((Object)("In checkForHypen() in CExtendedTextHover" + exception));
                            CExtendedTextHover.this.hoverRegion1 = null;
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)("In data dictionary xml parser getlocalvariable info" + exception));
            this.hoverRegion1 = null;
        }
    }

    public IRegion getHoverRegion(ITextViewer iTextViewer, int n) {
        if (iTextViewer != null) {
            Point point = iTextViewer.getSelectedRange();
            if (point.x >= 0 && point.y > 0 && n >= point.x && n <= point.x + point.y) {
                return new Region(point.x, point.y);
            }
            return CExtendedTextHover.findWord(iTextViewer.getDocument(), n);
        }
        return null;
    }

    public static IRegion findWord(IDocument iDocument, int n) {
        int n2 = -2;
        int n3 = -1;
        try {
            char c;
            int n4 = n;
            while (--n4 >= 0) {
                c = iDocument.getChar(n4);
                if (!Character.isJavaIdentifierPart(c) && c != '-') break;
            }
            n2 = n4;
            n4 = n;
            int n5 = iDocument.getLength();
            while (n4 < n5) {
                c = iDocument.getChar(n4);
                if (!Character.isJavaIdentifierPart(c) && c != '-') break;
                ++n4;
            }
            n3 = n4;
        }
        catch (BadLocationException badLocationException) {}
        if (n2 >= -1 && n3 > -1) {
            if (n2 == n && n3 == n) {
                return new Region(n, 0);
            }
            if (n2 == n) {
                return new Region(n2, n3 - n2);
            }
            return new Region(n2 + 1, n3 - n2 - 1);
        }
        return null;
    }

    public static IDataDictonary getDataDicParser() {
        if (dataDicParser == null) {
            dataDicParser = COBOLCompletionProcessor.getDataDicParser();
        }
        return dataDicParser;
    }

    public static void setDataDicParser(IDataDictonary iDataDictonary) {
        dataDicParser = iDataDictonary;
    }
}

