/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.ceditor.completion.contentassistant;

import com.unisys.os2200.ceditor.completion.contentassistant.CEditorTemplate;
import java.util.ArrayList;

public class Category {
    private ArrayList<Object> categoryChildren;
    private ArrayList<Object> templateChildren;
    private Category parent;
    private String name;
    private String description;
    private static final String DUMMY_ROOT_NAME = "TemplateRoot";
    private static Category rootCategory = null;
    private static Category templateRootCategory = null;
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private String expanded = "false";

    public Category(String string, String string2, Category category) {
        this.name = string;
        this.description = string2;
        this.parent = category;
        this.categoryChildren = new ArrayList();
        this.templateChildren = new ArrayList();
    }

    public static Category getRootCategoryInstance() {
        if (rootCategory == null) {
            templateRootCategory = new Category(DUMMY_ROOT_NAME, "", null);
            rootCategory = new Category("templates.xml", "", templateRootCategory);
            templateRootCategory.addCategoryChild(rootCategory);
        }
        return rootCategory;
    }

    public static void setRootCategoryInstance() {
        rootCategory = null;
    }

    public Category getParent() {
        return this.parent;
    }

    public void setParent(Category category) {
        this.parent = category;
    }

    public void addCategoryChild(Category category) {
        this.categoryChildren.add(category);
    }

    public void addTemplateChild(CEditorTemplate cEditorTemplate) {
        this.templateChildren.add((Object)cEditorTemplate);
    }

    public Category[] getCategoryChildren() {
        if (this.categoryChildren.size() > 0) {
            return this.categoryChildren.toArray(new Category[this.categoryChildren.size()]);
        }
        return new Category[0];
    }

    public CEditorTemplate[] getTemplateChildren() {
        if (this.templateChildren.size() > 0) {
            return this.templateChildren.toArray(new CEditorTemplate[this.templateChildren.size()]);
        }
        return new CEditorTemplate[0];
    }

    public void removeCategory(Category category) {
        this.categoryChildren.remove(category);
    }

    public void removeTemplate(CEditorTemplate cEditorTemplate) {
        this.templateChildren.remove((Object)cEditorTemplate);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.name;
    }

    public void clearChildren() {
        this.templateChildren.clear();
        this.categoryChildren.clear();
    }

    public boolean hasChildren() {
        return this.categoryChildren.size() > 0 || this.templateChildren.size() > 0;
    }

    public boolean isExpandedState() {
        return this.expanded.equals(TRUE);
    }

    public void setExpandedState(boolean bl) {
        this.expanded = bl ? TRUE : FALSE;
    }
}

