/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.util;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.FileInfo;
import com.unisys.os2200.util.FileInfoMap;
import com.unisys.os2200.util.OS2200ArchitectureConstant;
import com.unisys.os2200.util.PrefKeyStoreConst;
import com.unisys.os2200.util.UtilLogger;
import com.unisys.os2200.util.WatchDir;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.log4j.Priority;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.markers.MarkersTreeViewer;
import org.eclipse.ui.internal.views.markers.ProblemsView;
import org.eclipse.ui.views.markers.MarkerItem;
import org.osgi.framework.Bundle;

public class TDECoreUtilities {
    private static final String WS_PATH = ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toOSString();
    private static final String CACHE_PATH = String.valueOf(WS_PATH) + File.separator + "Data-Cache";
    public static final String META_TOC_FILENAME = ".metaTOC";
    public static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private FileInfoMap fileInfoMap;
    private static TDECoreUtilities instance = null;
    private String FILE_INFO_MAP_LOC = String.valueOf(WS_PATH) + File.separator + ".metadata" + File.separator + ".fileInfoMap";
    private WatchDir dirMonitor;
    private static String syncThreadName = "SYNC_THREAD";
    private Thread syncThread = new Thread(syncThreadName);
    private Vector<String> monitoredFiles = new Vector();
    private String returnMessage = "";
    boolean pauseSyncThread = false;
    String unInitializedEltStatus = "";
    String returnValue = "";
    static ProblemsView hView = null;
    static IDoubleClickListener dcl = null;

    private TDECoreUtilities() {
        File file = new File(this.FILE_INFO_MAP_LOC);
        if (file.exists()) {
            this.fileInfoMap = new FileInfoMap();
            try {
                this.loadFileMapInfo();
            }
            catch (Exception exception) {
                UtilLogger.getLogger().debug((Object)exception.getMessage(), (Throwable)exception);
            }
        } else {
            this.fileInfoMap = new FileInfoMap();
        }
        this.dirMonitor = new WatchDir();
    }

    public Thread getSyncThread() {
        return this.syncThread;
    }

    public boolean monitor(String string) {
        try {
            if (!this.monitoredFiles.contains(string)) {
                this.dirMonitor.monitor(string);
                this.monitoredFiles.add(string);
            }
        }
        catch (FileSystemException fileSystemException) {
            UtilLogger.getLogger().debug((Object)fileSystemException.getMessage(), (Throwable)fileSystemException);
            return false;
        }
        return true;
    }

    public static TDECoreUtilities getInstance() {
        if (instance == null) {
            instance = new TDECoreUtilities();
        }
        return instance;
    }

    public FileInfo getFileInfo(String string) {
        return this.fileInfoMap.get(string);
    }

    public void addFileInfoToMap(FileInfo fileInfo) {
        this.fileInfoMap.add(fileInfo.getLocalFile(), fileInfo);
    }

    public void addFileInfo(FileInfo fileInfo) {
        this.addFileInfoToMap(fileInfo);
        this.storeFileMapInfo();
    }

    private void loadFileMapInfo() throws Exception {
        if (!new File(this.FILE_INFO_MAP_LOC).exists()) {
            UtilLogger.getLogger().error((Object)("Unable to locate " + this.FILE_INFO_MAP_LOC));
            return;
        }
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.FILE_INFO_MAP_LOC);
            objectInputStream = new ObjectInputStream(fileInputStream);
            this.fileInfoMap = (FileInfoMap)objectInputStream.readObject();
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {
                    UtilLogger.getLogger().info((Object)iOException.getMessage(), (Throwable)iOException);
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    UtilLogger.getLogger().error((Object)iOException.getMessage(), (Throwable)iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeFileMapInfo() {
        FileInfoMap fileInfoMap = this.fileInfoMap;
        synchronized (fileInfoMap) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.FILE_INFO_MAP_LOC);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(this.fileInfoMap);
                objectOutputStream.close();
                fileOutputStream.close();
                UtilLogger.getLogger().debug((Object)("Serialized data is saved in " + this.FILE_INFO_MAP_LOC));
            }
            catch (IOException iOException) {
                UtilLogger.getLogger().error((Object)iOException.getMessage(), (Throwable)iOException);
            }
        }
    }

    public String copyToHost(final File file, final File file2, final String string) {
        UtilLogger.getLogger().debug((Object)("Copying " + file + " to " + file2));
        if (!file2.exists()) {
            UtilLogger.getLogger().error((Object)(file2 + " does not exist."));
            return Messages.getString((String)"TDECoreUtil.3");
        }
        if (!file.exists()) {
            UtilLogger.getLogger().error((Object)(file + " does not exist."));
            return Messages.getString((String)"TDECoreUtil.1");
        }
        if (string == null) {
            this.returnMessage = this.copyFile(file, file2, string, null, true);
        } else {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
            try {
                progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        TDECoreUtilities.this.returnMessage = TDECoreUtilities.this.copyFile(file, file2, string, iProgressMonitor, true);
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                UtilLogger.getLogger().error((Object)invocationTargetException.getMessage(), (Throwable)invocationTargetException);
                return invocationTargetException.getMessage();
            }
            catch (InterruptedException interruptedException) {
                UtilLogger.getLogger().error((Object)interruptedException.getMessage(), (Throwable)interruptedException);
                return interruptedException.getMessage();
            }
        }
        return this.returnMessage;
    }

    private String copyFile(File file, File file2, String string, IProgressMonitor iProgressMonitor, boolean bl) {
        UtilLogger.getLogger().debug((Object)("Copying " + file + " to " + file2));
        this.pauseSyncThread = true;
        if (iProgressMonitor != null || string != null) {
            iProgressMonitor.beginTask(string, -1);
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel2 = null;
        ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            abstractInterruptibleChannel = fileInputStream.getChannel();
            int n = (int)((FileChannel)abstractInterruptibleChannel).size();
            int n2 = 0;
            int n3 = n / 65536;
            if (iProgressMonitor != null) {
                iProgressMonitor.beginTask("", n3);
            }
            abstractInterruptibleChannel2 = fileOutputStream.getChannel();
            while (((FileChannel)abstractInterruptibleChannel).read(byteBuffer) != -1) {
                if (iProgressMonitor != null) {
                    iProgressMonitor.subTask(Messages.getString((String)"TDECoreUtil.8", (String)String.valueOf(n2), (String)String.valueOf(n)));
                }
                byteBuffer.flip();
                ((FileChannel)abstractInterruptibleChannel2).write(byteBuffer);
                byteBuffer.clear();
                n2 += 65536;
                if (iProgressMonitor == null) continue;
                iProgressMonitor.worked(1);
            }
            try {
                if (abstractInterruptibleChannel2 != null) {
                    abstractInterruptibleChannel2.close();
                    abstractInterruptibleChannel2 = null;
                }
                if (abstractInterruptibleChannel != null) {
                    abstractInterruptibleChannel.close();
                    abstractInterruptibleChannel = null;
                }
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                    fileOutputStream = null;
                }
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                    fileInputStream = null;
                }
                if (byteBuffer != null) {
                    byteBuffer.clear();
                    byteBuffer = null;
                }
            }
            catch (Exception exception) {
                UtilLogger.getLogger().error((Object)("The file has been saved to local cache. \n\nCopying the file contents to the Host failed for the following reasons.\n\n" + exception.getLocalizedMessage()), (Throwable)exception);
                String string2 = exception.getMessage();
                try {
                    if (abstractInterruptibleChannel2 != null) {
                        abstractInterruptibleChannel2.close();
                        abstractInterruptibleChannel2 = null;
                    }
                    if (abstractInterruptibleChannel != null) {
                        abstractInterruptibleChannel.close();
                        abstractInterruptibleChannel = null;
                    }
                    if (fileOutputStream != null) {
                        ((OutputStream)fileOutputStream).close();
                        fileOutputStream = null;
                    }
                    if (fileInputStream != null) {
                        ((InputStream)fileInputStream).close();
                        fileInputStream = null;
                    }
                    if (byteBuffer != null) {
                        byteBuffer.clear();
                        byteBuffer = null;
                    }
                }
                catch (Exception exception2) {
                    UtilLogger.getLogger().error((Object)("The file has been saved to local cache. \n\nCopying the file contents to the Host failed for the following reasons.\n\n" + exception2.getLocalizedMessage()), (Throwable)exception2);
                    return exception2.getMessage();
                }
                this.pauseSyncThread = false;
                return string2;
            }
            FileInfo fileInfo = null;
            if (bl) {
                long l = file2.lastModified();
                file.setLastModified(l);
                fileInfo = new FileInfo(file.getPath(), file2.getPath(), l, l);
            } else {
                long l = file.lastModified();
                if (!file2.setLastModified(l)) {
                    UtilLogger.getLogger().info((Object)("Error setting last modified timestamp " + file2.toString()));
                }
                fileInfo = new FileInfo(file2.getPath(), file.getPath(), l, l);
            }
            if (fileInfo != null) {
                this.addFileInfo(fileInfo);
            }
            return "";
        }
        catch (Exception exception) {
            UtilLogger.getLogger().error((Object)exception.getLocalizedMessage(), (Throwable)exception);
            String string3 = exception.getMessage();
            return string3;
        }
        finally {
            try {
                if (abstractInterruptibleChannel2 != null) {
                    abstractInterruptibleChannel2.close();
                    abstractInterruptibleChannel2 = null;
                }
                if (abstractInterruptibleChannel != null) {
                    abstractInterruptibleChannel.close();
                    abstractInterruptibleChannel = null;
                }
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                    fileOutputStream = null;
                }
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                    fileInputStream = null;
                }
                if (byteBuffer != null) {
                    byteBuffer.clear();
                    byteBuffer = null;
                }
            }
            catch (Exception exception) {
                UtilLogger.getLogger().error((Object)("The file has been saved to local cache. \n\nCopying the file contents to the Host failed for the following reasons.\n\n" + exception.getLocalizedMessage()), (Throwable)exception);
                return exception.getMessage();
            }
            this.pauseSyncThread = false;
        }
    }

    public String copyToHost(File file, File file2) {
        return this.copyToHost(file, file2, null);
    }

    public String copyToLocal(final File file, final File file2, final String string) {
        if (!file2.exists()) {
            TDECoreUtilities.makedir(new Path(file2.getParent()));
        }
        if (!file.exists()) {
            return Messages.getString((String)"TDECoreUtil.3");
        }
        if (!file.canRead()) {
            return Messages.getString((String)"TDECoreUtil.3");
        }
        if (string == null) {
            this.returnValue = this.copyFile(file, file2, string, null, false);
        } else {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
            try {
                progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        TDECoreUtilities.this.returnValue = TDECoreUtilities.this.copyFile(file, file2, string, iProgressMonitor, false);
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                UtilLogger.getLogger().error((Object)invocationTargetException.getMessage(), (Throwable)invocationTargetException);
                return invocationTargetException.getMessage();
            }
            catch (InterruptedException interruptedException) {
                UtilLogger.getLogger().error((Object)interruptedException.getMessage(), (Throwable)interruptedException);
                return interruptedException.getMessage();
            }
        }
        return this.returnValue;
    }

    public String copyToLocal(File file, File file2) {
        return this.copyToLocal(file, file2, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String downloadingUnInitializedElement(IFile iFile, boolean bl) {
        block23: {
            this.unInitializedEltStatus = "";
            try {
                String string;
                if (iFile == null) {
                    UtilLogger.getLogger().warn((Object)"In initialized download element is getting file perimeter as a 'null'");
                    return Messages.getString((String)"TDECoreUtilities_0");
                }
                IPath iPath = iFile.getRawLocation();
                if (iPath == null) {
                    iFile.delete(true, null);
                    UtilLogger.getLogger().warn((Object)("'" + iFile.getName() + "' is not linked. Hence it will be removed from the project Tree."));
                    return String.valueOf(Messages.getString((String)"TDECoreUtilities_2")) + iFile.getName() + Messages.getString((String)"TDECoreUtilities_3");
                }
                File file = new File(iPath.toOSString());
                FileInfo fileInfo = TDECoreUtilities.getInstance().getFileInfo(file.toString());
                if (fileInfo == null && (string = TDECoreUtilities.getCIFSPathFromFilePath(iPath.toOSString())) != null) {
                    this.createUnInitializedFile(new File(string), file);
                    fileInfo = TDECoreUtilities.getInstance().getFileInfo(file.toString());
                }
                if (fileInfo != null) {
                    string = fileInfo.getRemoteFile();
                    File file2 = new File(string);
                    if (file2 == null || !file2.exists()) {
                        UtilLogger.getLogger().info((Object)("Unable to find '" + iFile.getName() + "'. May be deleted or unable to connect to the host."));
                        return String.valueOf(Messages.getString((String)"TDECoreUtilities_4")) + Messages.getString((String)"TDECoreUtilities_5") + iFile.getName() + Messages.getString((String)"TDECoreUtilities_6");
                    }
                    if (file2.isDirectory()) {
                        iFile.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "True");
                        iFile.setPersistentProperty(OS2200ArchitectureConstant.IS_DIRECTORY, "True");
                        return String.valueOf(Messages.getString((String)"TDECoreUtilities_7")) + iFile.getName() + Messages.getString((String)"TDECoreUtilities_8");
                    }
                    FileInputStream fileInputStream = null;
                    try {
                        try {
                            fileInputStream = new FileInputStream(string);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            if (!fileNotFoundException.getMessage().contains("being used by another process")) {
                                file.setLastModified(1L);
                            }
                            UtilLogger.getLogger().warn((Object)fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
                            String string2 = fileNotFoundException.getMessage();
                            if (fileInputStream == null) return string2;
                            fileInputStream.close();
                            fileInputStream = null;
                            return string2;
                        }
                    }
                    finally {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                            fileInputStream = null;
                        }
                    }
                    if (bl) {
                        String string3 = file.getName();
                        if (string3.contains(".")) {
                            string3 = string3.replace(".", "/");
                        }
                        String string4 = String.valueOf(Messages.getString((String)"TDECoreUtilities_9")) + string3 + Messages.getString((String)"TDECoreUtilities_10");
                        this.unInitializedEltStatus = this.copyToLocal(file2, file, string4);
                    } else {
                        this.unInitializedEltStatus = this.copyToLocal(file2, file);
                    }
                    if (this.unInitializedEltStatus.length() == 0) {
                        iFile.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "False");
                        iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "True");
                        break block23;
                    } else {
                        file.setLastModified(0L);
                        iFile.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "True");
                        UtilLogger.getLogger().error((Object)("Unable to download " + iPath.toOSString()));
                    }
                    break block23;
                }
                this.unInitializedEltStatus = String.valueOf(Messages.getString((String)"TDECoreUtilities_11")) + iPath.toOSString();
            }
            catch (Exception exception) {
                UtilLogger.getLogger().warn((Object)exception.getMessage(), (Throwable)exception);
                this.unInitializedEltStatus = String.valueOf(Messages.getString((String)"TDECoreUtilities_12")) + iFile + exception.getMessage();
            }
        }
        try {
            iFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            return this.unInitializedEltStatus;
        }
        catch (CoreException coreException) {
            UtilLogger.getLogger().error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
        }
        return this.unInitializedEltStatus;
    }

    public static boolean makedir(Path path) {
        File file = path.toFile();
        boolean bl = true;
        if (!file.exists() && !(bl = file.mkdirs())) {
            UtilLogger.getLogger().error((Object)("Unable to create path " + path));
        }
        return bl;
    }

    public static Path getCIFSPath(String string, String string2, String string3) {
        if (string != null && string3 != null && string3.trim().length() > 0 && string.trim().length() > 0) {
            if (string2 != null && string2.trim().length() > 0) {
                if (string2.contains("*")) {
                    string2 = string2.replace("*", File.separator);
                }
                if (string2.contains(".")) {
                    string2 = string2.replace(".", "");
                }
                return new Path(String.valueOf(string) + File.separator + string3 + File.separator + string2);
            }
            return new Path(String.valueOf(string) + File.separator + string3);
        }
        return null;
    }

    public static Path getFullProjectpath(Path path, Path path2) {
        if (path != null && path2 != null) {
            return new Path(path + File.separator + path2);
        }
        return null;
    }

    public static Path getFullProjectpath(Path path) {
        if (CACHE_PATH != null && path != null && CACHE_PATH.length() > 0) {
            return new Path(String.valueOf(CACHE_PATH) + File.separator + path);
        }
        return null;
    }

    public static Path getFullProjectpath(String string) {
        if (CACHE_PATH != null && string != null && CACHE_PATH.length() > 0) {
            return new Path(String.valueOf(CACHE_PATH) + File.separator + string);
        }
        return null;
    }

    public static Path getFullProjectpath(String string, String string2, String string3) {
        if (string != null && string2 != null && string3 != null && string3.trim().length() > 0 && string.trim().length() > 0 && string2.trim().length() > 0) {
            if (string2.contains("*")) {
                string2 = string2.replace("*", File.separator);
            }
            if (string2.contains(".")) {
                string2 = string2.replace(".", "");
            }
            return new Path(String.valueOf(CACHE_PATH) + File.separator + "Data-Cache" + File.separator + string + File.separator + string3 + File.separator + string2);
        }
        return null;
    }

    public static IPath getPluginDirectoryPath(String string) {
        Path path = null;
        try {
            Bundle bundle = Platform.getBundle((String)string);
            URL uRL = Platform.resolve((URL)bundle.getEntry("/"));
            path = new Path(uRL.getFile());
        }
        catch (IOException iOException) {
            UtilLogger.getLogger().error((Object)iOException.getMessage(), (Throwable)iOException);
        }
        return path;
    }

    public static String getCIFSPathFromFilePath(String string) {
        if (string.toUpperCase().contains("Data-Cache".toUpperCase())) {
            String string2 = String.valueOf(File.separator) + string.substring(CACHE_PATH.length(), string.length()).trim();
            if (string2.contains("/")) {
                string2 = string2.replace("/", "\\");
            }
            return string2;
        }
        return null;
    }

    public static boolean appendTOC(String string, File file) throws IOException {
        long l = System.currentTimeMillis();
        List<String> list = TDECoreUtilities.readTOC(file);
        if (list.contains(string)) {
            long l2 = System.currentTimeMillis();
            UtilLogger.getLogger().debug((Object)("Total time to check the TOC is " + (l2 - l) + " ms."));
            return true;
        }
        try (PrintWriter printWriter = null;){
            File file2 = new File(file + File.separator + META_TOC_FILENAME);
            if (!file2.exists()) {
                TDECoreUtilities.createTOCFile(file);
            }
            printWriter = new PrintWriter(new FileWriter(file + File.separator + META_TOC_FILENAME, true));
            printWriter.println(string);
        }
        long l3 = System.currentTimeMillis();
        UtilLogger.getLogger().debug((Object)("Total time to update filebased TOC is " + (l3 - l) + " ms."));
        return true;
    }

    public static boolean createTOC(File file, File file2) throws IOException {
        File[] fileArray = file.listFiles();
        long l = System.currentTimeMillis();
        PrintWriter printWriter = null;
        try {
            File file3 = new File(file2 + File.separator + META_TOC_FILENAME);
            if (!file3.exists()) {
                TDECoreUtilities.createTOCFile(file2);
            }
            printWriter = new PrintWriter(file2 + File.separator + META_TOC_FILENAME);
            if (fileArray == null || fileArray.length <= 0) {
                return true;
            }
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file4 = fileArray2[n2];
                printWriter.println(file4.getName().toUpperCase());
                ++n2;
            }
            PrefKeyStoreConst.storeInPreference(String.valueOf(PrefKeyStoreConst.CACHE_TIMESTAMP) + file.getAbsolutePath(), TDECoreUtilities.getLastRefreshedTimeOfTOCFile(file2));
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            long l2 = System.currentTimeMillis();
            UtilLogger.getLogger().info((Object)("Total time to create filebased TOC is " + (l2 - l) + " ms."));
        }
        return true;
    }

    private static boolean createTOC(List<String> list, File file) throws IOException {
        long l = System.currentTimeMillis();
        try (PrintWriter printWriter = null;){
            File file2 = new File(file + File.separator + META_TOC_FILENAME);
            if (!file2.exists()) {
                TDECoreUtilities.createTOCFile(file);
            }
            printWriter = new PrintWriter(file2);
            for (String string : list) {
                printWriter.println(string);
            }
        }
        long l2 = System.currentTimeMillis();
        UtilLogger.getLogger().info((Object)("Total time to create filebased TOC is " + (l2 - l) + " ms."));
        return true;
    }

    public static List<String> readTOC(File file) {
        System.currentTimeMillis();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Object object;
            Object object2;
            File file2 = new File(file + File.separator + META_TOC_FILENAME);
            if (!file2.exists()) {
                object2 = TDECoreUtilities.getCIFSPathFromFilePath(file.getAbsolutePath());
                if (object2 != null) {
                    object = new File((String)object2);
                    if (!TDECoreUtilities.createTOC((File)object, file)) {
                        return arrayList;
                    }
                } else {
                    return arrayList;
                }
            }
            object2 = new FileReader(file2);
            object = new BufferedReader((Reader)object2);
            String string = null;
            while ((string = ((BufferedReader)object).readLine()) != null) {
                if (string.contains("..") || string.toLowerCase().endsWith(".om") || string.toLowerCase().endsWith(".omn") || string.toLowerCase().endsWith(".zm") || string.toLowerCase().endsWith(".abs") || string.toLowerCase().endsWith(".rel") || string.toLowerCase().endsWith(META_TOC_FILENAME)) continue;
                arrayList.add(string);
            }
            ((BufferedReader)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            UtilLogger.getLogger().error((Object)fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            UtilLogger.getLogger().error((Object)iOException.getMessage(), (Throwable)iOException);
        }
        System.currentTimeMillis();
        return arrayList;
    }

    public static boolean removeFromTOC(List<String> list, File file) throws IOException {
        List<String> list2 = TDECoreUtilities.readTOC(file);
        list2.removeAll(list);
        if (list2.isEmpty()) {
            TDECoreUtilities.createTOCFile(file);
        }
        return TDECoreUtilities.createTOC(list2, file);
    }

    public static String getLastRefreshedTimeOfTOCFile(File file) {
        File file2 = new File(file + File.separator + META_TOC_FILENAME);
        if (file2.exists()) {
            return new SimpleDateFormat(DATE_FORMAT).format(new Date(file2.lastModified()));
        }
        return "";
    }

    public static boolean createTOCFile(File file) throws IOException {
        File file2 = null;
        file2 = new File(file + File.separator + META_TOC_FILENAME);
        if (file2.exists()) {
            file2.delete();
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file2.createNewFile();
    }

    public static boolean removeFromTOC(String string, File file) throws IOException {
        List<String> list = TDECoreUtilities.readTOC(file);
        list.remove(string);
        if (list.isEmpty()) {
            TDECoreUtilities.createTOCFile(file);
        }
        return TDECoreUtilities.createTOC(list, file);
    }

    public void createUnInitializedFile(Path path, Path path2) {
        File file = new File(String.valueOf(File.separator) + File.separator + path.toOSString());
        File file2 = path2.toFile();
        this.createUnInitializedFile(file, file2);
    }

    public void createUnInitializedFile(File file, File file2) {
        try {
            FileInfo fileInfo;
            File file3 = file2.getParentFile();
            if (!file3.exists()) {
                file3.mkdirs();
            }
            if (file2.exists() && (fileInfo = this.getFileInfo(file2.getAbsolutePath())) != null) {
                return;
            }
            if (file2.createNewFile()) {
                file2.setLastModified(0L);
            }
            long l = file2.lastModified();
            FileInfo fileInfo2 = new FileInfo(file2.getPath(), file.getPath(), l, l);
            this.addFileInfoToMap(fileInfo2);
        }
        catch (IOException iOException) {
            UtilLogger.getLogger().error((Object)iOException.getMessage(), (Throwable)iOException);
        }
    }

    public static void synchronize(File file, File file2, boolean bl) throws IOException {
        TDECoreUtilities.createTOC(file, file2);
    }

    public static boolean delete(File file) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                if (TDECoreUtilities.delete(file2)) {
                    arrayList.add(file2.getName());
                }
                ++n2;
            }
        }
        if (file.exists()) {
            if (!file.delete()) {
                UtilLogger.getLogger().info((Object)("Could not delete {}" + file));
            } else {
                arrayList.add(file.getName());
            }
        }
        TDECoreUtilities.removeFromTOC(arrayList, file.getParentFile());
        return true;
    }

    public String initiateCopying(File file, File file2, int n) {
        if (n == 1) {
            return this.copyToHost(file2, file, "");
        }
        if (n == 2) {
            String string = String.valueOf(Messages.getString((String)"TDECoreUtilities_13")) + file2.getName();
            return this.copyToLocal(file, file2, string);
        }
        return "error";
    }

    public static boolean isPhysicallyInSync(File file) {
        String string = TDECoreUtilities.getCIFSPathFromFilePath(file.getPath());
        TDECoreUtilities tDECoreUtilities = TDECoreUtilities.getInstance();
        FileInfo fileInfo = tDECoreUtilities.getFileInfo(file.getPath());
        if (fileInfo == null) {
            UtilLogger.getLogger().info((Object)("Unable to read the stored information about " + file.getPath() + "."));
            return false;
        }
        if (string != null) {
            File file2 = new File(string);
            long l = file.lastModified();
            long l2 = file2.lastModified();
            fileInfo.setLocalFileLastModTimestamp(l);
            fileInfo.setRemoteFileLastModTimestamp(l2);
            if (file.exists() && file2.exists() && l == l2) {
                fileInfo.setFileModified(false);
                tDECoreUtilities.addFileInfo(fileInfo);
                return true;
            }
        }
        fileInfo.setFileModified(true);
        tDECoreUtilities.addFileInfo(fileInfo);
        return false;
    }

    public static boolean isPhysicallyInSync(IFile iFile) {
        return TDECoreUtilities.isPhysicallyInSync(new File(iFile.getRawLocation().toOSString()));
    }

    public boolean isFileModified(IFile iFile) {
        File file = new File(iFile.getRawLocation().toOSString());
        if (iFile != null) {
            block4: {
                try {
                    if (Boolean.parseBoolean(iFile.getPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE))) break block4;
                    return true;
                }
                catch (CoreException coreException) {}
            }
            FileInfo fileInfo = this.fileInfoMap.get(file.getPath());
            return fileInfo.isFileModified();
        }
        return false;
    }

    public static boolean isUnInitializedFile(IFile iFile) {
        IPath iPath = iFile.getRawLocation();
        if (iPath == null) {
            return true;
        }
        File file = new File(iPath.toOSString());
        return file != null && (!file.exists() || file.lastModified() == 0L);
    }

    public static boolean isUnInitializedFile(String string) {
        if (string == null) {
            return true;
        }
        File file = new File(string);
        return file != null && (!file.exists() || file.lastModified() == 0L);
    }

    public static final String getOS2200FormatfromCachePath(IPath iPath) {
        return TDECoreUtilities.getOS2200FormatfromCachePath(iPath.toOSString());
    }

    public static final String getOS2200FormatfromCachePath(String string) {
        UtilLogger.getLogger().debug((Object)"");
        String string2 = "";
        String string3 = TDECoreUtilities.getCIFSPathFromFilePath(string);
        UtilLogger.getLogger().debug((Object)(String.valueOf(string) + " equivalent CIFSPath is " + string3));
        if (string3 == null) {
            UtilLogger.getLogger().debug((Object)" CIFSPath is null returning empty string");
            return string2;
        }
        Path path = new Path(string3);
        string3 = null;
        int n = path.segmentCount();
        if (n == 3) {
            UtilLogger.getLogger().debug((Object)" Segment count 3 ");
            String string4 = path.segment(2);
            if (string4.contains(".")) {
                string4 = string4.replace(".", "/");
            }
            string2 = String.valueOf(path.segment(1)) + "." + string4 + " ON " + path.segment(0);
        } else if (n == 5) {
            UtilLogger.getLogger().debug((Object)" Segment count 5 ");
            String string5 = path.segment(4);
            if (string5.contains(".")) {
                string5 = string5.replace(".", "/");
            }
            string2 = String.valueOf(path.segment(2)) + "*" + path.segment(3) + "." + string5 + " ON " + path.segment(0);
            string5 = null;
        }
        path = null;
        UtilLogger.getLogger().debug((Object)("Returning " + string2.toLowerCase()));
        return string2.toUpperCase();
    }

    public boolean doValidate(final String string, final String string2) throws Exception {
        UtilLogger.getLogger().debug((Object)"");
        File file = new File(String.valueOf(CACHE_PATH) + string2);
        File file2 = new File(string2);
        if (!file2.exists()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    UtilLogger.getLogger().info((Object)(String.valueOf(string2) + " does not exist on host."));
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"TDECoreUtilities_14"), (String)(String.valueOf(string2) + Messages.getString((String)"TDECoreUtilities_15")));
                }
            });
            return false;
        }
        if (!TDECoreUtilities.isPhysicallyInSync(file)) {
            if (!file.exists() || file.lastModified() == 0L) {
                UtilLogger.getLogger().debug((Object)(String.valueOf(string2) + " will be copied to local"));
                this.copyToLocal(file2, file);
            } else {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        UtilLogger.getLogger().info((Object)(String.valueOf(string) + " is not in sync. Please sync the file manually."));
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"TDECoreUtilities_16"), (String)(String.valueOf(string) + Messages.getString((String)"TDECoreUtilities_17")));
                    }
                });
                return false;
            }
        }
        return true;
    }

    public static void removeDoubleClickListenerOnProblemsView() {
        try {
            ProblemsView problemsView = TDECoreUtilities.getProblemViewObject();
            MarkersTreeViewer markersTreeViewer = (MarkersTreeViewer)problemsView.getViewSite().getSelectionProvider();
            markersTreeViewer.removeDoubleClickListener(dcl);
        }
        catch (Exception exception) {}
    }

    public static void addDoubleClickListenerOnProblemsView() {
        UtilLogger.getLogger().debug((Object)"");
        try {
            ProblemsView problemsView = TDECoreUtilities.getProblemViewObject();
            MarkersTreeViewer markersTreeViewer = (MarkersTreeViewer)problemsView.getViewSite().getSelectionProvider();
            dcl = new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent doubleClickEvent) {
                    IResource iResource;
                    MarkerItem markerItem;
                    IMarker iMarker;
                    TreeSelection treeSelection;
                    Object object;
                    UtilLogger.getLogger().debug((Object)"");
                    ISelection iSelection = doubleClickEvent.getSelection();
                    if (iSelection instanceof TreeSelection && (object = (treeSelection = (TreeSelection)iSelection).getFirstElement()) instanceof MarkerItem && (iMarker = (markerItem = (MarkerItem)treeSelection.getFirstElement()).getMarker()) != null && (iResource = iMarker.getResource()) instanceof IFile) {
                        IFile iFile = (IFile)iResource;
                        String string = iFile.getRawLocation().toOSString();
                        UtilLogger.getLogger().debug((Object)(String.valueOf(string) + " is double clicked in Problems View"));
                        FileInfo fileInfo = TDECoreUtilities.getInstance().getFileInfo(string);
                        File file = new File(string);
                        if (fileInfo != null && file.lastModified() != fileInfo.getRemoteFileLastModTimestamp()) {
                            UtilLogger.getLogger().info((Object)(String.valueOf(string) + " is out of sync with the host."));
                            boolean bl = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"TDECoreUtilities_18"), (String)(String.valueOf(fileInfo.getRemoteFile()) + Messages.getString((String)"TDECoreUtilities_19")));
                            if (!bl) {
                                UtilLogger.getLogger().info((Object)"User cancelled the Out-of-Sync confirmation dialog");
                                return;
                            }
                        }
                        try {
                            File file2 = new File(string);
                            if (!file2.exists()) {
                                string = TDECoreUtilities.getCIFSPathFromFilePath(string);
                                UtilLogger.getLogger().debug((Object)(String.valueOf(iFile.getName()) + " will be validated"));
                                TDECoreUtilities.getInstance().doValidate(iFile.getName(), string);
                            }
                            iFile.getProject().refreshLocal(0, null);
                        }
                        catch (Exception exception) {
                            UtilLogger.getLogger().error((Object)exception.getLocalizedMessage(), (Throwable)exception);
                        }
                        string = null;
                        iFile = null;
                    }
                }
            };
            markersTreeViewer.addDoubleClickListener(dcl);
        }
        catch (Exception exception) {}
    }

    private static ProblemsView getProblemViewObject() {
        UtilLogger.getLogger().debug((Object)"");
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        final IWorkbenchPage iWorkbenchPage = iWorkbenchWindowArray[0].getActivePage();
        final IViewReference iViewReference = iWorkbenchPage.findViewReference("org.eclipse.ui.views.ProblemView");
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (iViewReference != null) {
                    hView = (ProblemsView)iViewReference.getView(true);
                } else {
                    UtilLogger.getLogger().debug((Object)" IViewReference is null ");
                }
                if (hView == null) {
                    try {
                        hView = (ProblemsView)iWorkbenchPage.showView("org.eclipse.ui.views.ProblemView");
                    }
                    catch (PartInitException partInitException) {
                        UtilLogger.getLogger().error((Object)partInitException.getLocalizedMessage(), (Throwable)partInitException);
                    }
                }
            }
        });
        return hView;
    }

    public static void addtoTOC(IProject iProject, String string) {
        UtilLogger.getLogger().debug((Object)"");
        try {
            IResource[] iResourceArray;
            String string2 = null;
            IResource[] iResourceArray2 = iResourceArray = iProject.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray2[n2];
                string2 = iResource.getName();
                if (iResource instanceof IFile && !string2.toLowerCase().endsWith(".project") && !string2.toLowerCase().endsWith(".settings")) {
                    UtilLogger.getLogger().debug((Object)(" Appending " + string2 + "  to TOC."));
                    TDECoreUtilities.appendTOC(string2, new File(string));
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            UtilLogger.getLogger().error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public static String get2200FormatFromPath(String string) {
        String string2 = null;
        try {
            string2 = string.startsWith("\\\\") ? TDECoreUtilities.getOS2200Path(string) : TDECoreUtilities.getOS2200FormatfromCachePath((IPath)new Path(string));
        }
        catch (Exception exception) {
            return null;
        }
        String string3 = string2.substring(0, string2.indexOf("."));
        String string4 = string2.substring(string2.indexOf("ON"), string2.length());
        string2 = String.valueOf(string3) + " " + string4;
        return string2;
    }

    public static String getOS2200Path(String string) {
        String string2 = "";
        try {
            Path path = new Path(string);
            int n = path.segmentCount();
            string2 = n == 5 ? (path.segment(4).contains(".") ? String.valueOf(path.segment(2)) + "*" + path.segment(3) + "." + path.segment(4).replace(".", "/") + " on " + path.segment(0) : String.valueOf(path.segment(2)) + "*" + path.segment(3) + "." + path.segment(4) + " on " + path.segment(0)) : (n == 3 ? (path.segment(2).contains(".") ? String.valueOf(path.segment(1)) + "." + path.segment(2).replace(".", "/") + " on " + path.segment(0) : String.valueOf(path.segment(1)) + "." + path.segment(2) + " on " + path.segment(0)) : string);
        }
        catch (Exception exception) {}
        return string2.toUpperCase();
    }

    public void loadCharSetLib() {
        try {
            URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> clazz = URLClassLoader.class;
            Class[] classArray = new Class[]{URL.class};
            String string = this.getPluginDirectoryPathforCharConv("com.unisys.tde.core.characterset");
            if (string != null) {
                URL uRL = new URL("file:" + File.separator + string + "unisys-charsets.jar");
                Method method = clazz.getDeclaredMethod("addURL", classArray);
                method.setAccessible(true);
                method.invoke((Object)uRLClassLoader, uRL);
                if (UtilLogger.getLogger().isInfoEnabled()) {
                    UtilLogger.getLogger().info((Object)"Unisys CharacterSet loaded.");
                }
            } else if (UtilLogger.getLogger().isEnabledFor(Priority.WARN)) {
                UtilLogger.getLogger().warn((Object)"Failed to Unisys CharacterSet. libPath returned NULL.");
            }
        }
        catch (MalformedURLException malformedURLException) {
            UtilLogger.getLogger().error((Object)malformedURLException.getMessage(), (Throwable)malformedURLException);
        }
        catch (Exception exception) {
            UtilLogger.getLogger().error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public static boolean isIFileADirectory(IFile iFile) {
        try {
            File file;
            String string;
            IPath iPath = iFile.getRawLocation();
            if (iPath != null && (string = TDECoreUtilities.getCIFSPathFromFilePath(iPath.toOSString())) != null && (file = new File(string)).exists() && file.isDirectory()) {
                iFile.delete(true, null);
                MessageDialog.openInformation((Shell)new Shell(), (String)Messages.getString((String)"information"), (String)Messages.getString((String)"TDECoreUtilities.1", (String)iFile.getName()));
                UtilLogger.getLogger().info((Object)("'" + iFile.getName() + "' is a Directory. It will not be added to the project tree."));
                return true;
            }
        }
        catch (CoreException coreException) {
            UtilLogger.getLogger().error((Object)coreException.getMessage(), (Throwable)coreException);
        }
        return false;
    }

    public String getPluginDirectoryPathforCharConv(String string) {
        UtilLogger.getLogger().info((Object)"");
        Path path = null;
        try {
            Bundle bundle = Platform.getBundle((String)string);
            URL uRL = Platform.resolve((URL)bundle.getEntry("/"));
            path = new Path(uRL.getFile());
        }
        catch (IOException iOException) {
            UtilLogger.getLogger().error((Object)iOException.getMessage(), (Throwable)iOException);
            return null;
        }
        return path.toOSString();
    }

    public Font getCourierFont() {
        return new Font(null, "Courier New", 10, 0);
    }

    /*
     * Unable to fully structure code
     */
    public Properties readPreferenceForProject(IProject var1_1) {
        UtilLogger.getLogger().debug((Object)"");
        var2_2 = null;
        var3_3 = null;
        try {
            if (var1_1 == null) ** GOTO lbl34
            var4_4 = var1_1.getLocation().toOSString();
            var5_6 = String.valueOf(var4_4) + File.separator + ".settings";
            var6_7 = String.valueOf(var5_6) + File.separator + "org.eclipse.core.resources.prefs";
            UtilLogger.getLogger().debug((Object)("Reading the preference file from, " + var6_7));
            var7_8 = new File(var6_7);
            if (var7_8.exists()) {
                var2_2 = new Properties();
                var3_3 = new FileInputStream(var7_8);
                var2_2.load(var3_3);
                var8_9 = var2_2.keys();
                var9_10 = null;
                var10_11 = null;
                while (var8_9.hasMoreElements()) {
                    var9_10 = (String)var8_9.nextElement();
                    var10_11 = var2_2.getProperty(var9_10);
                    if (!var9_10.contains("/<project>")) continue;
                    var2_2.remove(var9_10);
                    var9_10 = var9_10.replace("/<project>", "");
                    var2_2.put(var9_10, var10_11);
                }
                var9_10 = null;
                var10_11 = null;
                var8_9 = null;
            } else {
                UtilLogger.getLogger().debug((Object)"The project preference file was not found.");
                return null;
lbl34:
                // 1 sources

                try {
                    UtilLogger.getLogger().debug((Object)"The project returned null.");
                }
                catch (Exception var4_5) {
                    UtilLogger.getLogger().error((Object)var4_5.getMessage(), (Throwable)var4_5);
                }
            }
        }
        finally {
            try {
                if (var3_3 != null) {
                    var3_3.close();
                }
            }
            catch (Exception var12_15) {
                UtilLogger.getLogger().error((Object)var12_15.getMessage(), (Throwable)var12_15);
            }
        }
        return var2_2;
    }
}

