/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.util;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.UtilLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class MemChecker {
    private static final String SCITE_EXE = "SciTE.exe ";
    public static final String FREE_MEM_FACTOR = "FREE_MEM_FACTOR";
    public static final String FILE_SIZE_FACTOR = "FILE_SIZE_FACTOR";
    public static final String EXT_EDITOR_LOC = "EXT_EDITOR_LOC";
    public static final String CRLF = "\r\n";
    public static final float MB = 1048576.0f;
    public static final int DEFAULT_MIN_FILE_SIZE_FACTOR = 6;
    public static final int DEFAULT_MAX_FILE_SIZE_FACTOR = 20;
    public static final int DEAULT_MIN_MEM_FACTOR = 10;
    public static final int DEAULT_MED_MEM_FACTOR = 20;
    public static final int DEAULT_MAX_MEM_FACTOR = 30;
    private final int TWENTY = 20;
    private final float BUFFER_SPACE = 0.0f;
    private final float CENT = 100.0f;
    private static MemChecker instance = null;
    private float freeMemory;
    private float maxMemory;
    private float totalMemory;
    private final String DOUBLE_QUOTE = "\"";
    private static Set<String> scitePIDs;

    public static MemChecker getInstance() {
        if (instance == null) {
            instance = new MemChecker();
            scitePIDs = new HashSet<String>();
        }
        return instance;
    }

    private MemChecker() {
        IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
        iPreferenceStore.setDefault(FREE_MEM_FACTOR, 20);
        iPreferenceStore.setDefault(FILE_SIZE_FACTOR, 6);
    }

    public boolean hasEnoughMemory(boolean bl, boolean bl2) {
        if (bl) {
            System.gc();
        }
        this.computeMemory();
        DecimalFormat decimalFormat = new DecimalFormat("######.####");
        String string = decimalFormat.format(this.freeMemory / 1048576.0f);
        String string2 = decimalFormat.format(this.maxMemory / 1048576.0f);
        IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
        int n = iPreferenceStore.getInt(FREE_MEM_FACTOR);
        if ((this.freeMemory - 0.0f) / this.maxMemory > (float)n / 100.0f) {
            return true;
        }
        if (bl2) {
            if (UtilLogger.getLogger().isInfoEnabled()) {
                UtilLogger.getLogger().info((Object)("In MemChecker.hasEnoughMemory() Free Memory " + string + "; Max memory " + string2));
                UtilLogger.getLogger().info((Object)("In MemChecker.hasEnoughMemory() (freeMemory-bufferSpace)/maxMemory)" + (this.freeMemory - 0.0f) / this.maxMemory));
            }
            UtilLogger.getLogger().warn((Object)"In MemChecker.hasEnoughMemory(), there is not enough memory...");
        }
        return false;
    }

    public boolean isLargeFile(File file, boolean bl) {
        IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
        int n = iPreferenceStore.getInt(FILE_SIZE_FACTOR);
        long l = file.length();
        if (this.isLargeFile(l) || !this.hasEnoughMemory(false, true)) {
            DecimalFormat decimalFormat = new DecimalFormat("######.####");
            String string = decimalFormat.format(this.freeMemory / 1048576.0f);
            String string2 = decimalFormat.format(this.maxMemory / 1048576.0f);
            String string3 = decimalFormat.format((float)l / 1048576.0f);
            String string4 = new String();
            String string5 = Messages.getString((String)"MemChecker.notEnoughMemory");
            string4 = MessageFormat.format(string5, file.getAbsolutePath());
            string4 = String.valueOf(string4) + CRLF;
            if (this.freeMemory / (float)l < (float)n) {
                string5 = String.valueOf(Messages.getString((String)"MemChecker.lessFileSizeFactor")) + CRLF + CRLF + Messages.getString((String)"MemChecker.openInExternalEditor");
                string = decimalFormat.format(this.freeMemory / 1048576.0f);
                float f = (long)n * l;
                String string6 = decimalFormat.format(f / 1048576.0f);
                string4 = String.valueOf(string4) + MessageFormat.format(string5, string, n, string3, string6, file.getName());
            } else {
                string = decimalFormat.format(this.freeMemory / 1048576.0f);
                string2 = decimalFormat.format(this.maxMemory / 1048576.0f);
                string5 = String.valueOf(Messages.getString((String)"MemChecker.lessMemSizeFactor")) + CRLF + CRLF + Messages.getString((String)"MemChecker.openInExternalEditor");
                int n2 = iPreferenceStore.getInt(FREE_MEM_FACTOR);
                string4 = MessageFormat.format(string5, string, string2, n2, file.getName());
            }
            if (bl) {
                this.openInExternalEditor(file, string4);
            }
            UtilLogger.getLogger().warn((Object)string4);
            return true;
        }
        return false;
    }

    public boolean hasAtleast20MBFreeMemory() {
        System.gc();
        this.computeMemory();
        long l = (long)(this.freeMemory / 1048576.0f);
        return l >= 20L;
    }

    public void closeAllWindows() {
        block10: {
            Vector<String> vector = this.getAllScitePIDs();
            if (vector.size() == 0) {
                return;
            }
            if (scitePIDs.size() > 0) {
                try {
                    if (UtilLogger.getLogger().isInfoEnabled()) {
                        UtilLogger.getLogger().info((Object)"ClosingTheExternalEditor");
                    }
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"MemChecker.editorScalability"), (String)Messages.getString((String)"MemChecker.closingTheExternalEditor"));
                    if (vector.size() == 1 && scitePIDs.containsAll(vector)) {
                        String string = vector.elementAt(0);
                        if (UtilLogger.getLogger().isInfoEnabled()) {
                            UtilLogger.getLogger().info((Object)("Stopping Scite using taskkill /PID " + string));
                        }
                        Runtime.getRuntime().exec("taskkill /PID " + string);
                    } else {
                        for (String string : scitePIDs) {
                            if (UtilLogger.getLogger().isInfoEnabled()) {
                                UtilLogger.getLogger().info((Object)("Stopping Scite using taskkill /PID " + string));
                            }
                            Runtime.getRuntime().exec("taskkill /PID " + string);
                        }
                    }
                }
                catch (IOException iOException) {
                    if (!UtilLogger.getLogger().isInfoEnabled()) break block10;
                    UtilLogger.getLogger().info((Object)iOException.getMessage(), (Throwable)iOException);
                }
            }
        }
    }

    public boolean isLargeFile(long l) {
        IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
        int n = iPreferenceStore.getInt(FILE_SIZE_FACTOR);
        System.gc();
        this.computeMemory();
        return this.freeMemory / (float)l < (float)n;
    }

    private void openInExternalEditor(File file, String string) {
        boolean bl = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"MemChecker.editorScalability"), (String)string);
        if (bl) {
            this.openInExternalEditor(file);
        }
    }

    public void openInExternalEditor(final File file) {
        final String string = this.getExternalEditorLoc();
        if (new File(string).exists()) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Vector vector = MemChecker.this.getAllScitePIDs();
                        String string3 = new String("\"" + string + "\"" + "\"" + file + "\"");
                        if (UtilLogger.getLogger().isInfoEnabled()) {
                            UtilLogger.getLogger().info((Object)("Running " + string3));
                        }
                        Runtime.getRuntime().exec(string3);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        Vector vector2 = new Vector();
                        vector2 = MemChecker.this.getAllScitePIDs();
                        vector2.removeAll(vector);
                        if (vector2.size() == 0) {
                            if (vector.size() > 0) {
                                if (UtilLogger.getLogger().isDebugEnabled()) {
                                    UtilLogger.getLogger().debug((Object)"Reusing the existing scite instance");
                                }
                                scitePIDs.addAll(vector);
                            }
                        } else if (vector2.size() == 1) {
                            String string2 = (String)vector2.get(0);
                            if (UtilLogger.getLogger().isDebugEnabled()) {
                                UtilLogger.getLogger().debug((Object)("Created a new scite instance... and its pid is " + string2));
                            }
                            scitePIDs.add(string2);
                        }
                    }
                    catch (IOException iOException) {
                        UtilLogger.getLogger().error((Object)iOException);
                    }
                }
            });
            thread.start();
            UtilLogger.getLogger().info((Object)("Opening " + file.getAbsolutePath() + "using an external editor."));
        } else {
            String string2 = Messages.getString((String)"MemChecker.noExternalEditor");
            String string3 = MessageFormat.format(string2, string);
            UtilLogger.getLogger().error((Object)("Unable to locate an external editor " + string));
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"MemChecker.editorScalability"), (String)string3);
        }
    }

    private void computeMemory() {
        Runtime runtime = Runtime.getRuntime();
        this.freeMemory = runtime.freeMemory();
        this.maxMemory = runtime.maxMemory();
        this.totalMemory = runtime.totalMemory();
        if (this.totalMemory != this.maxMemory) {
            this.freeMemory += this.maxMemory - this.totalMemory;
        }
    }

    private String getExternalEditorLoc() {
        String string;
        String string2 = System.getProperty("eclipse.home.location");
        if (string2.startsWith(string = "file:/")) {
            string2 = string2.substring(string.length());
        }
        return String.valueOf(string2) + "wscite/" + SCITE_EXE;
    }

    private Vector<String> getAllScitePIDs() {
        Vector<String> vector = new Vector<String>();
        try {
            String string;
            Process process = Runtime.getRuntime().exec("tasklist /FI \"IMAGENAME eq SciTE.exe \" /FO CSV");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            bufferedReader.readLine();
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                String string2 = null;
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (n == 1) break;
                    ++n;
                }
                if (UtilLogger.getLogger().isDebugEnabled()) {
                    UtilLogger.getLogger().debug((Object)("Adding pid " + string2 + " in getAllScitePIDs()"));
                }
                vector.add(string2);
            }
        }
        catch (IOException iOException) {
            UtilLogger.getLogger().warn((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
        }
        return vector;
    }
}

