/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.internal.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cobol.core.debug.model.ICOBOLVariable;
import org.eclipse.cobol.core.debug.model.ICOBOLVariableListener;
import org.eclipse.cobol.core.debug.model.ICOBOLVariableManager;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.internal.core.COBOLDebugUtil;
import org.eclipse.cobol.debug.internal.core.model.CBDIVariable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IVariable;

public class COBOLVariableManager
implements ICOBOLVariableManager {
    private ListenerList fVariableListeners = new ListenerList();
    private List fVariableList = new ArrayList();
    private boolean anyVariableIsAdded;

    public void addVariable(String string, String string2, int n, boolean bl) {
        this.fireVariableAdded(string, string2, n, bl);
    }

    public void addVariable(String string, String string2, boolean bl) {
        this.fireVariableAdded(string, string2, bl);
    }

    public void addVariable(String string, String string2, boolean bl, boolean bl2) {
        this.fireVariableAdded(string, string2, bl, bl2);
    }

    public void removeVariable(ICOBOLVariable iCOBOLVariable) {
        if (iCOBOLVariable != null) {
            this.fireVariableRemoved(iCOBOLVariable);
        }
    }

    public void removeAllVariables() {
        this.fireAllVariablesRemoved();
    }

    public void SetDataInterruption(ICOBOLVariable iCOBOLVariable) {
        this.fireDataInterruption(iCOBOLVariable);
    }

    public void addVariableListener(ICOBOLVariableListener iCOBOLVariableListener) {
        this.fVariableListeners.add((Object)iCOBOLVariableListener);
    }

    public void removeVariableListener(ICOBOLVariableListener iCOBOLVariableListener) {
        this.fVariableListeners.remove((Object)iCOBOLVariableListener);
    }

    public void startup() {
    }

    public void shutdown() {
        if (this.fVariableList != null) {
            this.fVariableList.clear();
            this.fVariableList = null;
        }
        if (this.fVariableListeners != null) {
            this.fVariableListeners.clear();
        }
    }

    protected void fireVariableAdded(String string, String string2, int n, boolean bl) {
        Object[] objectArray = this.fVariableListeners.getListeners();
        int n2 = 0;
        while (n2 < objectArray.length) {
            try {
                ((ICOBOLVariableListener)objectArray[n2]).variableAdded(string, string2, n, bl);
            }
            catch (NullPointerException nullPointerException) {
                COBOLDebugPlugin.logError(nullPointerException);
            }
            catch (Exception exception) {
                COBOLDebugPlugin.logError(exception);
            }
            ++n2;
        }
    }

    protected void fireVariableAdded(String string, String string2, boolean bl) {
        Object[] objectArray = this.fVariableListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            try {
                ((ICOBOLVariableListener)objectArray[n]).variableAdded(string, string2, bl);
            }
            catch (NullPointerException nullPointerException) {
                COBOLDebugPlugin.logError(nullPointerException);
            }
            catch (Exception exception) {
                COBOLDebugPlugin.logError(exception);
            }
            ++n;
        }
    }

    protected void fireVariableAdded(String string, String string2, boolean bl, boolean bl2) {
        Object[] objectArray = this.fVariableListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            try {
                ((ICOBOLVariableListener)objectArray[n]).variableAdded(string, string2, bl, bl2);
            }
            catch (NullPointerException nullPointerException) {
                COBOLDebugPlugin.logError(nullPointerException);
            }
            catch (Exception exception) {
                COBOLDebugPlugin.logError(exception);
            }
            ++n;
        }
    }

    protected void fireVariableRemoved(ICOBOLVariable iCOBOLVariable) {
        Object[] objectArray = this.fVariableListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            try {
                ((ICOBOLVariableListener)objectArray[n]).variableRemoved(iCOBOLVariable);
            }
            catch (NullPointerException nullPointerException) {
                COBOLDebugPlugin.logError(nullPointerException);
            }
            catch (Exception exception) {
                COBOLDebugPlugin.logError(exception);
            }
            ++n;
        }
    }

    protected void fireAllVariablesRemoved() {
        Object[] objectArray = this.fVariableListeners.getListeners();
        this.allVariablesRemoved();
        int n = 0;
        while (n < objectArray.length) {
            try {
                ((ICOBOLVariableListener)objectArray[n]).allVariablesRemoved();
            }
            catch (NullPointerException nullPointerException) {
                COBOLDebugPlugin.logError(nullPointerException);
            }
            catch (Exception exception) {
                COBOLDebugPlugin.logError(exception);
            }
            ++n;
        }
    }

    public IVariable[] getVariables() {
        return this.fVariableList.toArray(new IVariable[this.fVariableList.size()]);
    }

    public void setVariables(IVariable[] iVariableArray) {
        this.fVariableList = Collections.EMPTY_LIST;
        this.fVariableList = new ArrayList();
        if (iVariableArray != null) {
            int n = 0;
            while (n < iVariableArray.length) {
                this.fVariableList.add(iVariableArray[n]);
                ++n;
            }
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 16, 512)});
        }
    }

    public void variableAdded(IVariable iVariable) {
        if (this.fVariableList.equals(Collections.EMPTY_LIST)) {
            this.fVariableList = new ArrayList();
        }
        this.fVariableList.add(iVariable);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 16, 512)});
        this.anyVariableIsAdded = true;
    }

    public void variableRemoved(IVariable iVariable) {
        this.fVariableList.remove(iVariable);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 16, 512)});
    }

    public void allVariablesRemoved() {
        if (this.fVariableList.size() > 0) {
            this.fVariableList = Collections.EMPTY_LIST;
            this.fVariableList.clear();
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 16, 512)});
        }
    }

    public void clear() {
        this.fVariableList.clear();
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 16, 512)});
    }

    protected void fireDataInterruption(ICOBOLVariable iCOBOLVariable) {
        Object[] objectArray = this.fVariableListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            try {
                ((ICOBOLVariableListener)objectArray[n]).VariableInterruptionHasSet(iCOBOLVariable);
            }
            catch (NullPointerException nullPointerException) {
                COBOLDebugPlugin.logError(nullPointerException);
            }
            catch (Exception exception) {
                COBOLDebugPlugin.logError(exception);
            }
            ++n;
        }
    }

    public void saveVariables(ILaunch iLaunch) {
        if (!this.anyVariableIsAdded) {
            return;
        }
        List list = COBOLDebugUtil.getPersistedVariablesList(iLaunch);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.fVariableList.size()) {
            IVariable iVariable = (IVariable)this.fVariableList.get(n);
            try {
                String string = String.valueOf(((CBDIVariable)iVariable).getFullyQualifiedName()) + "," + ((CBDIVariable)iVariable).getProgramName() + "," + ((CBDIVariable)iVariable).isInterrupteable();
                arrayList.add(string);
            }
            catch (DebugException debugException) {}
            ++n;
        }
        if (!arrayList.equals(list)) {
            COBOLDebugUtil.setPersistedVariablesList(iLaunch, arrayList);
        }
        if (arrayList != null) {
            arrayList.clear();
        }
        this.anyVariableIsAdded = false;
        arrayList = null;
    }
}

