/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.internal.core.model;

import java.io.IOException;
import org.eclipse.cobol.debug.internal.core.model.COBOLInputStreamMonitor;
import org.eclipse.cobol.debug.internal.core.model.COBOLOutputStreamMonitor;
import org.eclipse.cobol.debug.internal.core.model.COBOLRuntimeProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;

public class COBOLStreamsProxy
implements IStreamsProxy {
    private COBOLOutputStreamMonitor fOutputMonitor;
    private COBOLOutputStreamMonitor fErrorMonitor;
    private COBOLInputStreamMonitor fInputMonitor;
    private boolean fClosed = false;

    public COBOLStreamsProxy() {
    }

    public COBOLStreamsProxy(COBOLRuntimeProcess cOBOLRuntimeProcess) {
        if (cOBOLRuntimeProcess == null) {
            return;
        }
        this.fOutputMonitor = new COBOLOutputStreamMonitor(cOBOLRuntimeProcess.getInputStream());
        this.fErrorMonitor = new COBOLOutputStreamMonitor(cOBOLRuntimeProcess.getErrorStream());
        this.fInputMonitor = new COBOLInputStreamMonitor(cOBOLRuntimeProcess.getOutputStream());
        this.fOutputMonitor.startMonitoring();
        this.fErrorMonitor.startMonitoring();
        this.fInputMonitor.startMonitoring();
    }

    protected void close() throws IOException {
        if (this.fOutputMonitor != null) {
            this.fOutputMonitor.close();
        }
        if (this.fErrorMonitor != null) {
            this.fErrorMonitor.close();
        }
        if (this.fInputMonitor != null) {
            this.fInputMonitor.close();
        }
    }

    public IStreamMonitor getErrorStreamMonitor() {
        return this.fErrorMonitor;
    }

    public IStreamMonitor getOutputStreamMonitor() {
        return this.fOutputMonitor;
    }

    public void write(String string) throws IOException {
        if (this.fClosed || this.fInputMonitor == null || string == null) {
            throw new IOException();
        }
        this.fInputMonitor.write(string);
    }
}

