/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.internal.core.model;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.internal.core.model.COBOLStreamsProxy;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jface.dialogs.MessageDialog;

public class COBOLRuntimeProcess
extends PlatformObject
implements IProcess {
    private IDebugTarget fDebugTarget;
    private COBOLStreamsProxy fStreamsProxy;
    private String fName;
    protected boolean fTerminated;
    private HashMap fAttributes;
    private OutputStream inStream;
    private InputStream outStream;
    private InputStream errStream;
    private ILaunch fLaunch;

    private COBOLRuntimeProcess() {
    }

    public COBOLRuntimeProcess(ILaunch iLaunch, String string) {
        this.fName = string;
        this.fLaunch = iLaunch;
        this.fTerminated = false;
        this.fStreamsProxy = new COBOLStreamsProxy();
        iLaunch.addProcess((IProcess)this);
    }

    public COBOLRuntimeProcess(ILaunch iLaunch, OutputStream outputStream, InputStream inputStream, InputStream inputStream2, String string) {
        this.fName = string;
        this.inStream = outputStream;
        this.outStream = inputStream;
        this.errStream = inputStream2;
        this.fLaunch = iLaunch;
        this.fTerminated = false;
        this.fStreamsProxy = new COBOLStreamsProxy(this);
        iLaunch.addProcess((IProcess)this);
    }

    public void cleanWhenLaunchRemoved() {
        this.cleanup();
        this.fDebugTarget = null;
    }

    public void cleanup() {
        if (this.fStreamsProxy != null) {
            try {
                this.fStreamsProxy.close();
            }
            catch (IOException iOException) {}
            this.fStreamsProxy = null;
        }
        if (this.errStream != null) {
            try {
                this.errStream.close();
            }
            catch (IOException iOException) {}
            this.errStream = null;
        }
        if (this.inStream != null) {
            try {
                this.inStream.close();
            }
            catch (IOException iOException) {}
            this.inStream = null;
        }
        if (this.outStream != null) {
            try {
                this.outStream.close();
            }
            catch (IOException iOException) {}
            this.outStream = null;
        }
    }

    public boolean canTerminate() {
        return !this.fTerminated;
    }

    protected InputStream getErrorStream() {
        return this.errStream;
    }

    protected InputStream getInputStream() {
        return this.outStream;
    }

    protected OutputStream getOutputStream() {
        return this.inStream;
    }

    public String getLabel() {
        return this.fName;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        this.terminated();
    }

    protected void terminated() {
        this.fTerminated = true;
        if (this.fDebugTarget != null && !this.fDebugTarget.isTerminated()) {
            try {
                this.fDebugTarget.terminate();
            }
            catch (DebugException debugException) {
                COBOLDebugPlugin.logError((Exception)((Object)debugException));
                MessageDialog.openError(null, (String)Messages.getString((String)"TerminationFailedError.label"), (String)Messages.getString((String)"TerminationFailedError.text"));
            }
        }
        try {
            if (this.fStreamsProxy != null) {
                this.fStreamsProxy.close();
            }
        }
        catch (IOException iOException) {
            COBOLDebugPlugin.logError(iOException);
        }
        this.fireTerminateEvent();
        this.fDebugTarget = null;
    }

    public IStreamsProxy getStreamsProxy() {
        return this.fStreamsProxy;
    }

    private void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    private void fireEvent(DebugEvent debugEvent) {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (debugPlugin != null) {
            debugPlugin.fireDebugEventSet(new DebugEvent[]{debugEvent});
        }
    }

    private void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    public void setAttribute(String string, String string2) {
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap(5);
        }
        this.fAttributes.put(string, string2);
    }

    public String getAttribute(String string) {
        if (this.fAttributes == null) {
            return null;
        }
        return (String)this.fAttributes.get(string);
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(IProcess.class)) {
            return this;
        }
        if (clazz.equals(IDebugTarget.class)) {
            ILaunch iLaunch = this.getLaunch();
            if (iLaunch != null) {
                IDebugTarget[] iDebugTargetArray = iLaunch.getDebugTargets();
                int n = 0;
                while (n < iDebugTargetArray.length) {
                    if (((Object)((Object)this)).equals(iDebugTargetArray[n].getProcess())) {
                        return iDebugTargetArray[n];
                    }
                    ++n;
                }
            }
            return null;
        }
        return super.getAdapter(clazz);
    }

    public void setTarget(IDebugTarget iDebugTarget) {
        this.fDebugTarget = iDebugTarget;
    }

    public IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public int getExitValue() throws DebugException {
        if (this.fTerminated) {
            return 0;
        }
        throw new DebugException((IStatus)new Status(4, COBOLDebugPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, "Process not terminated", null));
    }
}

