/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.internal.core.model;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;

public class COBOLOutputStreamMonitor
implements IStreamMonitor {
    private InputStream fStream;
    private ListenerList fListeners;
    private StringBuffer fContents;
    private Thread fThread;
    private static final int BUFFER_SIZE = 8192;
    private static final long DELAY = 50L;

    public COBOLOutputStreamMonitor(InputStream inputStream) {
        this.fStream = inputStream;
        this.fContents = new StringBuffer();
        this.fListeners = new ListenerList(1);
    }

    public void addListener(IStreamListener iStreamListener) {
        this.fListeners.add((Object)iStreamListener);
    }

    protected void close() throws IOException {
        if (this.fThread != null) {
            Thread thread = this.fThread;
            this.fThread = null;
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("Closing stream failed");
            }
            this.fListeners.clear();
        }
    }

    private void fireStreamAppended(String string) {
        if (string == null) {
            return;
        }
        Object[] objectArray = this.fListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IStreamListener)objectArray[n]).streamAppended(string, (IStreamMonitor)this);
            ++n;
        }
    }

    public String getContents() {
        return this.fContents.toString();
    }

    private void read() {
        byte[] byArray = new byte[8192];
        int n = 0;
        int n2 = 0;
        String string = null;
        while (true) {
            try {
                if (this.fStream != null && (n2 = this.fStream.available()) > 8192) {
                    n2 = 8192;
                }
                if (n2 <= 0) {
                    if (this.fThread == null) {
                        break;
                    }
                } else if (this.fStream != null && (n = this.fStream.read(byArray, 0, n2)) > 0) {
                    string = new String(byArray, 0, n);
                    this.fContents.append(string).append("\r\n");
                    this.fireStreamAppended(string);
                }
            }
            catch (IOException iOException) {
                COBOLDebugPlugin.logError(iOException);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                COBOLDebugPlugin.logError(indexOutOfBoundsException);
                return;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                COBOLDebugPlugin.logError(interruptedException);
            }
        }
    }

    public void removeListener(IStreamListener iStreamListener) {
        this.fListeners.remove((Object)iStreamListener);
    }

    protected void startMonitoring() {
        if (this.fThread == null) {
            this.fThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    COBOLOutputStreamMonitor.this.read();
                }
            }, "COBOLOutputStreamMonitor");
            this.fThread.start();
        }
    }
}

