/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.internal.core.model;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;

public class COBOLInputStreamMonitor {
    private OutputStream fStream;
    private Vector fQueue;
    private Thread fThread;
    private Object fLock;

    public COBOLInputStreamMonitor(OutputStream outputStream) {
        this.fStream = outputStream;
        this.fQueue = new Vector();
        this.fLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string) {
        Object object = this.fLock;
        synchronized (object) {
            this.fQueue.add(string);
            this.fLock.notifyAll();
        }
    }

    public void startMonitoring() {
        if (this.fThread == null) {
            this.fThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    COBOLInputStreamMonitor.this.write();
                }
            }, "COBOLInputStreamMonitor");
            this.fThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.fThread != null) {
            Thread thread = this.fThread;
            this.fThread = null;
            Object object = this.fLock;
            synchronized (object) {
                this.fLock.notifyAll();
            }
            thread.interrupt();
        }
    }

    protected void write() {
        while (this.fThread != null) {
            this.writeNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeNext() {
        Object object;
        while (!this.fQueue.isEmpty()) {
            object = (String)this.fQueue.firstElement();
            this.fQueue.removeElementAt(0);
            try {
                if (this.fStream == null) continue;
                this.fStream.write(((String)object).getBytes());
                this.fStream.flush();
            }
            catch (IOException iOException) {
                COBOLDebugPlugin.logError(iOException);
            }
        }
        try {
            object = this.fLock;
            synchronized (object) {
                this.fLock.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            COBOLDebugPlugin.logError(interruptedException);
        }
    }
}

