/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.internal.core.model;

import org.eclipse.cobol.core.debug.model.ICOBOLBreakpoint;
import org.eclipse.cobol.core.debug.model.ICOBOLBreakpointListener;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.core.BreakpointManager;

public class COBOLBreakpointManager
extends BreakpointManager {
    private ListenerList fBreakpointListeners = new ListenerList(1);

    public void addBreakpoint(IBreakpoint iBreakpoint) throws CoreException {
        IBreakpointManager iBreakpointManager;
        if (iBreakpoint instanceof ICOBOLBreakpoint && this.fireBreakpointAdded((ICOBOLBreakpoint)iBreakpoint) && (iBreakpointManager = this.getBreakpointManager()) != null) {
            iBreakpointManager.addBreakpoint(iBreakpoint);
            iBreakpointManager = null;
        }
    }

    public void fireBreakpointChanged(IBreakpoint iBreakpoint) {
        if (iBreakpoint instanceof ICOBOLBreakpoint) {
            IBreakpointManager iBreakpointManager;
            Object[] objectArray = this.fBreakpointListeners.getListeners();
            boolean bl = false;
            int n = objectArray.length;
            if (n <= 0) {
                bl = true;
            }
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < n) {
                try {
                    bl2 = ((ICOBOLBreakpointListener)objectArray[n2]).breakpointRemoved(iBreakpoint);
                    if (!bl) {
                        bl = bl2;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    COBOLDebugPlugin.logError(nullPointerException);
                }
                catch (Exception exception) {
                    COBOLDebugPlugin.logError(exception);
                }
                ++n2;
            }
            if (bl && (iBreakpointManager = this.getBreakpointManager()) != null) {
                iBreakpointManager.fireBreakpointChanged(iBreakpoint);
                iBreakpointManager = null;
            }
        }
    }

    public void removeBreakpoint(IBreakpoint iBreakpoint, boolean bl) throws CoreException {
        IBreakpointManager iBreakpointManager;
        if (iBreakpoint instanceof ICOBOLBreakpoint && this.fireBreakpointRemoved(iBreakpoint) && (iBreakpointManager = this.getBreakpointManager()) != null) {
            iBreakpointManager.removeBreakpoint(iBreakpoint, bl);
            iBreakpointManager = null;
        }
    }

    public void addBreakpointListener(IBreakpointListener iBreakpointListener) {
        this.fBreakpointListeners.add((Object)iBreakpointListener);
        IBreakpointManager iBreakpointManager = this.getBreakpointManager();
        if (iBreakpointManager != null) {
            iBreakpointManager.addBreakpointListener(iBreakpointListener);
            iBreakpointManager = null;
        }
    }

    public void removeBreakpointListener(IBreakpointListener iBreakpointListener) {
        this.fBreakpointListeners.remove((Object)iBreakpointListener);
        IBreakpointManager iBreakpointManager = this.getBreakpointManager();
        if (iBreakpointManager != null) {
            iBreakpointManager.removeBreakpointListener(iBreakpointListener);
            iBreakpointManager = null;
        }
    }

    protected boolean fireBreakpointAdded(ICOBOLBreakpoint iCOBOLBreakpoint) {
        Object[] objectArray = this.fBreakpointListeners.getListeners();
        int n = objectArray.length;
        if (n <= 0) {
            return true;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < n) {
            try {
                bl2 = ((ICOBOLBreakpointListener)objectArray[n2]).breakpointAdded(iCOBOLBreakpoint);
                if (!bl) {
                    bl = bl2;
                }
            }
            catch (NullPointerException nullPointerException) {
                COBOLDebugPlugin.logError(nullPointerException);
            }
            catch (Exception exception) {
                COBOLDebugPlugin.logError(exception);
            }
            ++n2;
        }
        return bl;
    }

    protected boolean fireBreakpointRemoved(IBreakpoint iBreakpoint) {
        Object[] objectArray = this.fBreakpointListeners.getListeners();
        int n = objectArray.length;
        if (n <= 0) {
            return true;
        }
        boolean bl = true;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < n) {
            try {
                bl2 = ((ICOBOLBreakpointListener)objectArray[n2]).breakpointRemoved(iBreakpoint);
                if (bl) {
                    bl = bl2;
                }
            }
            catch (NullPointerException nullPointerException) {
                COBOLDebugPlugin.logError(nullPointerException);
            }
            catch (Exception exception) {
                COBOLDebugPlugin.logError(exception);
            }
            ++n2;
        }
        return bl;
    }

    public boolean setEnableBreakpoint(ICOBOLBreakpoint iCOBOLBreakpoint, boolean bl) {
        return this.fireSetEnableBreakpoint(iCOBOLBreakpoint, bl);
    }

    protected boolean fireSetEnableBreakpoint(ICOBOLBreakpoint iCOBOLBreakpoint, boolean bl) {
        return true;
    }

    public boolean breakpointPropertyChanged(ICOBOLBreakpoint iCOBOLBreakpoint) {
        return this.fireBreakpointPropertiesChanged(iCOBOLBreakpoint);
    }

    protected boolean fireBreakpointPropertiesChanged(ICOBOLBreakpoint iCOBOLBreakpoint) {
        return true;
    }

    protected IBreakpointManager getBreakpointManager() {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (debugPlugin != null) {
            return debugPlugin.getBreakpointManager();
        }
        return null;
    }

    public void shutdown() {
        if (this.fBreakpointListeners != null) {
            this.fBreakpointListeners.clear();
        }
        super.shutdown();
    }
}

