/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.internal.core.model;

import org.eclipse.cobol.core.debug.exceptions.COBOLDebugException;
import org.eclipse.cobol.core.debug.model.ICOBOLDebugEventHandler;
import org.eclipse.cobol.core.debug.model.ICOBOLType;
import org.eclipse.cobol.core.debug.model.ICOBOLValue;
import org.eclipse.cobol.core.debug.model.ICOBOLVariable;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.internal.core.events.COBOLVariableEvent;
import org.eclipse.cobol.debug.internal.core.model.CBDIDebugElement;
import org.eclipse.cobol.debug.internal.core.model.CBDIValue;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;

public class CBDIVariable
extends CBDIDebugElement
implements ICOBOLVariable {
    protected String fName;
    protected CBDIValue fValue;
    protected String fProgramName;
    protected String fFullyQualifiedName;
    protected ICOBOLType fType;
    protected boolean fIsEditable;
    protected boolean fValueChanged;
    protected boolean fInterrupteable;
    protected int fInterruptionID;

    public CBDIVariable(IDebugTarget iDebugTarget, boolean bl) {
        super(iDebugTarget);
        this.setAsInterrupteable(bl);
        this.fInterruptionID = 0;
    }

    public CBDIVariable(IDebugTarget iDebugTarget, String string, ICOBOLType iCOBOLType, boolean bl, String string2, String string3, ICOBOLValue iCOBOLValue) {
        super(iDebugTarget);
        this.fName = string;
        this.fType = iCOBOLType;
        this.fIsEditable = bl;
        this.fFullyQualifiedName = string2;
        this.fProgramName = string3;
        this.fValue = (CBDIValue)iCOBOLValue;
        this.fValueChanged = false;
        this.fInterruptionID = 0;
        try {
            if (iCOBOLType.getTypeID() == 192) {
                this.setValueModification(false);
            }
        }
        catch (COBOLDebugException cOBOLDebugException) {}
    }

    public String getSignature() throws COBOLDebugException {
        return "";
    }

    public ICOBOLType getCobolType() throws COBOLDebugException {
        return this.fType;
    }

    public IValue getValue() throws DebugException {
        return this.fValue;
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    public String getFullyQualifiedName() throws DebugException {
        return this.fFullyQualifiedName;
    }

    public String getReferenceTypeName() throws DebugException {
        if (this.fType != null) {
            return this.fType.getName();
        }
        return "";
    }

    public void setValue(String string) throws DebugException {
        try {
            if (this.fValue != null) {
                this.fValue.setValue(string);
                COBOLVariableEvent cOBOLVariableEvent = new COBOLVariableEvent((Object)this, false, 1, this, this.getCOBOLVariableEventHandler());
                COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(cOBOLVariableEvent);
                this.fireChangeEvent(256);
            }
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugPlugin.logError(nullPointerException);
        }
    }

    public void setValue(IValue iValue) throws DebugException {
        try {
            if (this.fValue != null) {
                this.fValue = (CBDIValue)iValue;
            }
            this.fireChangeEvent(256);
            return;
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugPlugin.logError(nullPointerException);
            return;
        }
    }

    public boolean supportsValueModification() {
        return this.fIsEditable;
    }

    public boolean verifyValue(String string) throws DebugException {
        return true;
    }

    public boolean verifyValue(IValue iValue) throws DebugException {
        return true;
    }

    public void setName(String string) {
        this.fName = string;
    }

    public void setFullyQualifiedName(String string) {
        this.fFullyQualifiedName = string;
    }

    public void setProgramName(String string) {
        this.fProgramName = string;
    }

    public String getProgramName() {
        return this.fProgramName;
    }

    public void setValueModification(boolean bl) {
        this.fIsEditable = bl;
    }

    public void setType(ICOBOLType iCOBOLType) {
        this.fType = iCOBOLType;
    }

    public ICOBOLType getType() {
        return this.fType;
    }

    public boolean hasValueChanged() throws DebugException {
        return this.fValueChanged;
    }

    public void valueChanged(boolean bl) {
        this.fValueChanged = bl;
    }

    public boolean isInterrupteable() {
        return this.fInterrupteable;
    }

    public void setAsInterrupteable(boolean bl) {
        this.fInterrupteable = bl;
    }

    public int getInterruptionID() {
        return this.fInterruptionID;
    }

    public void setInterruptionID(int n) {
        this.fInterruptionID = n;
    }

    public ICOBOLDebugEventHandler getCOBOLVariableEventHandler() {
        return null;
    }
}

