/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.internal.core.model;

import org.eclipse.cobol.core.debug.exceptions.COBOLDebugException;
import org.eclipse.cobol.core.debug.model.ICOBOLType;
import org.eclipse.cobol.core.debug.model.ICOBOLValue;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.internal.core.model.CBDIDebugElement;
import org.eclipse.cobol.debug.internal.core.model.CBDIVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IVariable;

public class CBDIValue
extends CBDIDebugElement
implements ICOBOLValue {
    protected ICOBOLType fType;
    protected IVariable[] fVariables;
    protected String fAutoValue;
    protected String fHexaValue;
    protected String fCharValue;
    protected String fProgramName;
    protected IDebugTarget fDebugTarget;
    protected boolean fSplited = false;

    public CBDIValue(IDebugTarget iDebugTarget) {
        super(iDebugTarget);
        this.fDebugTarget = iDebugTarget;
        this.fAutoValue = "";
        this.fHexaValue = "";
        this.fCharValue = "";
        this.fVariables = null;
        this.fType = null;
        this.fProgramName = "";
    }

    public CBDIValue(IDebugTarget iDebugTarget, ICOBOLType iCOBOLType, String string, String string2, String string3, String string4, IVariable[] iVariableArray) {
        super(iDebugTarget);
        this.fDebugTarget = iDebugTarget;
        this.fAutoValue = string2;
        this.fHexaValue = string3;
        this.fCharValue = string4;
        if (iVariableArray != null) {
            if (iVariableArray.length <= 100) {
                this.fVariables = iVariableArray;
            } else {
                this.fSplited = true;
                this.fVariables = this.getArrayFragments(iVariableArray);
            }
        } else {
            this.fVariables = iVariableArray;
        }
        this.fType = iCOBOLType;
        this.fProgramName = string;
    }

    private IVariable[] getArrayFragments(IVariable[] iVariableArray) {
        int n = iVariableArray.length / 100;
        if (iVariableArray.length % 100 != 0) {
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        String string = new String();
        CBDIValue cBDIValue = null;
        CBDIVariable[] cBDIVariableArray = new CBDIVariable[n];
        ICOBOLType iCOBOLType = this.fType;
        int n4 = 0;
        while (n4 < n) {
            n2 = n4 * 100 + 1;
            n3 = n2 + 100 - 1;
            if (n3 > iVariableArray.length) {
                n3 = iVariableArray.length;
            }
            IVariable[] iVariableArray2 = new IVariable[n3 - n2 + 1];
            System.arraycopy(iVariableArray, n2 - 1, iVariableArray2, 0, n3 - n2 + 1);
            cBDIValue = new CBDIValue(this.fDebugTarget, this.fType, this.fProgramName, this.fAutoValue, this.fHexaValue, this.fCharValue, iVariableArray2);
            string = "[ " + n2 + "..." + n3 + " ]";
            try {
                cBDIVariableArray[n4] = new CBDIVariable(this.getDebugTarget(), string, iCOBOLType, false, string, this.getProgramName(), cBDIValue);
            }
            catch (COBOLDebugException cOBOLDebugException) {}
            ++n4;
        }
        return cBDIVariableArray;
    }

    public String getSignature() throws COBOLDebugException {
        return "";
    }

    public ICOBOLType getCOBOLType() throws COBOLDebugException {
        return this.fType;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.fType.getName();
    }

    public String getValueString() throws DebugException {
        return this.fAutoValue;
    }

    public String getHexaValueString() throws COBOLDebugException {
        return this.fHexaValue;
    }

    public String getCharValueString() throws COBOLDebugException {
        return this.fCharValue;
    }

    public boolean isAllocated() throws DebugException {
        return false;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.fVariables;
    }

    public void setVariable(IVariable[] iVariableArray) {
        try {
            this.fVariables = iVariableArray;
        }
        catch (Exception exception) {
            COBOLDebugPlugin.logError(exception);
        }
    }

    public void setProgramName(String string) {
        this.fProgramName = string;
    }

    public void setType(ICOBOLType iCOBOLType) {
        this.fType = iCOBOLType;
    }

    public void setValue(String string) {
        this.fAutoValue = string;
    }

    public void setVariable(IVariable iVariable) {
        if (iVariable != null) {
            try {
                if (this.fVariables != null) {
                    this.fVariables = null;
                }
                this.fVariables = new IVariable[1];
                this.fVariables[0] = iVariable;
            }
            catch (Exception exception) {
                COBOLDebugPlugin.logError(exception);
            }
        }
    }

    public void setHexaValue(String string) {
        this.fHexaValue = string;
    }

    public void setCharValue(String string) throws DebugException {
        this.fCharValue = string;
    }

    public boolean hasVariables() throws DebugException {
        return this.fVariables != null && this.fVariables.length > 0;
    }

    public String getProgramName() throws COBOLDebugException {
        return this.fProgramName;
    }

    public boolean isSplited() {
        return this.fSplited;
    }
}

