/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.internal.core.model;

import org.eclipse.cobol.core.debug.model.ICOBOLDebugEventHandler;
import org.eclipse.cobol.core.debug.model.ICOBOLDebugTarget;
import org.eclipse.cobol.core.debug.model.ICOBOLStackframe;
import org.eclipse.cobol.core.debug.model.ICOBOLThread;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.internal.core.events.COBOLDebugStepEvent;
import org.eclipse.cobol.debug.internal.core.events.COBOLDebugSuspendEvent;
import org.eclipse.cobol.debug.internal.core.events.COBOLThreadEvent;
import org.eclipse.cobol.debug.internal.core.model.CBDIDebugElement;
import org.eclipse.cobol.debug.internal.core.model.CBDIDebugTarget;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jface.dialogs.MessageDialog;

public abstract class CBDIThread
extends CBDIDebugElement
implements ICOBOLThread {
    protected boolean fSuspended;
    protected boolean fTerminated;
    protected boolean fStepping;
    protected ICOBOLStackframe[] fStackFrames = new ICOBOLStackframe[0];
    protected int fThreadId;
    protected String fThreadName;
    protected long fSystemThreadId;
    protected int fThreadStatus;
    protected boolean fDefault;
    protected long fPriority;
    protected boolean fDebuggable;

    public void cleanup() {
        if (this.fStackFrames != null && this.fStackFrames.length > 0) {
            int n = 0;
            while (n < this.fStackFrames.length) {
                this.fStackFrames[n] = null;
                ++n;
            }
            this.fStackFrames = new ICOBOLStackframe[0];
        }
    }

    public CBDIThread(IDebugTarget iDebugTarget, int n, boolean bl) {
        super(iDebugTarget);
        this.fSuspended = !bl;
        this.fThreadId = n;
        this.fThreadName = "";
    }

    public CBDIThread(IDebugTarget iDebugTarget, int n, long l, boolean bl, int n2, boolean bl2, int n3, long l2) {
        super(iDebugTarget);
        this.fStackFrames = new ICOBOLStackframe[0];
        this.fThreadId = n;
        this.fSystemThreadId = l;
        this.fDebuggable = bl;
        this.fThreadStatus = n2;
        this.fDefault = bl2;
        this.fPriority = l2;
        this.fThreadName = Long.toString(n);
    }

    public CBDIThread(IDebugTarget iDebugTarget) {
        super(iDebugTarget);
        this.fThreadId = 0;
        this.fThreadName = "";
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (!this.isSuspended() || this.isTerminated()) {
            return new IStackFrame[0];
        }
        return this.fStackFrames;
    }

    public int getPriority() throws DebugException {
        return (int)this.fPriority;
    }

    public IStackFrame getTopStackFrame() {
        if (this.fStackFrames == null || this.fStackFrames.length == 0) {
            return null;
        }
        return this.fStackFrames[0];
    }

    public String getName() throws DebugException {
        return this.fThreadName;
    }

    public IBreakpoint getBreakpoint() {
        return null;
    }

    public boolean canResume() {
        return this.getDebugTarget().isSuspended();
    }

    public boolean canSuspend() {
        return !this.getDebugTarget().isSuspended() && !this.isTerminated();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public void resume() throws DebugException {
        if (!this.isAvailable() || this.getDebugTarget() == null) {
            return;
        }
        this.fSuspended = false;
        ((CBDIDebugTarget)this.getDebugTarget()).setSuspended(this.fSuspended);
        COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(new COBOLDebugStepEvent((Object)this, false, 3, this.getCOBOLStepEventHandler()));
        this.fireResumeEvent(0);
    }

    public void suspend() throws DebugException {
        if (this.isAvailable() && this.getDebugTarget() != null) {
            this.fSuspended = true;
            ((CBDIDebugTarget)this.getDebugTarget()).setSuspended(this.fSuspended);
            COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(new COBOLDebugSuspendEvent((Object)this, true, this.getCOBOLDebugSuspendEventHandler(), true));
        }
    }

    public boolean canStepInto() {
        return this.canNotifyDebugEvents() && this.getDebugTarget().isSuspended() && !this.fTerminated;
    }

    public boolean canStepOver() {
        return this.canNotifyDebugEvents() && this.getDebugTarget().isSuspended() && !this.fTerminated;
    }

    public boolean canStepReturn() {
        return this.canNotifyDebugEvents() && this.getDebugTarget().isSuspended() && this.fStackFrames != null && this.fStackFrames.length > 1;
    }

    public boolean isStepping() {
        return this.fStepping;
    }

    public void stepInto() throws DebugException {
        if (!this.isAvailable() || this.getDebugTarget() == null) {
            return;
        }
        this.fSuspended = false;
        this.fStepping = true;
        ((CBDIDebugTarget)this.getDebugTarget()).setSuspended(this.fSuspended);
        COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(new COBOLDebugStepEvent((Object)this, false, 0, this.getCOBOLStepEventHandler()));
        this.fireResumeEvent(0);
    }

    public void stepOver() throws DebugException {
        if (!this.isAvailable() || this.getDebugTarget() == null) {
            return;
        }
        this.fSuspended = false;
        this.fStepping = true;
        ((CBDIDebugTarget)this.getDebugTarget()).setSuspended(this.fSuspended);
        COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(new COBOLDebugStepEvent((Object)this, false, 1, this.getCOBOLStepEventHandler()));
        this.fireResumeEvent(0);
    }

    public void stepReturn() throws DebugException {
        if (!this.isAvailable() || this.getDebugTarget() == null) {
            return;
        }
        this.fSuspended = false;
        this.fStepping = true;
        ((CBDIDebugTarget)this.getDebugTarget()).setSuspended(this.fSuspended);
        COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(new COBOLDebugStepEvent((Object)this, false, 2, this.getCOBOLStepEventHandler()));
        this.fireResumeEvent(0);
    }

    public boolean canTerminate() {
        return this.getCOBOLDebugTarget().canTerminate() && !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.fThreadStatus > 1;
    }

    public void terminate() {
        if (this.isTerminated() || this.getDebugTarget() == null) {
            return;
        }
        this.fSuspended = true;
        this.fTerminated = true;
        try {
            this.cleanup();
            this.getDebugTarget().terminate();
        }
        catch (DebugException debugException) {
            MessageDialog.openError(null, (String)debugException.toString(), (String)debugException.getLocalizedMessage());
        }
    }

    public void terminated() {
        if (this.isTerminated() || this.getDebugTarget() == null) {
            return;
        }
        this.fSuspended = true;
        this.fTerminated = true;
        this.cleanup();
        ((CBDIDebugTarget)this.getDebugTarget()).terminated();
    }

    public boolean canStep() {
        return !this.isTerminated() && this.isSuspended();
    }

    private boolean isAvailable() {
        return !this.isTerminated();
    }

    public void setSteppingComplete() {
        this.fStepping = false;
        this.fSuspended = true;
        ((CBDIDebugTarget)this.getDebugTarget()).setSuspended(true);
    }

    public void setSuspended(boolean bl) {
        this.fSuspended = this.getDebugTarget().isSuspended();
    }

    public IBreakpoint[] getBreakpoints() {
        return new IBreakpoint[0];
    }

    public boolean hasStackFrames() throws DebugException {
        return this.fStackFrames != null && this.fStackFrames.length != 0;
    }

    public ICOBOLDebugTarget getCOBOLDebugTarget() {
        return (ICOBOLDebugTarget)this.getDebugTarget();
    }

    public void setThreadName(String string) {
        this.fThreadName = string;
    }

    public void setThreadId(int n) {
        this.fThreadId = n;
    }

    public int getThreadId() {
        return this.fThreadId;
    }

    public void setStackframes(ICOBOLStackframe[] iCOBOLStackframeArray) {
        this.fStackFrames = iCOBOLStackframeArray;
    }

    public long getSystemThreadId() {
        return this.fSystemThreadId;
    }

    public void setSystemThreadId(int n) {
        this.fSystemThreadId = n;
    }

    public boolean getDebuggable() {
        return this.fDebuggable;
    }

    public int getThreadStatus() {
        return this.fThreadStatus;
    }

    public void setThreadStatus(int n) {
        this.fThreadStatus = n;
    }

    public boolean canNotifyDebugEvents() {
        return this.fDebuggable;
    }

    public boolean isCurrentThread() {
        return this.fDefault;
    }

    public void setAsCurrentThread(boolean bl) {
        COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(new COBOLThreadEvent((Object)this, false, COBOLThreadEvent.CURRENT_THREAD, bl, this.getCOBOLThreadEventHandler()));
    }

    public void setNotifyDebugEvents(boolean bl) {
        COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(new COBOLThreadEvent((Object)this, false, COBOLThreadEvent.NOTIFY_DEBUG_EVENTS, bl, this.getCOBOLThreadEventHandler()));
    }

    public boolean isDefault() {
        return this.fDefault;
    }

    public abstract ICOBOLDebugEventHandler getCOBOLStepEventHandler();

    public abstract ICOBOLDebugEventHandler getCOBOLBreakpointEventHandler();

    public abstract ICOBOLDebugEventHandler getCOBOLVariableEventHandler();

    public abstract ICOBOLDebugEventHandler getCOBOLChangeExcecutionpointEventHandler();

    public abstract ICOBOLDebugEventHandler getCOBOLRuntoLineEventHandler();

    public abstract ICOBOLDebugEventHandler getCOBOLDebugSuspendEventHandler();

    public abstract ICOBOLDebugEventHandler getCOBOLThreadEventHandler();
}

