/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.internal.core.model;

import org.eclipse.cobol.core.debug.model.ICOBOLDebugTarget;
import org.eclipse.cobol.core.debug.model.ICOBOLStackframe;
import org.eclipse.cobol.core.debug.model.ICOBOLThread;
import org.eclipse.cobol.debug.internal.core.model.CBDIDebugElement;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

public abstract class CBDIStackFrame
extends CBDIDebugElement
implements ICOBOLStackframe {
    protected IThread fThread;
    protected String fFileName;
    protected String fProgramName;
    protected int fLineNumber;

    public void cleanup() {
        if (this.fThread != null) {
            this.fThread = null;
        }
    }

    public CBDIStackFrame(IThread iThread) {
        super((IDebugTarget)((ICOBOLThread)iThread).getCOBOLDebugTarget());
        this.fThread = (ICOBOLThread)iThread;
    }

    public CBDIStackFrame(IThread iThread, String string, String string2, int n) {
        super(iThread.getDebugTarget());
        this.fThread = (ICOBOLThread)iThread;
        this.fFileName = string.startsWith("./") ? string.substring(2) : string;
        this.fProgramName = string2;
        this.fLineNumber = n;
    }

    public IThread getThread() {
        return this.fThread;
    }

    public IVariable[] getVariables() throws DebugException {
        return new IVariable[0];
    }

    public int getLineNumber() throws DebugException {
        return this.fLineNumber;
    }

    public String getName() throws DebugException {
        return this.fFileName;
    }

    public String getProgramName() throws DebugException {
        return this.fProgramName;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public boolean canResume() {
        if (this.fThread != null) {
            return this.fThread.canResume();
        }
        return false;
    }

    public boolean canSuspend() {
        if (this.fThread != null) {
            return this.fThread.canSuspend();
        }
        return false;
    }

    public boolean isSuspended() {
        if (this.fThread != null) {
            return this.fThread.isSuspended();
        }
        return false;
    }

    public void resume() throws DebugException {
        if (this.fThread != null) {
            this.fThread.resume();
        }
    }

    public void suspend() throws DebugException {
        if (this.fThread != null) {
            this.fThread.suspend();
        }
    }

    public boolean canStepInto() {
        if (this.fThread != null) {
            return this.fThread.canStepInto();
        }
        return false;
    }

    public boolean canStepOver() {
        if (this.fThread != null) {
            return this.fThread.canStepOver();
        }
        return false;
    }

    public boolean canStepReturn() {
        if (this.fThread != null) {
            return this.fThread.canStepReturn();
        }
        return false;
    }

    public boolean isStepping() {
        if (this.fThread != null) {
            return this.fThread.isStepping();
        }
        return false;
    }

    public void stepInto() throws DebugException {
        if (this.fThread != null) {
            this.fThread.stepInto();
        }
    }

    public void stepOver() throws DebugException {
        if (this.fThread != null) {
            this.fThread.stepOver();
        }
    }

    public void stepReturn() throws DebugException {
        if (this.fThread != null) {
            this.fThread.stepReturn();
        }
    }

    public boolean canTerminate() {
        if (this.fThread != null) {
            return this.fThread.canTerminate();
        }
        return false;
    }

    public boolean isTerminated() {
        if (this.fThread != null) {
            return this.fThread.isTerminated();
        }
        return false;
    }

    public void terminate() throws DebugException {
        if (this.fThread != null) {
            this.fThread.terminate();
        }
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public void setName(String string) {
        this.fFileName = string;
    }

    public void setLineNumber(int n) {
        this.fLineNumber = n;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean hasVariables() throws DebugException {
        return false;
    }

    public ICOBOLDebugTarget getCOBOLDebugTarget() {
        return (ICOBOLDebugTarget)this.getDebugTarget();
    }

    public ICOBOLThread getCOBOLThread() {
        return (ICOBOLThread)this.getThread();
    }
}

