/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.internal.core.model;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cobol.core.debug.exceptions.COBOLDebugException;
import org.eclipse.cobol.core.debug.model.ICOBOLBreakpoint;
import org.eclipse.cobol.core.debug.model.ICOBOLDebugElement;
import org.eclipse.cobol.core.debug.model.ICOBOLDebugEventHandler;
import org.eclipse.cobol.core.debug.model.ICOBOLDebugEventListener;
import org.eclipse.cobol.core.debug.model.ICOBOLDebugTarget;
import org.eclipse.cobol.core.debug.model.ICOBOLHitCountBreakpoint;
import org.eclipse.cobol.core.debug.model.ICOBOLLineBreakpoint;
import org.eclipse.cobol.core.debug.model.ICOBOLThread;
import org.eclipse.cobol.core.debug.model.ICOBOLVariable;
import org.eclipse.cobol.core.debug.model.ICOBOLVariableListener;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.internal.core.COBOLDebugRequestEventDispatcher;
import org.eclipse.cobol.debug.internal.core.COBOLDebugUtil;
import org.eclipse.cobol.debug.internal.core.breakpoints.COBOLLineBreakpoint;
import org.eclipse.cobol.debug.internal.core.events.COBOLBreakpointEvent;
import org.eclipse.cobol.debug.internal.core.events.COBOLChangeExcecutionpointEvent;
import org.eclipse.cobol.debug.internal.core.events.COBOLDebugStepEvent;
import org.eclipse.cobol.debug.internal.core.events.COBOLDebugSuspendEvent;
import org.eclipse.cobol.debug.internal.core.events.COBOLRuntoLineEvent;
import org.eclipse.cobol.debug.internal.core.events.COBOLStopDebuggerEvent;
import org.eclipse.cobol.debug.internal.core.events.COBOLVariableEvent;
import org.eclipse.cobol.debug.internal.core.model.CBDIDebugElement;
import org.eclipse.cobol.debug.internal.core.model.CBDIThread;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class CBDIDebugTarget
extends CBDIDebugElement
implements ICOBOLDebugTarget,
ICOBOLVariableListener,
ICOBOLDebugEventListener {
    private boolean fIsStepping = false;
    protected ILaunch fLaunch;
    protected IProject fProject;
    protected ICOBOLThread[] fThreads;
    private IProcess fProcess;
    protected String fTargetName;
    private boolean fTerminated = false;
    private boolean fSuspended = false;
    private boolean fResumed = false;
    private boolean fTerminating;
    private List fBreakpoints;
    private boolean fChanging;
    private boolean fBreakpointRemoving;

    public void disposeMembers() {
        if (this.fThreads != null && this.fThreads.length > 0) {
            int n = 0;
            while (n < this.fThreads.length) {
                this.fThreads[n].cleanup();
                this.fThreads[n] = null;
                ++n;
            }
            this.fThreads = new ICOBOLThread[0];
        }
    }

    public void cleanWhenLaunchRemoved() {
        super.setDebugTarget(null);
        this.fProject = null;
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    public IThread[] getThreads() {
        if (this.fThreads == null) {
            return new ICOBOLThread[0];
        }
        return this.fThreads;
    }

    public String getName() throws DebugException {
        return this.fTargetName;
    }

    public void setName(String string) {
        this.fTargetName = string;
    }

    public boolean canTerminate() {
        return !this.isTerminated() && !this.isTerminating();
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() {
        if (this.canTerminate()) {
            this.setTerminating(true);
            this.cleanup();
            COBOLDebugRequestEventDispatcher cOBOLDebugRequestEventDispatcher = COBOLDebugPlugin.getEventDispatcher(this.getLaunch());
            if (cOBOLDebugRequestEventDispatcher != null) {
                cOBOLDebugRequestEventDispatcher.fireEvent(new COBOLDebugSuspendEvent((Object)this, true, this.getCOBOLDebugSuspendEventHandler()));
                cOBOLDebugRequestEventDispatcher.fireEvent(new COBOLStopDebuggerEvent((Object)this, true, true, this.getCOBOLStopDebuggerEventHandler()));
            }
        }
    }

    public void terminated() {
        if (this.canTerminate()) {
            this.setTerminating(true);
            this.cleanup();
            COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(new COBOLStopDebuggerEvent((Object)this, false, false, this.getCOBOLStopDebuggerEventHandler()));
        }
    }

    protected boolean isTargetExistingInLaunch() {
        IDebugTarget[] iDebugTargetArray = this.getLaunch().getDebugTargets();
        if (iDebugTargetArray == null || iDebugTargetArray.length == 0) {
            return false;
        }
        int n = 0;
        while (n < iDebugTargetArray.length) {
            if (iDebugTargetArray[n].equals((Object)this)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean canResume() {
        return this.fSuspended && !this.isTerminated() && !this.isTerminating() && this.isAllThreadsSuspended();
    }

    public boolean canSuspend() {
        return !this.fSuspended && !this.isTerminated() && !this.isTerminating() && !this.isAllThreadsSuspended();
    }

    public boolean isSuspended() {
        return this.fSuspended;
    }

    public void resume() throws DebugException {
        if (!this.isTerminated()) {
            this.fSuspended = false;
            COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(new COBOLDebugStepEvent((Object)this, false, 3, this.getCOBOLStepEventHandler()));
            this.fireResumeEvent(0);
        }
    }

    public void suspend() throws DebugException {
        if (!this.isTerminated()) {
            this.fSuspended = true;
            COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(new COBOLDebugSuspendEvent((Object)this, true, this.getCOBOLDebugSuspendEventHandler(), true));
        }
    }

    public void breakpointAdded(IBreakpoint iBreakpoint) {
        if (this.isTerminated() || this.fProject == null || iBreakpoint.getMarker() == null) {
            return;
        }
        if (iBreakpoint instanceof ICOBOLBreakpoint) {
            if (!COBOLDebugUtil.isBreakpointOfSourceLookup(this.fProject, this.fLaunch.getLaunchConfiguration(), iBreakpoint)) {
                return;
            }
            if (!((ICOBOLBreakpoint)iBreakpoint).isSuccess()) {
                ((ICOBOLBreakpoint)iBreakpoint).setSuccess(true);
                this.getBreakpoints().add(iBreakpoint);
                return;
            }
            if (!this.getBreakpoints().contains(iBreakpoint)) {
                COBOLLineBreakpoint cOBOLLineBreakpoint = (COBOLLineBreakpoint)iBreakpoint;
                this.getBreakpoints().add(iBreakpoint);
                try {
                    COBOLBreakpointEvent cOBOLBreakpointEvent = new COBOLBreakpointEvent((Object)this, false, 0, cOBOLLineBreakpoint, this.getCOBOLBreakpointEventHandler());
                    COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(cOBOLBreakpointEvent);
                    return;
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
    }

    public void breakpointRemoved(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        if (this.isTerminated() || this.fProject == null || iBreakpoint.getMarker() == null) {
            return;
        }
        if (iBreakpoint instanceof ICOBOLBreakpoint) {
            if (!COBOLDebugUtil.isBreakpointOfSourceLookup(this.fProject, this.fLaunch.getLaunchConfiguration(), iBreakpoint)) {
                return;
            }
            if (!((ICOBOLBreakpoint)iBreakpoint).isSuccess() || !((ICOBOLBreakpoint)iBreakpoint).isValid()) {
                ((ICOBOLBreakpoint)iBreakpoint).setSuccess(true);
                this.getBreakpoints().remove(iBreakpoint);
                return;
            }
            if (this.getBreakpoints().contains(iBreakpoint)) {
                COBOLLineBreakpoint cOBOLLineBreakpoint = (COBOLLineBreakpoint)iBreakpoint;
                this.getBreakpoints().remove(iBreakpoint);
                try {
                    COBOLBreakpointEvent cOBOLBreakpointEvent = new COBOLBreakpointEvent((Object)this, false, 1, cOBOLLineBreakpoint, this.getCOBOLBreakpointEventHandler());
                    COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(cOBOLBreakpointEvent);
                    return;
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
    }

    public void breakpointChanged(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        if (this.isTerminated() || this.fProject == null || iBreakpoint.getMarker() == null) {
            return;
        }
        if (iBreakpoint instanceof ICOBOLBreakpoint) {
            int n;
            COBOLLineBreakpoint cOBOLLineBreakpoint;
            block14: {
                if (!COBOLDebugUtil.isBreakpointOfSourceLookup(this.fProject, this.fLaunch.getLaunchConfiguration(), iBreakpoint)) {
                    return;
                }
                if (!((ICOBOLBreakpoint)iBreakpoint).isSuccess()) {
                    ((ICOBOLBreakpoint)iBreakpoint).setSuccess(true);
                    return;
                }
                cOBOLLineBreakpoint = (COBOLLineBreakpoint)iBreakpoint;
                n = 0;
                try {
                    boolean bl;
                    if (iMarkerDelta == null) break block14;
                    boolean bl2 = iMarkerDelta.getAttribute("org.eclipse.debug.core.enabled", true);
                    try {
                        bl = cOBOLLineBreakpoint.isEnabled();
                    }
                    catch (CoreException coreException) {
                        COBOLDebugPlugin.logError((Exception)((Object)coreException));
                        return;
                    }
                    if (bl2 != bl) {
                        n = 1;
                    }
                    try {
                        int n2;
                        int n3;
                        if (iBreakpoint instanceof ICOBOLHitCountBreakpoint && (n3 = iMarkerDelta.getAttribute("org.eclipse.cobol.core.debug.hitCount", 1)) != (n2 = cOBOLLineBreakpoint.getHitCount())) {
                            n |= 2;
                        }
                    }
                    catch (CoreException coreException) {}
                }
                catch (NullPointerException nullPointerException) {}
            }
            if (this.getBreakpoints().contains(iBreakpoint) && cOBOLLineBreakpoint.isValid()) {
                COBOLBreakpointEvent cOBOLBreakpointEvent = new COBOLBreakpointEvent((Object)this, false, 2, n, cOBOLLineBreakpoint, this.getCOBOLBreakpointEventHandler());
                COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(cOBOLBreakpointEvent);
                return;
            }
            if (!cOBOLLineBreakpoint.isValid() && n & true) {
                final ICOBOLBreakpoint iCOBOLBreakpoint = (ICOBOLBreakpoint)iBreakpoint;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            iCOBOLBreakpoint.setSuccess(false);
                            iCOBOLBreakpoint.setEnabled(false);
                        }
                        catch (CoreException coreException) {
                            COBOLDebugPlugin.logError((Exception)((Object)coreException));
                        }
                        catch (NullPointerException nullPointerException) {
                        }
                        catch (Exception exception) {
                            COBOLDebugPlugin.logError(exception);
                        }
                    }
                });
                this.setStatusMessageForBreakpoint((ICOBOLLineBreakpoint)iBreakpoint);
            }
        }
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long l, long l2) throws DebugException {
        return null;
    }

    public List getBreakpoints() {
        return this.fBreakpoints;
    }

    public CBDIDebugTarget() {
        super(null);
    }

    public CBDIDebugTarget(ILaunch iLaunch, IProject iProject) {
        super(null);
        this.fProcess = null;
        this.setLaunch(iLaunch);
        this.setBreakpoints(new ArrayList(5));
        this.fProject = iProject;
        if (iProject != null) {
            this.fTargetName = iProject.getName();
        }
    }

    public void initializeBreakpoints() {
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        iBreakpointManager.addBreakpointListener((IBreakpointListener)this);
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints(COBOLDebugUtil.getPluginIdentifier());
        int n = 0;
        while (n < iBreakpointArray.length) {
            if (iBreakpointArray[n] instanceof ICOBOLBreakpoint && COBOLDebugUtil.isBreakpointOfSourceLookup(this.fProject, this.fLaunch.getLaunchConfiguration(), iBreakpointArray[n])) {
                this.fBreakpoints.add(iBreakpointArray[n]);
                ((ICOBOLBreakpoint)iBreakpointArray[n]).setValid(true);
            }
            ++n;
        }
    }

    private void setBreakpoints(List list) {
        this.fBreakpoints = list;
    }

    public void addBreakPoint(IBreakpoint iBreakpoint) {
        if (!this.fBreakpoints.contains(iBreakpoint)) {
            this.fBreakpoints.add(iBreakpoint);
        }
    }

    public void variableAdded(String string, String string2, int n, boolean bl) {
        ICOBOLDebugEventHandler iCOBOLDebugEventHandler = this.getCOBOLVariableEventHandler();
        if (this.handlerIsNull(iCOBOLDebugEventHandler)) {
            return;
        }
        COBOLVariableEvent cOBOLVariableEvent = new COBOLVariableEvent((Object)this, false, 0, string2.toString(), string, n, bl, iCOBOLDebugEventHandler);
        COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(cOBOLVariableEvent);
    }

    public void variableAdded(String string, String string2, boolean bl) {
        ICOBOLDebugEventHandler iCOBOLDebugEventHandler = this.getCOBOLVariableEventHandler();
        if (this.handlerIsNull(iCOBOLDebugEventHandler)) {
            return;
        }
        COBOLVariableEvent cOBOLVariableEvent = new COBOLVariableEvent((Object)this, false, 0, string2, string, bl, iCOBOLDebugEventHandler);
        COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(cOBOLVariableEvent);
    }

    public void variableAdded(String string, String string2, boolean bl, boolean bl2) {
        ICOBOLDebugEventHandler iCOBOLDebugEventHandler = this.getCOBOLVariableEventHandler();
        if (this.handlerIsNull(iCOBOLDebugEventHandler)) {
            return;
        }
        COBOLVariableEvent cOBOLVariableEvent = new COBOLVariableEvent((Object)this, false, 0, string2, string, bl, iCOBOLDebugEventHandler, bl2);
        COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(cOBOLVariableEvent);
    }

    public void variableRemoved(ICOBOLVariable iCOBOLVariable) {
        COBOLVariableEvent cOBOLVariableEvent = new COBOLVariableEvent((Object)this, false, 2, iCOBOLVariable, this.getCOBOLVariableEventHandler());
        COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(cOBOLVariableEvent);
    }

    public void allVariablesRemoved() {
        COBOLVariableEvent cOBOLVariableEvent = new COBOLVariableEvent((Object)this, false, 3, null, this.getCOBOLVariableEventHandler());
        COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(cOBOLVariableEvent);
    }

    public void VariableInterruptionHasSet(ICOBOLVariable iCOBOLVariable) {
        COBOLVariableEvent cOBOLVariableEvent = new COBOLVariableEvent((Object)this, false, 4, iCOBOLVariable, this.getCOBOLVariableEventHandler());
        COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(cOBOLVariableEvent);
    }

    protected void cleanup() {
        if (this.isTerminating()) {
            this.fTerminated = true;
            this.fSuspended = true;
            this.fResumed = true;
            if (this.fProcess != null) {
                try {
                    this.fProcess.terminate();
                }
                catch (DebugException debugException) {
                    COBOLDebugPlugin.logError((Exception)((Object)debugException));
                }
            }
            if (this.fThreads != null && this.fThreads.length > 0) {
                int n = 0;
                while (n < this.fThreads.length) {
                    if (this.fThreads[n] != null) {
                        try {
                            this.fThreads[n].terminate();
                            this.fThreads[n] = null;
                        }
                        catch (DebugException debugException) {
                            COBOLDebugPlugin.logError((Exception)((Object)debugException));
                        }
                    }
                    ++n;
                }
            }
            this.fThreads = new ICOBOLThread[0];
            if (this.fBreakpoints != null) {
                int n = this.fBreakpoints.size();
                int n2 = 0;
                while (n2 < n) {
                    if (this.fBreakpoints.get(n2) != null) {
                        ((ICOBOLBreakpoint)this.fBreakpoints.get(n2)).setValid(true);
                    }
                    ++n2;
                }
            }
            this.fBreakpoints.clear();
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
            COBOLDebugPlugin cOBOLDebugPlugin = COBOLDebugPlugin.getDefault();
            if (cOBOLDebugPlugin != null) {
                if (COBOLDebugPlugin.getCOBOLVariableManager() != null) {
                    COBOLDebugPlugin.getCOBOLVariableManager().saveVariables(this.fLaunch);
                    COBOLDebugPlugin.getCOBOLVariableManager().clear();
                    COBOLDebugPlugin.getCOBOLVariableManager().removeVariableListener(this);
                    COBOLDebugPlugin.getCOBOLDebugEventManager().removeDebugEventListener(this);
                }
                cOBOLDebugPlugin.setDebugging(false);
            }
            this.setTerminating(false);
        }
    }

    public boolean isTerminating() {
        return this.fTerminating;
    }

    public void setTerminating(boolean bl) {
        this.fTerminating = bl;
    }

    public void executionpointChanged(String string, int n) {
        ICOBOLDebugEventHandler iCOBOLDebugEventHandler = this.getCOBOLChangeExcecutionpointEventHandler();
        if (this.handlerIsNull(iCOBOLDebugEventHandler)) {
            return;
        }
        this.fSuspended = false;
        COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(new COBOLChangeExcecutionpointEvent((Object)this, false, n, iCOBOLDebugEventHandler));
        CBDIThread cBDIThread = (CBDIThread)this.getDefaultThread();
        if (cBDIThread != null) {
            this.fireResumeEvent(cBDIThread, 0);
        } else {
            this.fireResumeEvent(this, 0);
        }
    }

    public void runToLine(String string, int n) {
        ICOBOLDebugEventHandler iCOBOLDebugEventHandler = this.getCOBOLRuntoLineEventHandler();
        if (this.handlerIsNull(iCOBOLDebugEventHandler)) {
            return;
        }
        this.fSuspended = false;
        COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(new COBOLRuntoLineEvent((Object)this, false, string, n, iCOBOLDebugEventHandler));
        CBDIThread cBDIThread = (CBDIThread)this.getDefaultThread();
        if (cBDIThread != null) {
            this.fireResumeEvent(cBDIThread, 0);
        } else {
            this.fireResumeEvent(this, 0);
        }
    }

    private void fireResumeEvent(ICOBOLDebugElement iCOBOLDebugElement, int n) {
        this.fireEvent(new DebugEvent((Object)iCOBOLDebugElement, 1, n));
    }

    public void setProcess(IProcess iProcess) {
        if (iProcess == null) {
            this.fProcess = null;
            return;
        }
        this.fProcess = iProcess;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setSuspended(boolean bl) {
        this.fSuspended = bl;
        this.fIsStepping = false;
    }

    public boolean hasThreads() throws DebugException {
        return this.fThreads != null && this.fThreads.length > 0;
    }

    public boolean supportsBreakpoint(IBreakpoint iBreakpoint) {
        return iBreakpoint instanceof ICOBOLBreakpoint;
    }

    public void setLaunch(ILaunch iLaunch) {
        this.fLaunch = iLaunch;
    }

    @Override
    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public void setBreakpointChanging(boolean bl) {
        this.fChanging = bl;
    }

    public boolean isBreakpointChanging() {
        return this.fChanging;
    }

    public boolean isBreakpointRemoving() {
        return this.fBreakpointRemoving;
    }

    public void setBreakpointRemoving(boolean bl) {
        this.fBreakpointRemoving = bl;
    }

    public void setStatusMessageForBreakpoint(ICOBOLLineBreakpoint iCOBOLLineBreakpoint) {
        String string = "";
        try {
            string = Messages.getFormattedString((String)"BreakpointInvalidError.text", (Object)new Object[]{iCOBOLLineBreakpoint.getSourceName(), new Integer(iCOBOLLineBreakpoint.getLineNumber())});
        }
        catch (CoreException coreException) {
            COBOLDebugPlugin.logError((Exception)((Object)coreException));
        }
        COBOLDebugPlugin.setDebugStatusMessage(string);
    }

    public void setThreads(ICOBOLThread[] iCOBOLThreadArray) {
        this.fThreads = iCOBOLThreadArray;
    }

    public boolean canStepInto() {
        return this.canStep() && this.isAllThreadsSuspended();
    }

    public boolean canStepOver() {
        return this.canStep() && this.isAllThreadsSuspended();
    }

    public boolean canStepReturn() {
        boolean bl = false;
        ICOBOLThread iCOBOLThread = this.getDefaultThread();
        try {
            IStackFrame[] iStackFrameArray;
            if (iCOBOLThread != null && (iStackFrameArray = iCOBOLThread.getStackFrames()) != null && iStackFrameArray.length > 1) {
                bl = true;
            }
        }
        catch (DebugException debugException) {
            COBOLDebugPlugin.logError((Exception)((Object)debugException));
        }
        return this.canStep() && bl && this.isAllThreadsSuspended();
    }

    public boolean isStepping() {
        return this.canStep();
    }

    public void stepInto() throws DebugException {
        if (this.canStep()) {
            this.fIsStepping = true;
            this.setSuspended(false);
            COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(new COBOLDebugStepEvent(this.getDefaultThread(), false, 0, this.getCOBOLStepEventHandler()));
            this.fireResumeEvent(0);
        }
    }

    public void stepOver() throws DebugException {
        if (this.canStep()) {
            this.fIsStepping = true;
            this.setSuspended(false);
            COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(new COBOLDebugStepEvent(this.getDefaultThread(), false, 1, this.getCOBOLStepEventHandler()));
            this.fireResumeEvent(0);
        }
    }

    public void stepReturn() throws DebugException {
        if (this.canStep()) {
            this.fIsStepping = true;
            this.setSuspended(false);
            COBOLDebugPlugin.getEventDispatcher(this.getLaunch()).fireEvent(new COBOLDebugStepEvent(this.getDefaultThread(), false, 2, this.getCOBOLStepEventHandler()));
            this.fireResumeEvent(0);
        }
    }

    private boolean canStep() {
        return !this.fIsStepping && this.isSuspended() && !this.fTerminated && !this.fTerminating;
    }

    public ICOBOLThread getDefaultThread() {
        if (this.fThreads == null) {
            return null;
        }
        int n = 0;
        while (n < this.fThreads.length) {
            if (this.fThreads[n].isDefault()) {
                return this.fThreads[n];
            }
            ++n;
        }
        return null;
    }

    public boolean isAllThreadsSuspended() {
        if (this.fThreads == null) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        while (n < this.fThreads.length) {
            if (!this.fThreads[n].isSuspended()) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    protected boolean handlerIsNull(ICOBOLDebugEventHandler iCOBOLDebugEventHandler) {
        if (iCOBOLDebugEventHandler == null) {
            this.showDialog(Messages.getString((String)"Common.error.dialog.title"), Messages.getString((String)"Handler.notfound.error"));
            return true;
        }
        return false;
    }

    protected void showDialog(final String string, final String string2) {
        try {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = COBOLDebugPlugin.getActiveWorkbenchShell();
                    if (shell == null) {
                        shell = Display.getDefault().getActiveShell();
                    }
                    if (shell != null) {
                        try {
                            MessageDialog.openError((Shell)shell, (String)string, (String)string2);
                        }
                        catch (NullPointerException nullPointerException) {}
                    }
                }
            });
        }
        catch (NullPointerException nullPointerException) {}
    }

    public abstract void initialize(IProject var1) throws COBOLDebugException;

    public abstract ICOBOLDebugEventHandler getCOBOLStopDebuggerEventHandler();

    public abstract ICOBOLDebugEventHandler getCOBOLDebugSuspendEventHandler();

    public abstract ICOBOLDebugEventHandler getCOBOLStepEventHandler();

    public abstract ICOBOLDebugEventHandler getCOBOLBreakpointEventHandler();

    public abstract ICOBOLDebugEventHandler getCOBOLVariableEventHandler();

    public abstract ICOBOLDebugEventHandler getCOBOLChangeExcecutionpointEventHandler();

    public abstract ICOBOLDebugEventHandler getCOBOLRuntoLineEventHandler();
}

