/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.internal.core.model;

import org.eclipse.cobol.core.debug.model.ICOBOLDebugElement;
import org.eclipse.cobol.core.debug.model.ICOBOLDebugTarget;
import org.eclipse.cobol.debug.internal.core.COBOLDebugUtil;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;

public abstract class CBDIDebugElement
extends PlatformObject
implements ICOBOLDebugElement {
    private IDebugTarget fDebugTarget;

    public CBDIDebugElement(IDebugTarget iDebugTarget) {
        this.fDebugTarget = iDebugTarget;
    }

    protected void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    protected void fireEvent(DebugEvent debugEvent) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{debugEvent});
    }

    public void fireResumeEvent(int n) {
        this.fireEvent(new DebugEvent((Object)this, 1, n));
    }

    public void fireSuspendEvent(int n) {
        this.fireEvent(new DebugEvent((Object)this, 2, n));
    }

    public void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    public void fireChangeEvent(int n) {
        this.fireEvent(new DebugEvent((Object)this, 16, n));
    }

    protected void setDebugTarget(ICOBOLDebugTarget iCOBOLDebugTarget) {
        this.fDebugTarget = iCOBOLDebugTarget;
    }

    public IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(IDebugElement.class)) {
            return this;
        }
        return super.getAdapter(clazz);
    }

    public ILaunch getLaunch() {
        if (this.fDebugTarget != null) {
            return this.fDebugTarget.getLaunch();
        }
        return null;
    }

    public String getModelIdentifier() {
        return COBOLDebugUtil.getPluginIdentifier();
    }

    public ICOBOLDebugElement getCOBOLDebugElement() {
        return this;
    }
}

