/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.internal.core.events;

import org.eclipse.cobol.core.debug.model.ICOBOLBreakpoint;
import org.eclipse.cobol.core.debug.model.ICOBOLDebugEventHandler;
import org.eclipse.cobol.core.debug.model.ICOBOLLineBreakpoint;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.internal.core.events.COBOLEvent;
import org.eclipse.core.runtime.CoreException;

public class COBOLBreakpointEvent
extends COBOLEvent {
    public static final int ADD = 0;
    public static final int REMOVE = 1;
    public static final int CHANGE = 2;
    public static final int ENABLEDISABLE = 1;
    public static final int HITCOUNT = 2;
    private int fEventKind;
    private int fEventDetail;
    private int fHitCount;
    private ICOBOLBreakpoint fBreakpoint;
    private int fLineNumber;
    private String fFileName;
    private String fFullPath;

    public COBOLBreakpointEvent(Object object, boolean bl, int n, int n2, ICOBOLBreakpoint iCOBOLBreakpoint, ICOBOLDebugEventHandler iCOBOLDebugEventHandler) {
        super(object, bl, iCOBOLDebugEventHandler);
        this.fEventKind = n;
        this.fBreakpoint = iCOBOLBreakpoint;
        this.fEventDetail = n2;
        if (iCOBOLBreakpoint != null) {
            try {
                this.fFullPath = iCOBOLBreakpoint.getMarker().getResource().getFullPath().toOSString();
                this.fLineNumber = iCOBOLBreakpoint instanceof ICOBOLLineBreakpoint ? ((ICOBOLLineBreakpoint)iCOBOLBreakpoint).getLineNumber() : -1;
                this.fFileName = iCOBOLBreakpoint.getMarker().getResource().getProjectRelativePath().toOSString();
            }
            catch (CoreException coreException) {
                COBOLDebugPlugin.logError((Exception)((Object)coreException));
            }
        }
    }

    public COBOLBreakpointEvent(Object object, boolean bl, int n, ICOBOLBreakpoint iCOBOLBreakpoint, ICOBOLDebugEventHandler iCOBOLDebugEventHandler) {
        super(object, bl, iCOBOLDebugEventHandler);
        this.fEventKind = n;
        this.fBreakpoint = iCOBOLBreakpoint;
        this.fEventDetail = -1;
        if (iCOBOLBreakpoint != null) {
            try {
                this.fFullPath = iCOBOLBreakpoint.getMarker().getResource().getFullPath().toOSString();
                this.fLineNumber = iCOBOLBreakpoint instanceof ICOBOLLineBreakpoint ? ((ICOBOLLineBreakpoint)iCOBOLBreakpoint).getLineNumber() : -1;
                this.fFileName = iCOBOLBreakpoint.getMarker().getResource().getProjectRelativePath().toOSString();
            }
            catch (CoreException coreException) {
                COBOLDebugPlugin.logError((Exception)((Object)coreException));
            }
        }
    }

    public int getEventKind() {
        return this.fEventKind;
    }

    public ICOBOLBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public String getFileName() {
        return this.fFileName;
    }

    public String getFullPath() {
        return this.fFullPath;
    }

    public int getEventDetail() {
        return this.fEventDetail;
    }

    public int getHitCount() {
        return this.fHitCount;
    }
}

