/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.internal.core.breakpoints;

import java.util.Map;
import org.eclipse.cobol.core.debug.model.ICOBOLLineBreakpoint;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.internal.core.breakpoints.COBOLHitCountBreakpoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;

public class COBOLLineBreakpoint
extends COBOLHitCountBreakpoint
implements ICOBOLLineBreakpoint {
    private static final String COBOL_LINE_BREAKPOINT = "org.eclipse.cobol.debug.cobolLineBreakpointMarker";

    public COBOLLineBreakpoint() {
        this.fValid = true;
    }

    public COBOLLineBreakpoint(final IResource iResource, final int n, final int n2, final int n3, final boolean bl, final Map map) throws DebugException {
        super.setValid(true);
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    COBOLLineBreakpoint.this.setMarker(iResource.createMarker(COBOLLineBreakpoint.COBOL_LINE_BREAKPOINT));
                    COBOLLineBreakpoint.this.addLineBreakpointAttributes(map, COBOLLineBreakpoint.this.getModelIdentifier(), bl, n, n2, n3, iResource.getFullPath().toOSString(), 0);
                    try {
                        COBOLLineBreakpoint.this.ensureMarker().setAttributes(map);
                    }
                    catch (Exception exception) {
                        COBOLDebugPlugin.logError(exception);
                    }
                    COBOLLineBreakpoint.this.addToBreakpointManager();
                }
                catch (CoreException coreException) {
                    COBOLDebugPlugin.logError((Exception)((Object)coreException));
                }
                catch (Exception exception) {
                    COBOLDebugPlugin.logError(exception);
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, null);
        }
        catch (CoreException coreException) {
            COBOLDebugPlugin.logError((Exception)((Object)coreException));
        }
        catch (Exception exception) {
            COBOLDebugPlugin.logError(exception);
        }
    }

    public boolean supportsHitCount() {
        return true;
    }

    public int getLineNumber() throws CoreException {
        try {
            IMarker iMarker = this.ensureMarker();
            if (iMarker != null) {
                return iMarker.getAttribute("lineNumber", -1);
            }
        }
        catch (DebugException debugException) {
            COBOLDebugPlugin.logError((Exception)((Object)debugException));
        }
        return -1;
    }

    public int getCharStart() throws CoreException {
        try {
            IMarker iMarker = this.ensureMarker();
            if (iMarker != null) {
                return iMarker.getAttribute("charStart", -1);
            }
        }
        catch (DebugException debugException) {
            COBOLDebugPlugin.logError((Exception)((Object)debugException));
        }
        return -1;
    }

    public int getCharEnd() throws CoreException {
        try {
            IMarker iMarker = this.ensureMarker();
            if (iMarker != null) {
                return iMarker.getAttribute("charEnd", -1);
            }
        }
        catch (DebugException debugException) {
            COBOLDebugPlugin.logError((Exception)((Object)debugException));
        }
        return -1;
    }

    public void setMarker(IMarker iMarker) throws CoreException {
        super.setMarker(iMarker);
    }

    public static String getMarkerType() {
        return COBOL_LINE_BREAKPOINT;
    }

    public void addLineBreakpointAttributes(Map map, String string, boolean bl, int n, int n2, int n3, String string2, int n4) {
        map.put("org.eclipse.debug.core.id", string);
        map.put("org.eclipse.debug.core.enabled", new Boolean(bl));
        map.put("lineNumber", new Integer(n));
        map.put("charStart", new Integer(n2));
        map.put("charEnd", new Integer(n3));
        map.put("org.eclipse.debug.core.persisted", new Boolean(true));
        map.put("org.eclipse.cobol.core.debug.sourceName", new String(string2));
        map.put("org.eclipse.cobol.core.debug.hitCount", new Integer(n4));
        super.setPersisted(true);
    }

    public String getModelIdentifier() {
        COBOLDebugPlugin cOBOLDebugPlugin = COBOLDebugPlugin.getDefault();
        if (cOBOLDebugPlugin != null && cOBOLDebugPlugin.getDescriptor() != null) {
            return cOBOLDebugPlugin.getDescriptor().getUniqueIdentifier();
        }
        return "";
    }

    protected void addToBreakpointManager() throws CoreException {
        COBOLDebugPlugin cOBOLDebugPlugin = COBOLDebugPlugin.getDefault();
        if (cOBOLDebugPlugin != null && cOBOLDebugPlugin.getBreakpointManager() != null) {
            cOBOLDebugPlugin.getBreakpointManager().addBreakpoint((IBreakpoint)this);
        }
    }

    public void setSourceName(Map map, String string) {
        map.put("org.eclipse.cobol.core.debug.sourceName", string);
    }
}

