/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.internal.core;

import java.util.ArrayList;
import org.eclipse.cobol.core.common.ICOBOLDebugModel;
import org.eclipse.cobol.core.debug.model.ICOBOLDebugger;
import org.eclipse.cobol.core.debug.model.ICOBOLThread;
import org.eclipse.cobol.debug.internal.core.COBOLDebugEventHandlerThread;
import org.eclipse.cobol.debug.internal.core.COBOLDebugRequestEventDispatcher;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.ILaunch;

class LaunchRegistry {
    private ILaunch launch = null;
    private IProject fProject = null;
    private String fMode = "";
    private ICOBOLDebugModel fModel = null;
    private COBOLDebugRequestEventDispatcher fEventDispatcher = null;
    private COBOLDebugEventHandlerThread fDebugEventHandler = null;
    private ICOBOLDebugger fDebuggerVM = null;
    private ArrayList threadList = null;

    public LaunchRegistry(ILaunch iLaunch, IProject iProject, ICOBOLDebugModel iCOBOLDebugModel) {
        this.launch = iLaunch;
        this.fProject = iProject;
        this.fModel = iCOBOLDebugModel;
        this.fMode = iLaunch.getLaunchMode();
        this.threadList = new ArrayList();
    }

    public ArrayList getThreadList() {
        return this.threadList;
    }

    public void addThreadToList(ICOBOLThread iCOBOLThread) {
        if (!this.threadList.contains(iCOBOLThread)) {
            this.threadList.add(iCOBOLThread);
        }
    }

    public void removeThread(ICOBOLThread iCOBOLThread) {
        this.threadList.remove(iCOBOLThread);
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public ICOBOLDebugModel getDebugModel() {
        return this.fModel;
    }

    public String getMode() {
        return this.fMode;
    }

    public COBOLDebugRequestEventDispatcher getEventDispatcher() {
        return this.fEventDispatcher;
    }

    public void setEventDispatcher(COBOLDebugRequestEventDispatcher cOBOLDebugRequestEventDispatcher) {
        this.fEventDispatcher = cOBOLDebugRequestEventDispatcher;
    }

    public COBOLDebugEventHandlerThread getEventHandler() {
        return this.fDebugEventHandler;
    }

    public void setEventHandler(COBOLDebugEventHandlerThread cOBOLDebugEventHandlerThread) {
        this.fDebugEventHandler = cOBOLDebugEventHandlerThread;
    }

    public void setCOBOLDebuggerVM(ICOBOLDebugger iCOBOLDebugger) {
        this.fDebuggerVM = iCOBOLDebugger;
    }

    public ICOBOLDebugger getCOBOLDebuggerVM() {
        return this.fDebuggerVM;
    }

    public void cleanRegistry() {
        if (this.fDebuggerVM != null) {
            this.fDebuggerVM.cleanup();
            this.fDebuggerVM = null;
        }
        if (this.fModel != null) {
            this.fModel.cleanup();
            this.fModel = null;
        }
        if (this.launch != null) {
            this.launch.setSourceLocator(null);
            this.launch = null;
        }
        if (this.fDebugEventHandler != null) {
            this.fDebugEventHandler.cleanup();
            this.fDebugEventHandler = null;
        }
        this.fEventDispatcher = null;
        if (this.fProject != null) {
            this.fProject = null;
        }
        if (this.threadList != null) {
            this.threadList.clear();
            this.threadList = null;
        }
    }
}

