/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.internal.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cobol.core.common.ICOBOLDebugModel;
import org.eclipse.cobol.core.debug.model.ICOBOLDebugger;
import org.eclipse.cobol.core.debug.model.ICOBOLThread;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.internal.core.COBOLDebugEventHandlerThread;
import org.eclipse.cobol.debug.internal.core.COBOLDebugRequestEventDispatcher;
import org.eclipse.cobol.debug.internal.core.LaunchRegistry;
import org.eclipse.cobol.debug.internal.core.model.CBDIDebugTarget;
import org.eclipse.cobol.debug.internal.core.model.CBDIThread;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IThread;

public class COBOLLaunchManager
implements ILaunchListener,
IDebugEventSetListener {
    private ArrayList fLaunchRegList = new ArrayList();
    private static COBOLLaunchManager fCOBOLDebugManager = null;
    private ILaunch fLaunch = null;

    private COBOLLaunchManager() {
    }

    public static COBOLLaunchManager getInstance() {
        if (fCOBOLDebugManager == null) {
            fCOBOLDebugManager = new COBOLLaunchManager();
            DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)fCOBOLDebugManager);
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)fCOBOLDebugManager);
        }
        return fCOBOLDebugManager;
    }

    public ArrayList getRegLaunchList() {
        ArrayList<ILaunch> arrayList = new ArrayList<ILaunch>();
        if (this.fLaunchRegList != null) {
            int n = this.fLaunchRegList.size();
            LaunchRegistry launchRegistry = null;
            int n2 = 0;
            while (n2 < n) {
                launchRegistry = (LaunchRegistry)this.fLaunchRegList.get(n2);
                if (launchRegistry.getLaunch() != null) {
                    arrayList.add(launchRegistry.getLaunch());
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public void updateThreadList(ILaunch iLaunch, IThread[] iThreadArray) {
        if (iLaunch == null || iThreadArray == null || iThreadArray.length == 0) {
            return;
        }
        LaunchRegistry launchRegistry = this.exists(iLaunch);
        if (launchRegistry != null) {
            int n = 0;
            while (n < iThreadArray.length) {
                if (iThreadArray[n] != null && iThreadArray[n] instanceof ICOBOLThread) {
                    launchRegistry.addThreadToList((ICOBOLThread)iThreadArray[n]);
                }
                ++n;
            }
        }
    }

    public void register(ILaunch iLaunch, IProject iProject, ICOBOLDebugModel iCOBOLDebugModel) {
        if (this.exists(iLaunch) == null) {
            LaunchRegistry launchRegistry = null;
            launchRegistry = new LaunchRegistry(iLaunch, iProject, iCOBOLDebugModel);
            this.fLaunchRegList.add(launchRegistry);
            iCOBOLDebugModel.setProject(iProject);
            this.fLaunch = iLaunch;
            if ("debug".equalsIgnoreCase(iLaunch.getLaunchMode())) {
                try {
                    launchRegistry.setEventDispatcher(new COBOLDebugRequestEventDispatcher(iLaunch));
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    COBOLDebugPlugin.logTraceMessage(unsatisfiedLinkError.getLocalizedMessage());
                }
                catch (DebugException debugException) {
                    COBOLDebugPlugin.logError((Exception)((Object)debugException));
                }
            }
        }
    }

    public ICOBOLDebugModel getDebugModel(ILaunch iLaunch) {
        LaunchRegistry launchRegistry = this.exists(iLaunch);
        if (launchRegistry != null) {
            return launchRegistry.getDebugModel();
        }
        return null;
    }

    public COBOLDebugRequestEventDispatcher getEventDispatcher(ILaunch iLaunch) {
        LaunchRegistry launchRegistry = this.exists(iLaunch);
        if (launchRegistry != null) {
            return launchRegistry.getEventDispatcher();
        }
        return null;
    }

    public IProject getProject(ILaunch iLaunch) {
        LaunchRegistry launchRegistry = this.exists(iLaunch);
        if (launchRegistry != null) {
            return launchRegistry.getProject();
        }
        return null;
    }

    public void setCOBOLDebuggerVM(ILaunch iLaunch, ICOBOLDebugger iCOBOLDebugger) {
        LaunchRegistry launchRegistry = this.exists(iLaunch);
        if (launchRegistry != null) {
            launchRegistry.setCOBOLDebuggerVM(iCOBOLDebugger);
        }
    }

    public void setCOBOLDebugEventHandlerThread(ILaunch iLaunch, COBOLDebugEventHandlerThread cOBOLDebugEventHandlerThread) {
        LaunchRegistry launchRegistry = this.exists(iLaunch);
        if (launchRegistry != null) {
            launchRegistry.setEventHandler(cOBOLDebugEventHandlerThread);
        }
    }

    public ICOBOLDebugger getCOBOLDebuggerVM(ILaunch iLaunch) {
        LaunchRegistry launchRegistry = this.exists(iLaunch);
        if (launchRegistry != null) {
            return launchRegistry.getCOBOLDebuggerVM();
        }
        return null;
    }

    private LaunchRegistry exists(ILaunch iLaunch) {
        if (iLaunch != null) {
            int n = this.fLaunchRegList.size();
            LaunchRegistry launchRegistry = null;
            int n2 = 0;
            while (n2 < n) {
                launchRegistry = (LaunchRegistry)this.fLaunchRegList.get(n2);
                if (iLaunch.equals(launchRegistry.getLaunch())) {
                    return launchRegistry;
                }
                ++n2;
            }
        }
        return null;
    }

    public void remove(ILaunch iLaunch) {
        if (iLaunch == null) {
            return;
        }
        LaunchRegistry launchRegistry = null;
        int n = 0;
        while (n < this.fLaunchRegList.size()) {
            launchRegistry = (LaunchRegistry)this.fLaunchRegList.get(n);
            if (iLaunch.equals(launchRegistry.getLaunch())) {
                if (iLaunch.getLaunchMode().equalsIgnoreCase("debug")) {
                    launchRegistry.getEventDispatcher().destroy();
                    try {
                        launchRegistry.getEventHandler().notify();
                    }
                    catch (Exception exception) {}
                    ArrayList arrayList = launchRegistry.getThreadList();
                    if (arrayList != null) {
                        int n2 = arrayList.size();
                        ICOBOLThread iCOBOLThread = null;
                        int n3 = 0;
                        while (n3 < n2) {
                            iCOBOLThread = (ICOBOLThread)arrayList.get(n3);
                            if (iCOBOLThread != null && iCOBOLThread instanceof CBDIThread) {
                                ((CBDIThread)iCOBOLThread).fireTerminateEvent();
                            }
                            ++n3;
                        }
                    }
                }
                launchRegistry.cleanRegistry();
                if (this.fLaunch != null && this.fLaunch.equals(iLaunch)) {
                    this.fLaunch = null;
                }
                this.fLaunchRegList.remove(launchRegistry);
            }
            ++n;
        }
    }

    public ILaunch getActiveLaunch() {
        return this.fLaunch;
    }

    public void launchAdded(ILaunch iLaunch) {
    }

    public void launchChanged(ILaunch iLaunch) {
        this.fLaunch = iLaunch;
    }

    public void launchRemoved(ILaunch iLaunch) {
    }

    public void handleDebugEvents(DebugEvent[] debugEventArray) {
        int n = 0;
        while (n < debugEventArray.length) {
            DebugEvent debugEvent = debugEventArray[n];
            Object object = debugEvent.getSource();
            switch (debugEvent.getKind()) {
                case 8: {
                    if (object == null || !(object instanceof CBDIDebugTarget)) break;
                    this.remove(((CBDIDebugTarget)((Object)object)).getLaunch());
                }
            }
            ++n;
        }
    }

    public void cleanup() {
        if (this.fLaunchRegList != null && this.fLaunchRegList.size() > 0) {
            Iterator iterator = this.fLaunchRegList.iterator();
            LaunchRegistry launchRegistry = null;
            while (iterator.hasNext()) {
                launchRegistry = (LaunchRegistry)iterator.next();
                launchRegistry.cleanRegistry();
            }
            this.fLaunchRegList.clear();
            this.fLaunchRegList = null;
        }
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)fCOBOLDebugManager);
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)fCOBOLDebugManager);
        this.fLaunch = null;
        fCOBOLDebugManager = null;
    }
}

