/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.internal.core;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.cobol.core.build.util.IBuildConstants;
import org.eclipse.cobol.core.debug.model.ICOBOLBreakpoint;
import org.eclipse.cobol.core.debug.model.ICOBOLLineBreakpoint;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.internal.core.ArgumentParser;
import org.eclipse.cobol.debug.internal.core.breakpoints.COBOLLineBreakpoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IBreakpoint;

public class COBOLDebugUtil {
    private static boolean fSuspendIsSelected;

    private COBOLDebugUtil() {
    }

    public static String getPluginIdentifier() {
        COBOLDebugPlugin cOBOLDebugPlugin = COBOLDebugPlugin.getDefault();
        if (cOBOLDebugPlugin != null && cOBOLDebugPlugin.getDescriptor() != null) {
            return cOBOLDebugPlugin.getDescriptor().getUniqueIdentifier();
        }
        return "";
    }

    public static COBOLLineBreakpoint createLineBreakpoint(IResource iResource, String string, int n, int n2, int n3, boolean bl, Map map) throws CoreException {
        return new COBOLLineBreakpoint(iResource, n, n2, n3, bl, map);
    }

    public static boolean lineBreakpointExists(String string, int n) throws CoreException {
        String string2 = COBOLDebugUtil.getPluginIdentifier();
        String string3 = COBOLLineBreakpoint.getMarkerType();
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints(string2);
        int n2 = 0;
        while (n2 < iBreakpointArray.length) {
            if (iBreakpointArray[n2] instanceof ICOBOLLineBreakpoint) {
                ICOBOLLineBreakpoint iCOBOLLineBreakpoint = (ICOBOLLineBreakpoint)iBreakpointArray[n2];
                try {
                    if (iCOBOLLineBreakpoint.getMarker().getType().equals(string3) && iCOBOLLineBreakpoint.getSourceName().equals(string) && iCOBOLLineBreakpoint.getLineNumber() == n) {
                        return true;
                    }
                }
                catch (CoreException coreException) {
                    COBOLDebugPlugin.logError((Exception)((Object)coreException));
                }
                catch (NullPointerException nullPointerException) {
                    COBOLDebugPlugin.logError(nullPointerException);
                }
            }
            ++n2;
        }
        return false;
    }

    public static IMarker lineBreakpointMarkerExists(String string, int n) throws CoreException {
        String string2 = COBOLDebugUtil.getPluginIdentifier();
        String string3 = COBOLLineBreakpoint.getMarkerType();
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints(string2);
        int n2 = 0;
        while (n2 < iBreakpointArray.length) {
            if (iBreakpointArray[n2] instanceof ICOBOLLineBreakpoint) {
                ICOBOLLineBreakpoint iCOBOLLineBreakpoint = (ICOBOLLineBreakpoint)iBreakpointArray[n2];
                try {
                    if (iCOBOLLineBreakpoint.getMarker().getType().equals(string3) && iCOBOLLineBreakpoint.getSourceName().equals(string) && iCOBOLLineBreakpoint.getLineNumber() == n) {
                        return iCOBOLLineBreakpoint.getMarker();
                    }
                }
                catch (CoreException coreException) {
                    COBOLDebugPlugin.logError((Exception)((Object)coreException));
                }
                catch (NullPointerException nullPointerException) {
                    COBOLDebugPlugin.logError(nullPointerException);
                }
            }
            ++n2;
        }
        return null;
    }

    public static String getProgramArguments(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = COBOLDebugUtil.getProgramArgumentsAsArray(string);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("\"") && stringArray[n].endsWith("\"") || stringArray[n].startsWith("'") && stringArray[n].endsWith("'")) {
                stringBuffer.append(stringArray[n]);
            } else if (stringArray[n].indexOf(39) != -1) {
                stringBuffer.append('\"').append(stringArray[n]).append('\"');
            } else if (stringArray[n].indexOf(34) != -1) {
                stringBuffer.append('\'').append(stringArray[n]).append('\'');
            } else if (stringArray[n].indexOf(32) != -1 || stringArray[n].length() == 0) {
                stringBuffer.append('\"').append(stringArray[n]).append('\"');
            } else {
                stringBuffer.append(stringArray[n]);
            }
            stringBuffer.append(' ');
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String[] getProgramArgumentsAsArray(String string) {
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        ArgumentParser argumentParser = new ArgumentParser(string);
        String[] stringArray = argumentParser.parseArguments();
        return stringArray;
    }

    public static String getLibraryPath(IProject iProject) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string = new String();
            stringBuffer.append(iProject.getLocation().toOSString());
            string = iProject.getPersistentProperty(IBuildConstants.QUALIFIED_LINKER_OPTIONS);
            if (string != null) {
                ArgumentParser argumentParser = new ArgumentParser(string);
                String[] stringArray = argumentParser.parseLinkerOptions();
                int n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append(System.getProperty("path.separator"));
                    stringBuffer.append(stringArray[n]);
                    ++n;
                }
            }
        }
        catch (CoreException coreException) {
            COBOLDebugPlugin.logError((Exception)((Object)coreException));
        }
        catch (Exception exception) {
            COBOLDebugPlugin.logError(exception);
        }
        return stringBuffer.toString();
    }

    public static File getWorkingDirectory(ILaunchConfiguration iLaunchConfiguration) {
        if (iLaunchConfiguration != null) {
            String string = null;
            try {
                string = iLaunchConfiguration.getAttribute("WorkFolder", null);
            }
            catch (CoreException coreException) {}
            if (string != null && string.trim().length() > 0) {
                return new File(string);
            }
        }
        return null;
    }

    public static String getTargetFilePath(IProject iProject) {
        if (iProject == null) {
            return "";
        }
        String string = null;
        try {
            string = iProject.getPersistentProperty(IBuildConstants.QUALIFIED_TARGET_NAME);
        }
        catch (CoreException coreException) {}
        StringBuffer stringBuffer = null;
        if (string == null || string.trim().length() == 0) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(iProject.getLocation().toOSString()).append(File.separator).append("a.out");
            return stringBuffer.toString();
        }
        stringBuffer = new StringBuffer();
        stringBuffer.append(iProject.getLocation().toOSString()).append(File.separator).append(string);
        if (Platform.getOS().equalsIgnoreCase("win32") && !string.toLowerCase().endsWith(".exe") && !string.toLowerCase().endsWith(".dll")) {
            stringBuffer.append(".exe");
        }
        return stringBuffer.toString();
    }

    public static int getProjectType(IProject iProject) {
        if (iProject == null || !iProject.isAccessible()) {
            return -1;
        }
        String string = null;
        try {
            string = iProject.getPersistentProperty(IBuildConstants.QUALIFIED_TARGET_TYPE);
        }
        catch (CoreException coreException) {
            return -1;
        }
        if (string != null) {
            if (string.equalsIgnoreCase("false")) {
                return 0;
            }
            if (string.equalsIgnoreCase("true")) {
                return 1;
            }
        }
        return -1;
    }

    public static String getTargetName(ILaunchConfiguration iLaunchConfiguration) {
        String string = null;
        if (iLaunchConfiguration != null) {
            try {
                string = iLaunchConfiguration.getAttribute("ExecutableName", "");
            }
            catch (CoreException coreException) {}
            if (string != null) {
                if (Platform.getOS().equalsIgnoreCase("win32") && !string.toLowerCase().endsWith(".exe")) {
                    string = String.valueOf(string) + ".exe";
                }
                return string;
            }
        }
        return "";
    }

    public static String getProgramArguments(ILaunchConfiguration iLaunchConfiguration) {
        try {
            return iLaunchConfiguration.getAttribute("CommandLineParameter", "");
        }
        catch (CoreException coreException) {
            return "";
        }
    }

    public static IProject getProjectFromName(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = null;
        IProject iProject = null;
        if (string.endsWith("*1")) {
            string2 = string.substring(0, string.lastIndexOf("*1"));
            if (string2.length() == 0) {
                return null;
            }
            iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string2);
            if (iProject != null && iProject.isAccessible()) {
                return iProject;
            }
        }
        return null;
    }

    public static File getExternalFolderFromName(String string) {
        Path path;
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = null;
        File file = null;
        if (string.endsWith("*2") && (file = (path = new Path(string2 = string.substring(0, string.lastIndexOf("*2")))).toFile()) != null && file.isDirectory()) {
            return file;
        }
        return null;
    }

    public static boolean isBreakpointOfSourceLookup(IProject iProject, ILaunchConfiguration iLaunchConfiguration, IBreakpoint iBreakpoint) {
        if (iBreakpoint != null && iBreakpoint instanceof ICOBOLBreakpoint) {
            IProject iProject2 = iBreakpoint.getMarker().getResource().getProject();
            if (iProject2 == null) {
                return false;
            }
            if (iProject != null && iProject.equals((Object)iProject2)) {
                return true;
            }
            if (iLaunchConfiguration == null) {
                return false;
            }
            ArrayList arrayList = null;
            try {
                arrayList = (ArrayList)iLaunchConfiguration.getAttribute("SourceLookupList", null);
            }
            catch (CoreException coreException) {}
            if (arrayList == null) {
                return false;
            }
            int n = arrayList.size();
            String string = null;
            IProject iProject3 = null;
            int n2 = 0;
            while (n2 < n) {
                string = (String)arrayList.get(n2);
                if (string.endsWith("*1") && (iProject3 = COBOLDebugUtil.getProjectFromName(string)) != null && iProject3.equals((Object)iProject2)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static List getPersistedVariablesList(ILaunch iLaunch) {
        if (iLaunch == null) {
            return null;
        }
        List list = null;
        try {
            ILaunchConfiguration iLaunchConfiguration = iLaunch.getLaunchConfiguration();
            if (iLaunchConfiguration != null) {
                list = iLaunchConfiguration.getAttribute("VariablesList", list);
            }
        }
        catch (CoreException coreException) {
            COBOLDebugPlugin.logError((Exception)((Object)coreException));
        }
        return list;
    }

    public static void setPersistedVariablesList(ILaunch iLaunch, List list) {
        if (iLaunch == null) {
            return;
        }
        try {
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy;
            ILaunchConfiguration iLaunchConfiguration = iLaunch.getLaunchConfiguration();
            if (iLaunchConfiguration != null && (iLaunchConfigurationWorkingCopy = iLaunchConfiguration.getWorkingCopy()) != null) {
                iLaunchConfigurationWorkingCopy.setAttribute("VariablesList", list);
                iLaunchConfigurationWorkingCopy.doSave();
            }
        }
        catch (CoreException coreException) {
            COBOLDebugPlugin.logError((Exception)((Object)coreException));
        }
    }

    public static void setSuspendIsSelected(boolean bl) {
        fSuspendIsSelected = bl;
    }

    public static boolean isSuspendSelected() {
        return fSuspendIsSelected;
    }

    public static String renderProcessLabel(String string) {
        String string2 = Messages.getString((String)"COBOLRuntimeProcess.{0}_({1})_1");
        String string3 = DateFormat.getDateTimeInstance(1, 2).format(new Date(System.currentTimeMillis()));
        return MessageFormat.format(string2, string, string3);
    }
}

