/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.internal.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.cobol.core.common.ICOBOLDebugModel;
import org.eclipse.cobol.core.debug.exceptions.COBOLDebugException;
import org.eclipse.cobol.core.debug.model.ICOBOLEvent;
import org.eclipse.cobol.core.debug.model.ICOBOLSuspendEvent;
import org.eclipse.cobol.core.debug.model.ICOBOLTextHoverEvent;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.internal.core.COBOLDebugEventHandlerThread;
import org.eclipse.cobol.debug.internal.core.events.COBOLVariableEvent;
import org.eclipse.cobol.debug.internal.core.model.EventQueue;
import org.eclipse.cobol.debug.internal.core.model.Semaphore;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;

public class COBOLDebugRequestEventDispatcher {
    private EventQueue fEventQueue = null;
    private EventQueue fTextHoverEventQueue = null;
    private COBOLDebugEventHandlerThread fDebugThread = null;
    private ILaunch fLaunch = null;
    private ArrayList fSemaPhoreList = new ArrayList();

    public COBOLDebugRequestEventDispatcher(ILaunch iLaunch) throws UnsatisfiedLinkError, DebugException {
        this.fLaunch = iLaunch;
        this.fEventQueue = new EventQueue();
        this.fTextHoverEventQueue = new EventQueue(1);
        Semaphore semaphore = new Semaphore(Thread.currentThread());
        this.fDebugThread = new COBOLDebugEventHandlerThread(this.fEventQueue, this.fTextHoverEventQueue, iLaunch, semaphore);
        this.fDebugThread.setName("COBOLDebugEventHandlerThread");
        this.fDebugThread.start();
        try {
            semaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            throw COBOLDebugException.createCOBOLDebugException((Exception)interruptedException, (String)COBOLDebugPlugin.getDefault().getDescriptor().getUniqueIdentifier());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(ICOBOLEvent iCOBOLEvent) {
        if (this.fEventQueue != null && this.fDebugThread != null) {
            Object object;
            if (iCOBOLEvent instanceof ICOBOLSuspendEvent) {
                object = new Vector();
                ICOBOLEvent iCOBOLEvent22 = null;
                for (ICOBOLEvent iCOBOLEvent22 : this.fEventQueue.getAllEvents()) {
                    if (!(iCOBOLEvent22 instanceof COBOLVariableEvent) || !((COBOLVariableEvent)iCOBOLEvent22).isFromPersistence()) continue;
                    ((Vector)object).add(iCOBOLEvent22);
                }
                this.fEventQueue.removeAllEvents();
                Iterator iterator = ((Vector)object).iterator();
                while (iterator.hasNext()) {
                    this.fEventQueue.addEvent(iterator.next());
                }
                ((Vector)object).clear();
                object = null;
            }
            this.fEventQueue.addEvent(iCOBOLEvent);
            object = this.fDebugThread;
            synchronized (object) {
                this.fDebugThread.notify();
            }
            if (iCOBOLEvent.isWaitForEvent()) {
                object = new Semaphore(Thread.currentThread());
                this.acquire((Semaphore)object, iCOBOLEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fireTextHoverEvent(ICOBOLEvent iCOBOLEvent) {
        ICOBOLDebugModel iCOBOLDebugModel;
        if (this.fDebugThread == null) {
            return false;
        }
        if (iCOBOLEvent instanceof ICOBOLTextHoverEvent && this.fTextHoverEventQueue != null && !this.fDebugThread.isBusy()) {
            this.fTextHoverEventQueue.removeAllEvents();
            this.fTextHoverEventQueue.addEvent(iCOBOLEvent);
            COBOLDebugEventHandlerThread cOBOLDebugEventHandlerThread = this.fDebugThread;
            synchronized (cOBOLDebugEventHandlerThread) {
                this.fDebugThread.notify();
            }
            return true;
        }
        if (iCOBOLEvent.getSource() != null && (iCOBOLDebugModel = COBOLDebugPlugin.getDefault().getCOBOLLaunchManager().getDebugModel(this.fLaunch)) != null) {
            iCOBOLDebugModel.setTextHover("");
        }
        return false;
    }

    public void destroy() {
        if (this.fDebugThread != null) {
            this.fDebugThread.terminate();
            this.fDebugThread = null;
        }
        if (this.fSemaPhoreList != null) {
            this.fSemaPhoreList.clear();
            this.fSemaPhoreList = null;
        }
        this.cleanup();
    }

    public void cleanup() {
        if (this.fEventQueue != null) {
            this.fEventQueue.removeAllEvents();
            this.fEventQueue = null;
        }
        if (this.fTextHoverEventQueue != null) {
            this.fTextHoverEventQueue.removeAllEvents();
            this.fTextHoverEventQueue = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() {
        COBOLDebugRequestEventDispatcher cOBOLDebugRequestEventDispatcher = this;
        synchronized (cOBOLDebugRequestEventDispatcher) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public boolean isEventAddedToSemaphore(ICOBOLEvent iCOBOLEvent) {
        if (iCOBOLEvent == null) {
            return true;
        }
        if (this.fSemaPhoreList != null) {
            int n = this.fSemaPhoreList.size();
            SemaPhoreList semaPhoreList = null;
            int n2 = 0;
            while (n2 < n) {
                semaPhoreList = (SemaPhoreList)this.fSemaPhoreList.get(n2);
                if (semaPhoreList.isMatch(iCOBOLEvent)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private synchronized void acquire(Semaphore semaphore, ICOBOLEvent iCOBOLEvent) {
        if (semaphore != null && iCOBOLEvent != null) {
            SemaPhoreList semaPhoreList = null;
            semaPhoreList = new SemaPhoreList(semaphore, iCOBOLEvent);
            this.fSemaPhoreList.add(semaPhoreList);
            try {
                semaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                this.fSemaPhoreList.remove(semaPhoreList);
            }
        }
    }

    public void release(ICOBOLEvent iCOBOLEvent) {
        int n = 0;
        while (n < this.fSemaPhoreList.size()) {
            SemaPhoreList semaPhoreList = (SemaPhoreList)this.fSemaPhoreList.get(n);
            if (semaPhoreList.isMatch(iCOBOLEvent)) {
                semaPhoreList.getSemaphore().release();
                this.fSemaPhoreList.remove(semaPhoreList);
            }
            ++n;
        }
    }

    public void releaseAll() {
        if (this.fSemaPhoreList != null) {
            SemaPhoreList semaPhoreList = null;
            int n = 0;
            while (n < this.fSemaPhoreList.size()) {
                semaPhoreList = (SemaPhoreList)this.fSemaPhoreList.get(n);
                semaPhoreList.getSemaphore().release();
                this.fSemaPhoreList.remove(semaPhoreList);
                ++n;
            }
        }
    }

    class SemaPhoreList {
        Semaphore fSemaphore = null;
        ICOBOLEvent event = null;

        public SemaPhoreList(Semaphore semaphore, ICOBOLEvent iCOBOLEvent) {
            this.fSemaphore = semaphore;
            this.event = iCOBOLEvent;
        }

        public Semaphore getSemaphore() {
            return this.fSemaphore;
        }

        public boolean isMatch(ICOBOLEvent iCOBOLEvent) {
            return this.event.equals(iCOBOLEvent);
        }
    }
}

