/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.internal.core;

import org.eclipse.cobol.core.common.ICOBOLDebugModel;
import org.eclipse.cobol.core.debug.model.ICOBOLDebugEventHandler;
import org.eclipse.cobol.core.debug.model.ICOBOLDebugger;
import org.eclipse.cobol.core.debug.model.ICOBOLEvent;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.internal.core.COBOLDebugRequestEventDispatcher;
import org.eclipse.cobol.debug.internal.core.model.EventQueue;
import org.eclipse.cobol.debug.internal.core.model.Semaphore;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.EditorActionBarContributor;

public class COBOLDebugEventHandlerThread
extends Thread {
    private boolean fRunning = true;
    private ICOBOLDebugger fCobolDebugger = null;
    private EventQueue fEventQueue;
    private EventQueue fTextHoverEventQueue;
    private static IStatusLineManager fStatusMgr = null;
    private ICOBOLEvent fEvent;
    private boolean fIsBusy;
    private ILaunch fLaunch = null;
    private Semaphore fSemaphore = null;

    public COBOLDebugEventHandlerThread(EventQueue eventQueue, EventQueue eventQueue2, ILaunch iLaunch, Semaphore semaphore) throws UnsatisfiedLinkError, DebugException {
        this.fEventQueue = eventQueue;
        this.fTextHoverEventQueue = eventQueue2;
        this.fEvent = null;
        this.fIsBusy = false;
        this.fLaunch = iLaunch;
        this.fSemaphore = semaphore;
    }

    private ICOBOLDebugger initializeDebuggerVM() {
        ICOBOLDebugger iCOBOLDebugger;
        block8: {
            iCOBOLDebugger = null;
            try {
                try {
                    COBOLDebugPlugin.getDefault().getCOBOLLaunchManager().setCOBOLDebugEventHandlerThread(this.fLaunch, this);
                    ICOBOLDebugModel iCOBOLDebugModel = COBOLDebugPlugin.getDefault().getCOBOLLaunchManager().getDebugModel(this.fLaunch);
                    iCOBOLDebugger = iCOBOLDebugModel.getDebuggerVM();
                    COBOLDebugPlugin.getDefault().getCOBOLLaunchManager().setCOBOLDebuggerVM(this.fLaunch, iCOBOLDebugger);
                }
                catch (Exception exception) {
                    COBOLDebugPlugin.logError(exception);
                    if (this.fSemaphore != null) {
                        this.fSemaphore.release();
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (this.fSemaphore != null) {
                    this.fSemaphore.release();
                }
                throw throwable;
            }
            if (this.fSemaphore != null) {
                this.fSemaphore.release();
            }
        }
        this.fCobolDebugger = iCOBOLDebugger;
        return iCOBOLDebugger;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void cleanup() {
        if (this.fEventQueue != null) {
            this.fEventQueue.removeAllEvents();
            this.fEventQueue = null;
        }
        if (this.fCobolDebugger != null) {
            this.fCobolDebugger.cleanup();
            this.fCobolDebugger = null;
        }
        if (this.fLaunch != null) {
            this.fLaunch = null;
        }
        if (this.fSemaphore != null) {
            this.fSemaphore.release();
            this.fSemaphore = null;
        }
        if (fStatusMgr != null) {
            fStatusMgr = null;
        }
        if (this.fTextHoverEventQueue != null) {
            this.fTextHoverEventQueue.removeAllEvents();
            this.fTextHoverEventQueue = null;
        }
        if (this.fEvent != null) {
            this.fEvent = null;
        }
    }

    public boolean isRunning() {
        return this.fRunning;
    }

    public void setRunning(boolean bl) {
        this.fRunning = bl;
    }

    public void terminate() {
        this.releaseAll();
        this.fEventQueue.removeAllEvents();
        COBOLDebugPlugin.getCOBOLVariableManager().clear();
        this.fRunning = false;
    }

    private void handleEvent(ICOBOLEvent iCOBOLEvent) {
        try {
            if (iCOBOLEvent.getHandler() != null) {
                this.waitTillSemaphoreAddition(iCOBOLEvent);
                iCOBOLEvent.getHandler().processEvent(iCOBOLEvent);
            } else {
                ICOBOLDebugEventHandler iCOBOLDebugEventHandler = null;
                iCOBOLDebugEventHandler = this.getDebugEventHandler(iCOBOLEvent);
                if (iCOBOLDebugEventHandler != null) {
                    this.waitTillSemaphoreAddition(iCOBOLEvent);
                    iCOBOLDebugEventHandler.processEvent(iCOBOLEvent);
                }
            }
        }
        catch (Exception exception) {
            this.messageHandling(exception);
        }
        this.release(iCOBOLEvent);
    }

    private void waitTillSemaphoreAddition(ICOBOLEvent iCOBOLEvent) {
        COBOLDebugRequestEventDispatcher cOBOLDebugRequestEventDispatcher;
        if (iCOBOLEvent != null && iCOBOLEvent.isWaitForEvent() && (cOBOLDebugRequestEventDispatcher = COBOLDebugPlugin.getDefault().getCOBOLLaunchManager().getEventDispatcher(this.fLaunch)) != null) {
            try {
                while (!cOBOLDebugRequestEventDispatcher.isEventAddedToSemaphore(iCOBOLEvent)) {
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void showDialog(final String string, final String string2) {
        if (Display.getDefault() == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (COBOLDebugPlugin.getDefault() != null) {
                    Shell shell = COBOLDebugPlugin.getActiveWorkbenchShell();
                    if (shell == null) {
                        shell = Display.getDefault().getActiveShell();
                    }
                    if (shell != null) {
                        try {
                            MessageDialog.openError((Shell)shell, (String)string, (String)string2);
                        }
                        catch (Exception exception) {
                            COBOLDebugPlugin.logError(exception);
                        }
                    }
                }
            }
        });
    }

    public void showMessage(String string, Exception exception) {
        if (exception != null && exception instanceof DebugException) {
            if (((DebugException)exception).getStatus().getSeverity() == 4) {
                this.showDialog(string, exception.getLocalizedMessage());
                COBOLDebugEventHandlerThread.setDebugStatusErrorMessage(exception.getLocalizedMessage());
            } else {
                COBOLDebugEventHandlerThread.setDebugStatusMessage(exception.getLocalizedMessage());
            }
        }
    }

    public static void setDebugStatusErrorMessage(final String string) {
        if (Display.getDefault() == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow iWorkbenchWindow;
                if (COBOLDebugPlugin.getDefault() != null && (iWorkbenchWindow = COBOLDebugPlugin.getActiveWorkbenchWindow()) != null) {
                    try {
                        if (fStatusMgr == null) {
                            EditorActionBarContributor editorActionBarContributor = (EditorActionBarContributor)iWorkbenchWindow.getActivePage().getActiveEditor().getEditorSite().getActionBarContributor();
                            fStatusMgr = editorActionBarContributor.getActionBars().getStatusLineManager();
                        }
                        fStatusMgr.setErrorMessage(null);
                        fStatusMgr.setErrorMessage(string);
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (Exception exception) {
                        COBOLDebugPlugin.logError(exception);
                    }
                }
            }
        });
    }

    public static void setDebugStatusMessage(final String string) {
        if (Display.getDefault() == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow iWorkbenchWindow;
                if (COBOLDebugPlugin.getDefault() != null && (iWorkbenchWindow = COBOLDebugPlugin.getActiveWorkbenchWindow()) != null) {
                    try {
                        if (fStatusMgr == null) {
                            EditorActionBarContributor editorActionBarContributor = (EditorActionBarContributor)iWorkbenchWindow.getActivePage().getActiveEditor().getEditorSite().getActionBarContributor();
                            fStatusMgr = editorActionBarContributor.getActionBars().getStatusLineManager();
                        }
                        fStatusMgr.setMessage(null);
                        fStatusMgr.setMessage(string);
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (Exception exception) {
                        COBOLDebugPlugin.logError(exception);
                    }
                }
            }
        });
    }

    public boolean isBusy() {
        return this.fIsBusy;
    }

    private void release(ICOBOLEvent iCOBOLEvent) {
        COBOLDebugRequestEventDispatcher cOBOLDebugRequestEventDispatcher;
        if (iCOBOLEvent != null && iCOBOLEvent.isWaitForEvent() && (cOBOLDebugRequestEventDispatcher = COBOLDebugPlugin.getDefault().getCOBOLLaunchManager().getEventDispatcher(this.fLaunch)) != null) {
            cOBOLDebugRequestEventDispatcher.release(iCOBOLEvent);
        }
    }

    private void releaseAll() {
        COBOLDebugRequestEventDispatcher cOBOLDebugRequestEventDispatcher = COBOLDebugPlugin.getDefault().getCOBOLLaunchManager().getEventDispatcher(this.fLaunch);
        if (cOBOLDebugRequestEventDispatcher != null) {
            cOBOLDebugRequestEventDispatcher.releaseAll();
        }
    }

    private void messageHandling(final Exception exception) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (COBOLDebugEventHandlerThread.this.fCobolDebugger != null) {
                    COBOLDebugEventHandlerThread.this.fCobolDebugger.exceptionHandling(exception);
                }
            }
        });
    }

    private ICOBOLDebugEventHandler getDebugEventHandler(ICOBOLEvent iCOBOLEvent) {
        ICOBOLDebugModel iCOBOLDebugModel = COBOLDebugPlugin.getDefault().getCOBOLLaunchManager().getDebugModel(this.fLaunch);
        if (iCOBOLDebugModel != null) {
            return iCOBOLDebugModel.getDebugEventHandler(iCOBOLEvent);
        }
        return null;
    }
}

