/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.core;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.cobol.debug.internal.core.COBOLDebugRequestEventDispatcher;
import org.eclipse.cobol.debug.internal.core.COBOLLaunchManager;
import org.eclipse.cobol.debug.internal.core.model.COBOLBreakpointManager;
import org.eclipse.cobol.debug.internal.core.model.COBOLDebugEventManager;
import org.eclipse.cobol.debug.internal.core.model.COBOLVariableManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class COBOLDebugPlugin
extends AbstractUIPlugin {
    private String fSVDPath = "";
    private static COBOLDebugPlugin plugin = null;
    private ResourceBundle resourceBundle;
    private static COBOLVariableManager fCOBOLVariableManager = null;
    private static COBOLBreakpointManager fBreakpointManager = new COBOLBreakpointManager();
    private static COBOLDebugEventManager fCOBOLDebugEventManager = null;
    public static final int INTERNAL_ERROR = 29;
    private boolean fTrace = true;
    private static IStatusLineManager fStatusMgr = null;
    private HashMap fVariableTypes;
    int[] fStringDataTypes;
    public static QualifiedName DEBUG_RELEASE_MODE = new QualifiedName("org.eclipse.cobol.ui.common", "BuildMode");
    private static final String VARIABLEACTION_CLASS = "org.eclipse.cobol.debug.internal.core.model.COBOLVariableManager";

    public COBOLDebugPlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
        plugin = this;
        this.fVariableTypes = null;
        this.fStringDataTypes = null;
        this.initializeStringDataTypesCache();
        this.initializeVariableTypes();
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.cobol.debug.Plugin");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static String getPluginId() {
        try {
            return COBOLDebugPlugin.getDefault().getDescriptor().getUniqueIdentifier();
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugPlugin.logError(nullPointerException);
            return "";
        }
    }

    public static COBOLDebugPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String string) {
        ResourceBundle resourceBundle = COBOLDebugPlugin.getDefault().getResourceBundle();
        try {
            if (resourceBundle != null) {
                return resourceBundle.getString(string);
            }
        }
        catch (MissingResourceException missingResourceException) {
            COBOLDebugPlugin.logError(missingResourceException);
        }
        return string;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        try {
            return COBOLDebugPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static IWorkbenchPage getActivePage() {
        try {
            return COBOLDebugPlugin.getActiveWorkbenchWindow().getActivePage();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow iWorkbenchWindow = COBOLDebugPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        Shell[] shellArray = iWorkbenchWindow.getShell().getShells();
        if (shellArray != null && shellArray.length > 0) {
            return shellArray[shellArray.length - 1];
        }
        return iWorkbenchWindow.getShell();
    }

    public static void logError(Exception exception) {
        try {
            DebugException debugException;
            IStatus iStatus;
            Throwable throwable = exception;
            if (exception instanceof DebugException && (iStatus = (debugException = (DebugException)exception).getStatus()).getException() != null) {
                throwable = iStatus.getException();
            }
            COBOLDebugPlugin.log((IStatus)new Status(4, COBOLDebugPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 29, COBOLDebugPlugin.getResourceString("Internal_error_logged_from__Cobol_Debug___2"), throwable));
        }
        catch (Exception exception2) {
            exception2.printStackTrace();
        }
    }

    public static void logError(Exception exception, String string) {
        try {
            if (COBOLDebugPlugin.getDefault().isDebugging()) {
                DebugException debugException;
                IStatus iStatus;
                Throwable throwable = exception;
                if (exception instanceof DebugException && (iStatus = (debugException = (DebugException)exception).getStatus()).getException() != null) {
                    throwable = iStatus.getException();
                }
                COBOLDebugPlugin.log((IStatus)new Status(4, COBOLDebugPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 29, string, throwable));
            }
        }
        catch (Exception exception2) {
            exception2.printStackTrace();
        }
    }

    public static void log(IStatus iStatus) {
        if (COBOLDebugPlugin.getDefault().getLog() != null) {
            COBOLDebugPlugin.getDefault().getLog().log(iStatus);
        }
    }

    public static void logTraceMessage(String string) {
        try {
            if (COBOLDebugPlugin.getDefault().isTrace()) {
                Status status = new Status(1, COBOLDebugPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 29, string, null);
                COBOLDebugPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setTrace(boolean bl) {
        this.fTrace = bl;
    }

    public boolean isTrace() {
        return this.fTrace;
    }

    public static COBOLVariableManager getCOBOLVariableManager() {
        ClassLoader classLoader;
        if (fCOBOLVariableManager == null && (classLoader = Platform.getPluginRegistry().getPluginDescriptor("org.eclipse.cobol.debug.ui").getPluginClassLoader()) != null) {
            try {
                fCOBOLVariableManager = (COBOLVariableManager)classLoader.loadClass(VARIABLEACTION_CLASS).newInstance();
                System.out.println("trying to print in coboldebugplugin" + fCOBOLVariableManager.toString());
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        return fCOBOLVariableManager;
    }

    public static COBOLDebugEventManager getCOBOLDebugEventManager() {
        if (fCOBOLDebugEventManager == null) {
            fCOBOLDebugEventManager = new COBOLDebugEventManager();
        }
        return fCOBOLDebugEventManager;
    }

    public static COBOLDebugRequestEventDispatcher getEventDispatcher(ILaunch iLaunch) {
        return COBOLDebugPlugin.getDefault().getCOBOLLaunchManager().getEventDispatcher(iLaunch);
    }

    public void shutdown() throws CoreException {
        try {
            ILaunch[] iLaunchArray;
            ILaunchManager iLaunchManager;
            if (DebugPlugin.getDefault() != null && (iLaunchManager = DebugPlugin.getDefault().getLaunchManager()) != null && (iLaunchArray = iLaunchManager.getLaunches()) != null && iLaunchArray.length > 0) {
                int n = 0;
                while (n < iLaunchArray.length) {
                    if (iLaunchArray[n] != null && !iLaunchArray[n].isTerminated() && iLaunchArray[n].getLaunchConfiguration().getType().equals(iLaunchManager.getLaunchConfigurationType("org.eclipse.cobol.debug.ui.launcher.COBOLLaunchConfigurationDelegate"))) {
                        iLaunchArray[n].terminate();
                    }
                    ++n;
                }
            }
            this.fStringDataTypes = null;
            this.clearVariableTypesCache();
            if (fCOBOLDebugEventManager != null) {
                fCOBOLDebugEventManager.shutdown();
                fCOBOLDebugEventManager = null;
            }
            if (fCOBOLVariableManager != null) {
                fCOBOLVariableManager.shutdown();
                fCOBOLVariableManager = null;
            }
            if (fBreakpointManager != null) {
                fBreakpointManager.shutdown();
            }
            this.getCOBOLLaunchManager().cleanup();
            super.shutdown();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public static void setDebugStatusMessage(String string) {
        try {
            if (fStatusMgr == null) {
                EditorActionBarContributor editorActionBarContributor = (EditorActionBarContributor)COBOLDebugPlugin.getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getActionBarContributor();
                fStatusMgr = editorActionBarContributor.getActionBars().getStatusLineManager();
            }
            fStatusMgr.setMessage(null);
            fStatusMgr.setMessage(string);
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugPlugin.logError(nullPointerException);
        }
    }

    public static void showErrorDialog(String string, String string2) {
        MessageDialog.openError((Shell)COBOLDebugPlugin.getActiveWorkbenchShell(), (String)string, (String)string2);
    }

    public void initializeVariableTypes() {
        Enumeration enumeration = Messages.getKeys();
        if (enumeration != null) {
            String string = "";
            String string2 = "";
            this.fVariableTypes = new HashMap();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                string2 = Messages.getString((String)string);
                if (string2 == null) {
                    string2 = "";
                }
                if (!string.equals("")) {
                    this.fVariableTypes.put(string, string2);
                }
                string = "";
                string2 = "";
            }
        }
    }

    public String getVariableTypeText(String string) {
        String string2 = "";
        if (this.fVariableTypes != null && this.fVariableTypes.size() > 0) {
            string2 = (String)this.fVariableTypes.get(string);
        }
        return string2;
    }

    public void clearVariableTypesCache() {
        if (this.fVariableTypes != null && this.fVariableTypes.size() > 0) {
            this.fVariableTypes.clear();
        }
        this.fVariableTypes = null;
    }

    public void initializeStringDataTypesCache() {
        String string = Messages.getString((String)"StringDataTypes");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = 0;
            this.fStringDataTypes = new int[stringTokenizer.countTokens()];
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    this.fStringDataTypes[n++] = Integer.parseInt(string2, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    COBOLDebugPlugin.logError(numberFormatException);
                }
            }
        }
    }

    public int[] getStringDataTypes() {
        return this.fStringDataTypes;
    }

    public COBOLBreakpointManager getBreakpointManager() {
        if (fBreakpointManager == null) {
            fBreakpointManager = new COBOLBreakpointManager();
        }
        return fBreakpointManager;
    }

    public COBOLLaunchManager getCOBOLLaunchManager() {
        return COBOLLaunchManager.getInstance();
    }

    public void findSVDPath(IResource iResource) {
        try {
            int n;
            Object object;
            IProject iProject;
            if (iResource instanceof IProject) {
                iProject = (IProject)((IAdaptable)iResource.getAdapter(IProject.class));
                object = iProject.members(false);
                n = 0;
                while (n < ((IResource[])object).length) {
                    this.findSVDPath((IResource)object[n]);
                    ++n;
                }
            }
            if (iResource instanceof IFolder) {
                iProject = (IFolder)((IAdaptable)iResource.getAdapter(IFolder.class));
                object = iProject.members(false);
                n = 0;
                while (n < ((Object)object).length) {
                    this.findSVDPath((IResource)object[n]);
                    ++n;
                }
            }
            if (iResource instanceof IFile && (object = (iProject = (IFile)iResource).getFileExtension()) != null && ((String)object).toLowerCase() != null && ((String)object).toLowerCase().equalsIgnoreCase("svd") && this.fSVDPath.indexOf(String.valueOf(iProject.getParent().getLocation().toString()) + File.pathSeparator) == -1) {
                this.fSVDPath = String.valueOf(this.fSVDPath) + iProject.getParent().getLocation().toString() + File.pathSeparator;
            }
        }
        catch (CoreException coreException) {
            MessageDialog.openError((Shell)COBOLDebugPlugin.getActiveWorkbenchShell(), (String)coreException.toString(), (String)coreException.getMessage());
        }
        catch (ClassCastException classCastException) {}
    }

    public String getSVDPath(IProject iProject) {
        this.fSVDPath = "";
        this.findSVDPath((IResource)iProject);
        if (this.fSVDPath.length() > 0) {
            this.fSVDPath = this.fSVDPath.substring(0, this.fSVDPath.length() - 1);
        }
        return this.fSVDPath;
    }
}

