/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.indexdiff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitResourceDeltaVisitor
implements IResourceDeltaVisitor {
    private static final String GITIGNORE_NAME = ".gitignore";
    private static int INTERESTING_CHANGES = 323840;
    private final Repository repository;
    private final Collection<String> filesToUpdate;
    private final Collection<IResource> resourcesToUpdate;
    private boolean gitIgnoreChanged = false;

    public GitResourceDeltaVisitor(Repository repository) {
        this.repository = repository;
        this.filesToUpdate = new HashSet<String>();
        this.resourcesToUpdate = new HashSet<IResource>();
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        RepositoryMapping mapping = RepositoryMapping.getMapping(resource);
        if (mapping == null || mapping.getRepository() != this.repository) {
            return true;
        }
        IndexDiffCache cache = Activator.getDefault().getIndexDiffCache();
        IndexDiffCacheEntry entry = null;
        if (cache != null) {
            entry = cache.getIndexDiffCacheEntry(mapping.getRepository());
        }
        if (resource instanceof IFolder && delta.getKind() == 1) {
            String path = String.valueOf(mapping.getRepoRelativePath(resource)) + "/";
            if (this.isIgnoredInOldIndex(entry, path)) {
                return true;
            }
            this.filesToUpdate.add(path);
            this.resourcesToUpdate.add(resource);
            return true;
        }
        if (delta.getKind() == 4 && (delta.getFlags() & INTERESTING_CHANGES) == 0) {
            return true;
        }
        if (resource.getType() != 1) {
            return true;
        }
        if (resource.getName().equals(GITIGNORE_NAME)) {
            this.gitIgnoreChanged = true;
            return false;
        }
        String repoRelativePath = mapping.getRepoRelativePath(resource);
        if (repoRelativePath == null) {
            this.resourcesToUpdate.add(resource);
            return true;
        }
        if (this.isIgnoredInOldIndex(entry, repoRelativePath)) {
            return false;
        }
        this.filesToUpdate.add(repoRelativePath);
        this.resourcesToUpdate.add(resource);
        return true;
    }

    private boolean isIgnoredInOldIndex(IndexDiffCacheEntry entry, String path) {
        if (entry == null || this.gitIgnoreChanged) {
            return false;
        }
        IndexDiffData indexDiff = entry.getIndexDiff();
        if (indexDiff == null) {
            return false;
        }
        String p = path;
        Set<String> ignored = indexDiff.getIgnoredNotInIndex();
        while (p != null) {
            if (ignored.contains(p)) {
                return true;
            }
            p = this.skipLastSegment(p);
        }
        return false;
    }

    private String skipLastSegment(String path) {
        int slashPos = path.lastIndexOf(47);
        return slashPos == -1 ? null : path.substring(0, slashPos);
    }

    public Collection<IFile> getFileResourcesToUpdate() {
        ArrayList<IFile> result = new ArrayList<IFile>();
        for (IResource resource : this.resourcesToUpdate) {
            if (!(resource instanceof IFile)) continue;
            result.add((IFile)resource);
        }
        return result;
    }

    public Collection<IResource> getResourcesToUpdate() {
        return this.resourcesToUpdate;
    }

    public Collection<String> getFilesToUpdate() {
        return this.filesToUpdate;
    }

    public boolean getGitIgnoreChanged() {
        return this.gitIgnoreChanged;
    }
}

