/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevUtils {
    private RevUtils() {
    }

    public static RevCommit getCommonAncestor(Repository repo, AnyObjectId commit1, AnyObjectId commit2) throws IOException {
        Assert.isNotNull((Object)repo);
        Assert.isNotNull((Object)commit1);
        Assert.isNotNull((Object)commit2);
        RevWalk rw = new RevWalk(repo);
        try {
            rw.setRetainBody(false);
            rw.setRevFilter(RevFilter.MERGE_BASE);
            RevCommit srcRev = rw.lookupCommit(commit1);
            RevCommit dstRev = rw.lookupCommit(commit2);
            rw.markStart(dstRev);
            rw.markStart(srcRev);
            RevCommit result = rw.next();
            if (result != null) {
                rw.parseBody((RevObject)result);
                RevCommit revCommit = result;
                return revCommit;
            }
            return null;
        }
        finally {
            rw.release();
        }
    }

    public static ConflictCommits getConflictCommits(Repository repository, String path) throws IOException {
        RevWalk walk = new RevWalk(repository);
        try {
            List mergeHeads;
            RevCommit theirCommit = null;
            walk.setTreeFilter(AndTreeFilter.create((TreeFilter)PathFilter.create((String)path), (TreeFilter)TreeFilter.ANY_DIFF));
            RevCommit head = walk.parseCommit((AnyObjectId)repository.resolve("HEAD"));
            walk.markStart(head);
            RevCommit ourCommit = walk.next();
            RepositoryState state = repository.getRepositoryState();
            if (state == RepositoryState.REBASING || state == RepositoryState.CHERRY_PICKING) {
                ObjectId cherryPickHead = repository.readCherryPickHead();
                if (cherryPickHead != null) {
                    RevCommit cherryPickCommit;
                    theirCommit = cherryPickCommit = walk.parseCommit((AnyObjectId)cherryPickHead);
                }
            } else if (state == RepositoryState.MERGING && (mergeHeads = repository.readMergeHeads()).size() == 1) {
                ObjectId mergeHead = (ObjectId)mergeHeads.get(0);
                RevCommit mergeCommit = walk.parseCommit((AnyObjectId)mergeHead);
                walk.reset();
                walk.markStart(mergeCommit);
                theirCommit = walk.next();
            }
            ConflictCommits conflictCommits = new ConflictCommits(ourCommit, theirCommit);
            return conflictCommits;
        }
        finally {
            walk.release();
        }
    }

    public static boolean isContainedInAnyRef(Repository repo, ObjectId commitId, Collection<Ref> refs) throws IOException {
        for (Ref ref : refs) {
            if (!commitId.equals((AnyObjectId)ref.getObjectId())) continue;
            return true;
        }
        RevWalk walk = new RevWalk(repo);
        try {
            RevCommit commit = walk.parseCommit((AnyObjectId)commitId);
            for (Ref ref : refs) {
                boolean contained;
                RevCommit refCommit = walk.parseCommit((AnyObjectId)ref.getObjectId());
                if (refCommit.getCommitTime() + 86400 < commit.getCommitTime() || !(contained = walk.isMergedInto(commit, refCommit))) continue;
                return true;
            }
        }
        finally {
            walk.dispose();
        }
        return false;
    }

    public static class ConflictCommits {
        private final RevCommit ourCommit;
        private final RevCommit theirCommit;

        private ConflictCommits(RevCommit ourCommit, RevCommit theirCommit) {
            this.ourCommit = ourCommit;
            this.theirCommit = theirCommit;
        }

        public RevCommit getOurCommit() {
            return this.ourCommit;
        }

        public RevCommit getTheirCommit() {
            return this.theirCommit;
        }
    }
}

